/*
 * #%L
 * $Id: BetaLayerUI.java 3585 2012-08-08 14:52:14Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.7/lima-swing/src/main/java/org/chorem/lima/ui/BetaLayerUI.java $
 * %%
 * Copyright (C) 2012 Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;

import javax.swing.JComponent;

import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.AbstractLayerUI;

/**
 * Layer qui affiche "beta version".
 * 
 * @author chatellier
 * @version $Revision: 3585 $
 * 
 * Last update : $Date: 2012-08-08 16:52:14 +0200 (Wed, 08 Aug 2012) $
 * By : $Author: tchemit $
 */
public class BetaLayerUI extends AbstractLayerUI<JComponent> {

    /** serialVersionUID. */
    private static final long serialVersionUID = 309245880711380974L;

    @Override
    protected void paintLayer(Graphics2D g2, JXLayer<? extends JComponent> l) {
        super.paintLayer(g2, l);

        // position
        //g2.translate(-35, 90); // top left
        g2.translate(l.getBounds().getMaxX() - 140, l.getBounds().getMaxY()); // bottom right

        // yellow backgroung 
        g2.rotate(Math.PI * -42 / 180);
        g2.setColor(Color.YELLOW);
        g2.fillRect(10, 10, 170, 30);

        // text
        g2.translate(30, 15);
        g2.setFont(new Font("Dialog", Font.BOLD, 16));
        g2.setColor(Color.BLACK);
        g2.drawString("Beta version",10,10);
        
        // for test only
        g2.translate(15, 10);
        g2.setFont(new Font("Dialog", Font.ITALIC, 10));
        g2.setColor(Color.BLACK);
        g2.drawString("(for test only)",10,10);
    }
}
