/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.vatchart;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.tree.TreePath;
import org.chorem.lima.entity.VatStatement;
import org.chorem.lima.ui.vatchart.VatChartViewHandler;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.treetable.TreeTableModel;

public class VatChartTreeTable
extends JXTreeTable
implements KeyListener,
MouseListener {
    private static final long serialVersionUID = 3960840343197845825L;
    protected VatChartViewHandler handler;
    private Highlighter colorLine;

    public VatChartTreeTable(VatChartViewHandler handler) {
        this.handler = handler;
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMissingBoxNameColor();
    }

    private void addMissingBoxNameColor() {
        if (this.colorLine != null) {
            this.removeHighlighter(this.colorLine);
        }
        HighlightPredicate predicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                VatChartTreeTable treeTable = VatChartTreeTable.this.handler.view.getTreeTable();
                TreeTableModel treeTableModel = treeTable.getTreeTableModel();
                TreePath treePath = treeTable.getPathForRow(adapter.row);
                VatStatement vatStatement = (VatStatement)treePath.getLastPathComponent();
                boolean highlighted = false;
                if (vatStatement.getBoxName() != null) {
                    if (treeTableModel.isLeaf((Object)vatStatement) && vatStatement.getBoxName().isEmpty()) {
                        highlighted = true;
                    }
                } else {
                    highlighted = true;
                }
                return highlighted;
            }
        };
        this.colorLine = new ColorHighlighter(predicate, new Color(255, 198, 209), null);
        this.addHighlighter(this.colorLine);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.rowAtPoint(e.getPoint()) == -1) {
            this.clearSelection();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27 && !this.isEditing()) {
            this.clearSelection();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

