/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.celleditor;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.AbstractCellEditor;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.table.TableCellEditor;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaConfig;
import org.chorem.lima.LimaContext;
import org.jdesktop.swingx.JXDatePicker;

public class DateTableCellEditor
extends AbstractCellEditor
implements TableCellEditor,
FocusListener,
AncestorListener {
    private static final Log log = LogFactory.getLog(DateTableCellEditor.class);
    private static final long serialVersionUID = 1L;
    private final JXDatePicker datePicker = new JXDatePicker(LimaContext.getContext().getConfig().getLocale());
    private Date date;

    public DateTableCellEditor() {
        this.datePicker.getEditor().addFocusListener(this);
        this.datePicker.getEditor().addAncestorListener(this);
        this.datePicker.setFormats(new DateFormat[]{DateFormat.getDateInstance(3), new SimpleDateFormat("dd/MM/yyyy"), new SimpleDateFormat("dd/MM")});
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof Date) {
            this.datePicker.setDate((Date)value);
            this.date = (Date)value;
        }
        return this.datePicker;
    }

    @Override
    public Object getCellEditorValue() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getDate : input Date : " + this.datePicker.getDate() + "; text : " + this.datePicker.getEditor().getText()));
        }
        try {
            this.datePicker.commitEdit();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.datePicker.getDate());
        int year = calendar.get(1);
        if (year == 1970) {
            calendar.setTime(this.date);
            year = calendar.get(1);
            Date newDate = DateUtils.setYears((Date)this.datePicker.getDate(), (int)year);
            this.datePicker.setDate(newDate);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getDate : output Date : " + this.datePicker.getDate()));
        }
        return this.datePicker.getDate();
    }

    @Override
    public void focusGained(FocusEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFormattedTextField dateFormattedTextField = DateTableCellEditor.this.datePicker.getEditor();
                LimaConfig config = LimaConfig.getInstance();
                if (config.isSelectAllEditingCell()) {
                    dateFormattedTextField.selectAll();
                } else {
                    int textFieldSize = dateFormattedTextField.getText().length();
                    dateFormattedTextField.select(textFieldSize, textFieldSize);
                }
            }
        });
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void ancestorAdded(AncestorEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DateTableCellEditor.this.datePicker.requestFocus();
            }
        });
    }

    @Override
    public void ancestorRemoved(AncestorEvent e) {
    }

    @Override
    public void ancestorMoved(AncestorEvent e) {
    }
}

