/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.accountsreports;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComboBox;
import org.chorem.lima.entity.Account;
import org.chorem.lima.util.AccountToString;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;

public class AccountComboBox
extends JComboBox
implements KeyListener {
    private static final long serialVersionUID = 1L;
    protected Timer timer;

    public AccountComboBox() {
        AutoCompleteDecorator.decorate((JComboBox)this, (ObjectToStringConverter)AccountToString.getInstance());
        this.getEditor().getEditorComponent().addKeyListener(this);
    }

    public void back() {
        int row = this.getSelectedIndex();
        if (row > 0) {
            this.getEditor().setItem(this.getItemAt(row - 1));
        }
    }

    public void next() {
        int size = this.getModel().getSize();
        int row = this.getSelectedIndex();
        if (row < size - 1) {
            this.getEditor().setItem(this.getItemAt(row + 1));
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        Timer timer = this.getTimer();
        if (timer != null) {
            timer.cancel();
            this.resetTimer();
        } else {
            timer = this.initTimer();
            TimerTaskKeyEvent task = new TimerTaskKeyEvent();
            task.setE(e);
            timer.schedule((TimerTask)task, 2000L);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    synchronized void resetTimer() {
        this.timer = null;
    }

    synchronized Timer initTimer() {
        this.timer = new Timer();
        return this.timer;
    }

    synchronized Timer getTimer() {
        return this.timer;
    }

    public class TimerTaskKeyEvent
    extends TimerTask {
        protected KeyEvent e;

        @Override
        public void run() {
            Object object = AccountComboBox.this.getSelectedItem();
            if (object instanceof Account) {
                AccountComboBox.this.fireActionEvent();
            }
            if (this.e.getKeyChar() == '\n') {
                AccountComboBox.this.firePopupMenuCanceled();
            }
            AccountComboBox.this.resetTimer();
        }

        public void setE(KeyEvent e) {
            this.e = e;
        }
    }
}

