/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.vatreports;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaConfig;
import org.chorem.lima.business.api.DocumentService;
import org.chorem.lima.business.api.FinancialPeriodService;
import org.chorem.lima.business.api.FiscalPeriodService;
import org.chorem.lima.business.api.HttpServerService;
import org.chorem.lima.business.utils.DocumentsEnum;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.vatreports.VatReportView;

public class VatReportViewHandler {
    private static final Log log = LogFactory.getLog(VatReportViewHandler.class);
    protected VatReportView view;
    protected DocumentService documentService;
    protected FiscalPeriodService fiscalPeriodService;
    protected FinancialPeriodService financialPeriodService;
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    protected int port;

    protected VatReportViewHandler(VatReportView view) {
        this.view = view;
        this.port = ((HttpServerService)LimaServiceFactory.getService(HttpServerService.class)).getHttpPort();
        this.documentService = (DocumentService)LimaServiceFactory.getService(DocumentService.class);
        this.fiscalPeriodService = (FiscalPeriodService)LimaServiceFactory.getService(FiscalPeriodService.class);
        this.financialPeriodService = (FinancialPeriodService)LimaServiceFactory.getService(FinancialPeriodService.class);
    }

    public void init() {
        List blockedFiscalPeriods = this.fiscalPeriodService.getAllFiscalPeriods();
        List financialPeriod = this.financialPeriodService.getUnblockedFinancialPeriods();
        this.view.getIntervalPanel().init(blockedFiscalPeriods, financialPeriod);
    }

    public void editVat() {
        if (this.view.getIntervalPanel().getBeginDate() != null || this.view.getIntervalPanel().getEndDate() != null) {
            String address = LimaConfig.getInstance().getHostAdress();
            if (log.isDebugEnabled()) {
                log.debug((Object)("autocomplete : " + this.view.getAutoComplete()));
            }
            try {
                String url = "http://" + address + ":" + this.port + "/?beginDate=" + dateFormat.format(this.view.getIntervalPanel().getBeginDate()) + "&endDate=" + dateFormat.format(this.view.getIntervalPanel().getEndDate()) + "&format=.pdf&model=" + DocumentsEnum.VAT.getFileName() + "&autocomplete=" + this.view.getAutoComplete();
                Desktop.getDesktop().browse(new URI(url));
            }
            catch (IOException e) {
                log.error((Object)"Can't open browser", (Throwable)e);
            }
            catch (URISyntaxException e) {
                log.error((Object)"Can't create news URI", (Throwable)e);
            }
        }
    }
}

