/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.balance;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaConfig;
import org.chorem.lima.business.api.FinancialPeriodService;
import org.chorem.lima.business.api.FiscalPeriodService;
import org.chorem.lima.business.api.HttpServerService;
import org.chorem.lima.business.api.ReportService;
import org.chorem.lima.business.utils.DocumentsEnum;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.balance.BalanceReportsView;

public class BalanceReportsViewHandler {
    protected BalanceReportsView view;
    private static final Log log = LogFactory.getLog(BalanceReportsViewHandler.class);
    protected ReportService reportService;
    protected HttpServerService httpServerServiceMonitorable;
    protected FiscalPeriodService fiscalPeriodService;
    protected FinancialPeriodService financialPeriodService;
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    protected BalanceReportsViewHandler(BalanceReportsView view) {
        this.view = view;
        this.reportService = (ReportService)LimaServiceFactory.getService(ReportService.class);
        this.fiscalPeriodService = (FiscalPeriodService)LimaServiceFactory.getService(FiscalPeriodService.class);
        this.financialPeriodService = (FinancialPeriodService)LimaServiceFactory.getService(FinancialPeriodService.class);
    }

    public void init() {
        List fiscalPeriod = this.fiscalPeriodService.getAllFiscalPeriods();
        List financialPeriod = this.financialPeriodService.getUnblockedFinancialPeriods();
        this.view.getIntervalPanel().init(fiscalPeriod, financialPeriod);
    }

    public void createDocument() {
        Date endDate;
        Date beginDate = this.view.getIntervalPanel().getBeginDate();
        if (beginDate != null & (endDate = this.view.getIntervalPanel().getEndDate()) != null) {
            String address = LimaConfig.getInstance().getHostAdress();
            try {
                int port = ((HttpServerService)LimaServiceFactory.getService(HttpServerService.class)).getHttpPort();
                String url = "http://" + address + ":" + port + "/?beginDate=" + dateFormat.format(beginDate) + "&endDate=" + dateFormat.format(endDate) + "&format=.html&model=" + DocumentsEnum.BALANCE.getFileName();
                Desktop.getDesktop().browse(new URI(url));
            }
            catch (IOException e) {
                log.error((Object)"Can't open browser", (Throwable)e);
            }
            catch (URISyntaxException e) {
                log.error((Object)"Can't create news URI", (Throwable)e);
            }
        }
    }
}

