/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Locale;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.AboutPanel;
import jaxx.runtime.swing.config.ConfigUIHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaConfig;
import org.chorem.lima.LimaContext;
import org.chorem.lima.business.api.HttpServerService;
import org.chorem.lima.enums.ImportExportEnum;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.ClosableTabHeader;
import org.chorem.lima.ui.MainView;
import org.chorem.lima.ui.account.AccountView;
import org.chorem.lima.ui.accountsreports.AccountsReportsView;
import org.chorem.lima.ui.balance.BalanceReportsView;
import org.chorem.lima.ui.celleditor.NumberSeparatorCellRenderer;
import org.chorem.lima.ui.celleditor.NumberSeparatorTableCellRenderer;
import org.chorem.lima.ui.entrybook.EntryBookView;
import org.chorem.lima.ui.entrybooksreports.EntryBooksReportsView;
import org.chorem.lima.ui.financialperiod.FinancialPeriodView;
import org.chorem.lima.ui.financialstatementchart.FinancialStatementChartView;
import org.chorem.lima.ui.financialstatementreport.FinancialStatementReportView;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionView;
import org.chorem.lima.ui.financialtransactionsearch.FinancialTransactionSearchView;
import org.chorem.lima.ui.financialtransactionunbalanced.FinancialTransactionUnbalancedView;
import org.chorem.lima.ui.fiscalperiod.FiscalPeriodView;
import org.chorem.lima.ui.home.HomeView;
import org.chorem.lima.ui.identity.IdentityForm;
import org.chorem.lima.ui.importexport.ImportExport;
import org.chorem.lima.ui.ledger.LedgerView;
import org.chorem.lima.ui.lettering.LetteringView;
import org.chorem.lima.ui.vatchart.VatChartView;
import org.chorem.lima.ui.vatreports.VatReportView;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ConfigOptionDef;
import org.nuiton.i18n.I18n;
import org.nuiton.util.DesktopUtil;
import org.nuiton.widget.SwingSession;

public class MainViewHandler {
    private static Log log = LogFactory.getLog(MainViewHandler.class);
    protected SwingSession swingSession;

    public MainView initUI(LimaContext rootContext, boolean fullscreen) {
        MainView ui = new MainView((JAXXContext)rootContext);
        this.swingSession = new SwingSession(this.getLimaStateFile(), false);
        LimaContext.MAIN_UI_ENTRY_DEF.setContextValue((JAXXContext)rootContext, (Object)ui);
        ui.getGraphicsConfiguration().getDevice().setFullScreenWindow(fullscreen ? ui : null);
        return ui;
    }

    protected File getLimaStateFile() {
        LimaConfig limaConfig = LimaConfig.getInstance();
        File limaStateFile = limaConfig.getLimaStateFile();
        return limaStateFile;
    }

    public void changeLanguage(MainView mainUI, Locale newLocale) {
        LimaConfig config = mainUI.getConfig();
        config.setLocale(newLocale);
        LimaContext.get().initI18n(config);
        this.reloadUI(LimaContext.get(), config.isFullScreen());
    }

    public void close(MainView ui) {
        boolean canContinue;
        this.swingSession.save();
        if (log.isInfoEnabled()) {
            log.info((Object)"Lima quitting...");
        }
        if (!(canContinue = this.ensureModification((JAXXContext)ui))) {
            return;
        }
        try {
            LimaContext.get().close();
            Runtime.getRuntime().halt(0);
        }
        catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)("error while closing " + ex.getMessage()), (Throwable)ex);
            }
            Runtime.getRuntime().halt(1);
        }
    }

    public void changeScreen(MainView ui, boolean fullscreen) {
        boolean canContinue = this.ensureModification((JAXXContext)ui);
        if (!canContinue) {
            return;
        }
        ui.getConfig().setFullscreen(fullscreen);
        this.reloadUI(LimaContext.get(), fullscreen);
    }

    public void showConfig(JAXXContext context) {
        MainView ui = this.getUI(context);
        final LimaConfig config = ui.getConfig();
        ConfigUIHelper helper = new ConfigUIHelper((ApplicationConfig)config);
        helper.registerCallBack(LimaConfig.Option.COLOR_SELECTION_FOCUS.key, I18n.t((String)"lima.config.colorselectionfocus", (Object[])new Object[0]), (Icon)new ImageIcon(), new Runnable(){

            @Override
            public void run() {
                UIManager.put("Table.focusCellHighlightBorder", new BorderUIResource(new LineBorder(config.getColorSelectionFocus(), 2)));
            }
        });
        helper.addCategory(I18n.t((String)"lima.config.category.directories", (Object[])new Object[0]), I18n.t((String)"lima.config.category.directories.description", (Object[])new Object[0]));
        helper.addOption((ConfigOptionDef)LimaConfig.Option.CONFIG_FILE);
        helper.setOptionShortLabel(LimaConfig.Option.CONFIG_FILE.getLabel());
        helper.addCategory(I18n.t((String)"lima.config.category.table", (Object[])new Object[0]), I18n.t((String)"lima.config.category.table.description", (Object[])new Object[0]));
        helper.addOption((ConfigOptionDef)LimaConfig.Option.TABLE_CELL_BACKGROUND);
        helper.setOptionShortLabel(LimaConfig.Option.TABLE_CELL_BACKGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaConfig.Option.TABLE_CELL_FOREGROUND);
        helper.setOptionShortLabel(LimaConfig.Option.TABLE_CELL_FOREGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaConfig.Option.TABLE_CELL_PAIR_BACKGROUND);
        helper.setOptionShortLabel(LimaConfig.Option.TABLE_CELL_PAIR_BACKGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaConfig.Option.TABLE_CELL_PAIR_FOREGROUND);
        helper.setOptionShortLabel(LimaConfig.Option.TABLE_CELL_PAIR_FOREGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaConfig.Option.TABLE_CELL_SELECTED_BACKGROUND);
        helper.setOptionShortLabel(LimaConfig.Option.TABLE_CELL_SELECTED_BACKGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaConfig.Option.TABLE_CELL_SELECTED_FOREGROUND);
        helper.setOptionShortLabel(LimaConfig.Option.TABLE_CELL_SELECTED_FOREGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaConfig.Option.TABLE_CELL_PAIR_SELECTED_BACKGROUND);
        helper.setOptionShortLabel(LimaConfig.Option.TABLE_CELL_PAIR_SELECTED_BACKGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaConfig.Option.TABLE_CELL_PAIR_SELECTED_FOREGROUND);
        helper.setOptionShortLabel(LimaConfig.Option.TABLE_CELL_PAIR_SELECTED_FOREGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaConfig.Option.TABLE_CELL_ERROR_BACKGROUND);
        helper.setOptionShortLabel(LimaConfig.Option.TABLE_CELL_ERROR_BACKGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaConfig.Option.TABLE_CELL_ERROR_FOREGROUND);
        helper.setOptionShortLabel(LimaConfig.Option.TABLE_CELL_ERROR_FOREGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaConfig.Option.TABLE_CELL_PAIR_ERROR_BACKGROUND);
        helper.setOptionShortLabel(LimaConfig.Option.TABLE_CELL_PAIR_ERROR_BACKGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaConfig.Option.TABLE_CELL_PAIR_ERROR_FOREGROUND);
        helper.setOptionShortLabel(LimaConfig.Option.TABLE_CELL_PAIR_ERROR_FOREGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaConfig.Option.TABLE_CELL_SELECTED_ERROR_BACKGROUND);
        helper.setOptionShortLabel(LimaConfig.Option.TABLE_CELL_SELECTED_ERROR_BACKGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaConfig.Option.TABLE_CELL_SELECTED_ERROR_FOREGROUND);
        helper.setOptionShortLabel(LimaConfig.Option.TABLE_CELL_SELECTED_ERROR_FOREGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaConfig.Option.TABLE_CELL_PAIR_SELECTED_ERROR_BACKGROUND);
        helper.setOptionShortLabel(LimaConfig.Option.TABLE_CELL_PAIR_SELECTED_ERROR_BACKGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaConfig.Option.TABLE_CELL_PAIR_SELECTED_ERROR_FOREGROUND);
        helper.setOptionShortLabel(LimaConfig.Option.TABLE_CELL_PAIR_SELECTED_ERROR_FOREGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaConfig.Option.TABLE_CELL_MANDATORY_BACKGROUND);
        helper.setOptionShortLabel(LimaConfig.Option.TABLE_CELL_MANDATORY_BACKGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaConfig.Option.TABLE_CELL_MANDATORY_FOREGROUND);
        helper.setOptionShortLabel(LimaConfig.Option.TABLE_CELL_MANDATORY_FOREGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaConfig.Option.TABLE_CELL_PAIR_MANDATORY_BACKGROUND);
        helper.setOptionShortLabel(LimaConfig.Option.TABLE_CELL_PAIR_MANDATORY_BACKGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaConfig.Option.TABLE_CELL_PAIR_MANDATORY_FOREGROUND);
        helper.setOptionShortLabel(LimaConfig.Option.TABLE_CELL_PAIR_MANDATORY_FOREGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaConfig.Option.TABLE_CELL_SELECTED_MANDATORY_BACKGROUND);
        helper.setOptionShortLabel(LimaConfig.Option.TABLE_CELL_SELECTED_MANDATORY_BACKGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaConfig.Option.TABLE_CELL_SELECTED_MANDATORY_FOREGROUND);
        helper.setOptionShortLabel(LimaConfig.Option.TABLE_CELL_SELECTED_MANDATORY_FOREGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaConfig.Option.TABLE_CELL_PAIR_SELECTED_MANDATORY_BACKGROUND);
        helper.setOptionShortLabel(LimaConfig.Option.TABLE_CELL_PAIR_SELECTED_MANDATORY_BACKGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaConfig.Option.TABLE_CELL_PAIR_SELECTED_MANDATORY_FOREGROUND);
        helper.setOptionShortLabel(LimaConfig.Option.TABLE_CELL_PAIR_SELECTED_MANDATORY_FOREGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaConfig.Option.COLOR_SELECTION_FOCUS);
        helper.setOptionShortLabel(LimaConfig.Option.COLOR_SELECTION_FOCUS.getLabel());
        helper.addCategory(I18n.t((String)"lima.config.category.other", (Object[])new Object[0]), I18n.t((String)"lima.config.category.other.description", (Object[])new Object[0]));
        helper.addOption((ConfigOptionDef)LimaConfig.Option.FULL_SCREEN);
        helper.setOptionShortLabel(LimaConfig.Option.FULL_SCREEN.getLabel());
        helper.addOption((ConfigOptionDef)LimaConfig.Option.LOCALE);
        helper.setOptionShortLabel(LimaConfig.Option.LOCALE.getLabel());
        JComboBox<Character> comboBoxSeparator = new JComboBox<Character>(LimaConfig.NUMBER_SEPARATOR.toArray(new Character[0]));
        DefaultCellEditor separatorEditor = new DefaultCellEditor(comboBoxSeparator);
        comboBoxSeparator.setRenderer(new NumberSeparatorCellRenderer());
        NumberSeparatorTableCellRenderer separatorRenderer = new NumberSeparatorTableCellRenderer();
        helper.addOption((ConfigOptionDef)LimaConfig.Option.DECIMAL_SEPARATOR);
        helper.setOptionShortLabel(LimaConfig.Option.DECIMAL_SEPARATOR.getLabel());
        helper.setOptionRenderer((TableCellRenderer)separatorRenderer);
        helper.setOptionEditor((TableCellEditor)separatorEditor);
        JComboBox<Integer> comboBoxDecimal = new JComboBox<Integer>(LimaConfig.NUMBER_DECIMALS.toArray(new Integer[0]));
        DefaultCellEditor decimalEditor = new DefaultCellEditor(comboBoxDecimal);
        helper.addOption((ConfigOptionDef)LimaConfig.Option.SCALE);
        helper.setOptionShortLabel(LimaConfig.Option.SCALE.getLabel());
        helper.setOptionEditor((TableCellEditor)decimalEditor);
        helper.addOption((ConfigOptionDef)LimaConfig.Option.THOUSAND_SEPARATOR);
        helper.setOptionShortLabel(LimaConfig.Option.THOUSAND_SEPARATOR.getLabel());
        helper.setOptionRenderer((TableCellRenderer)separatorRenderer);
        helper.setOptionEditor((TableCellEditor)separatorEditor);
        helper.addOption((ConfigOptionDef)LimaConfig.Option.CURRENCY);
        helper.setOptionShortLabel(LimaConfig.Option.CURRENCY.getLabel());
        helper.addOption((ConfigOptionDef)LimaConfig.Option.SELECT_ALL_EDITING_CELL);
        helper.setOptionShortLabel(LimaConfig.Option.SELECT_ALL_EDITING_CELL.getLabel());
        helper.buildUI(context, I18n.t((String)"lima.config.category.directories", (Object[])new Object[0]));
        helper.displayUI((Frame)ui, false);
    }

    public void gotoSite(JAXXContext context) {
        LimaConfig config = this.getUI(context).getConfig();
        URL siteURL = config.getOptionAsURL("application.site.url");
        try {
            DesktopUtil.browse((URI)siteURL.toURI());
        }
        catch (Exception e) {
            throw new RuntimeException("Can't open lima website at " + siteURL, e);
        }
    }

    public void showAbout(JAXXContext context) {
        MainView ui = this.getUI(context);
        AboutPanel about = new AboutPanel();
        about.setTitle(I18n.t((String)"lima.title.about", (Object[])new Object[0]));
        about.setAboutText(I18n.t((String)"lima.title.about.description", (Object[])new Object[0]));
        about.setBottomText(ui.getConfig().getCopyrightText());
        about.setIconPath("/icons/lima.png");
        about.setLicenseFile("META-INF/lima-LICENSE.txt");
        about.setThirdpartyFile("META-INF/lima-THIRD-PARTY.txt");
        JScrollPane component = new JScrollPane();
        JEditorPane translateArea = new JEditorPane();
        translateArea.setContentType("text/html");
        translateArea.setEditable(false);
        if (translateArea.getFont() != null) {
            translateArea.setFont(translateArea.getFont().deriveFont(11.0f));
        }
        translateArea.setBorder(null);
        String text = I18n.t((String)"lima.about.translate.content", (Object[])new Object[0]);
        translateArea.setText(text);
        component.getViewport().add(translateArea);
        about.getTabs().add(I18n.t((String)"lima.title.about.translate", (Object[])new Object[0]), component);
        about.init();
        about.showInDialog((Frame)ui, true);
    }

    protected void reloadUI(LimaContext rootContext, boolean fullscreen) {
        ((LimaConfig)((Object)LimaContext.CONFIG_DEF.getContextValue((JAXXContext)rootContext))).removeJaxxPropertyChangeListener();
        MainView ui = this.getUI((JAXXContext)rootContext);
        if (ui != null) {
            LimaContext.MAIN_UI_ENTRY_DEF.removeContextValue((JAXXContext)rootContext);
            ui.dispose();
            ui.setVisible(false);
        }
        ui = this.initUI(rootContext, fullscreen);
        ui.setVisible(true);
        this.showHomeView((JAXXContext)rootContext);
    }

    protected boolean ensureModification(JAXXContext rootContext) throws IllegalArgumentException {
        if (rootContext == null) {
            throw new IllegalArgumentException("rootContext can not be null");
        }
        MainView ui = this.getUI(rootContext);
        if (ui == null) {
            return true;
        }
        return true;
    }

    protected MainView getUI(JAXXContext context) {
        if (context instanceof MainView) {
            return (MainView)context;
        }
        MainView ui = (MainView)LimaContext.MAIN_UI_ENTRY_DEF.getContextValue(context);
        return ui;
    }

    public void showHomeView(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        HomeView homeView = new HomeView((JAXXContext)mainView);
        this.showTab(mainView, I18n.t((String)"lima.tab.home", (Object[])new Object[0]), (Component)((Object)homeView), false);
    }

    public void showIdentity(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        IdentityForm identityForm = new IdentityForm();
        identityForm.setLocationRelativeTo(mainView);
        identityForm.setVisible(true);
    }

    public void showAccountView(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        AccountView accountView = new AccountView((JAXXContext)mainView);
        this.showTab(mainView, I18n.t((String)"lima.charts.account", (Object[])new Object[0]), (Component)((Object)accountView));
        this.swingSession.add((Component)((Object)accountView));
    }

    public void showEntryBookView(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        EntryBookView entryBookView = new EntryBookView((JAXXContext)mainView);
        this.showTab(mainView, I18n.t((String)"lima.common.entrybooks", (Object[])new Object[0]), (Component)((Object)entryBookView));
        this.swingSession.add((Component)((Object)entryBookView));
    }

    public void showFiscalPeriodView(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        FiscalPeriodView fiscalPeriodView = new FiscalPeriodView((JAXXContext)mainView);
        this.showTab(mainView, I18n.t((String)"lima.charts.fiscalyear", (Object[])new Object[0]), (Component)((Object)fiscalPeriodView));
        this.swingSession.add((Component)((Object)fiscalPeriodView));
    }

    public void showFinancialPeriodView(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        FinancialPeriodView financialPeriodView = new FinancialPeriodView((JAXXContext)mainView);
        this.showTab(mainView, I18n.t((String)"lima.charts.financialperiod", (Object[])new Object[0]), (Component)((Object)financialPeriodView));
        this.swingSession.add((Component)((Object)financialPeriodView));
    }

    public void showFinancialStatementView(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        FinancialStatementChartView financialStatementView = new FinancialStatementChartView((JAXXContext)mainView);
        this.showTab(mainView, I18n.t((String)"lima.charts.financialstatement", (Object[])new Object[0]), (Component)((Object)financialStatementView));
        this.swingSession.add((Component)((Object)financialStatementView));
    }

    public void showVatChartView(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        VatChartView vatChartView = new VatChartView((JAXXContext)mainView);
        this.showTab(mainView, I18n.t((String)"lima.charts.vatstatement", (Object[])new Object[0]), (Component)((Object)vatChartView));
        this.swingSession.add((Component)((Object)vatChartView));
    }

    public void showAccountReports(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        AccountsReportsView accountsReportsView = new AccountsReportsView((JAXXContext)mainView);
        this.showTab(mainView, I18n.t((String)"lima.reports.accounts", (Object[])new Object[0]), (Component)((Object)accountsReportsView));
        this.swingSession.add((Component)((Object)accountsReportsView));
    }

    public void showEntryBookReports(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        EntryBooksReportsView entryBooksReportsView = new EntryBooksReportsView((JAXXContext)mainView);
        this.showTab(mainView, I18n.t((String)"lima.reports.entrybooks", (Object[])new Object[0]), (Component)((Object)entryBooksReportsView));
        this.swingSession.add((Component)((Object)entryBooksReportsView));
    }

    public void showTransactionView(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        FinancialTransactionView transactionView = new FinancialTransactionView((JAXXContext)mainView);
        this.showTab(mainView, I18n.t((String)"lima.entries.writetransaction", (Object[])new Object[0]), (Component)((Object)transactionView));
        this.swingSession.add((Component)((Object)transactionView));
    }

    public void showTransactionUnbalancedView(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        FinancialTransactionUnbalancedView searchResultView = new FinancialTransactionUnbalancedView((JAXXContext)mainView);
        this.showTab(mainView, I18n.t((String)"lima.entries.searchunbalancedtransaction", (Object[])new Object[0]), (Component)((Object)searchResultView));
        this.swingSession.add((Component)((Object)searchResultView));
    }

    public void showTransactionSearchView(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        FinancialTransactionSearchView searchView = new FinancialTransactionSearchView((JAXXContext)mainView);
        this.showTab(mainView, I18n.t((String)"lima.entries.searchtransaction", (Object[])new Object[0]), (Component)((Object)searchView));
        this.swingSession.add((Component)((Object)searchView));
    }

    public void showLetteringView(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        LetteringView letteringView = new LetteringView((JAXXContext)mainView);
        this.showTab(mainView, I18n.t((String)"lima.entries.lettering", (Object[])new Object[0]), (Component)((Object)letteringView));
        this.swingSession.add((Component)((Object)letteringView));
    }

    public void showBalanceView(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        BalanceReportsView balanceView = new BalanceReportsView((JAXXContext)mainView);
        this.showTab(mainView, I18n.t((String)"lima.reports.balance", (Object[])new Object[0]), (Component)((Object)balanceView));
        this.swingSession.add((Component)((Object)balanceView));
    }

    public void showLedgerView(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        LedgerView ledgerView = new LedgerView((JAXXContext)mainView);
        this.showTab(mainView, I18n.t((String)"lima.reports.ledger", (Object[])new Object[0]), (Component)((Object)ledgerView));
        this.swingSession.add((Component)((Object)ledgerView));
    }

    public void showFinancialStatementReportsView(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        FinancialStatementReportView financialStatementReportView = new FinancialStatementReportView((JAXXContext)mainView);
        this.showTab(mainView, I18n.t((String)"lima.reports.financialstatement", (Object[])new Object[0]), (Component)((Object)financialStatementReportView));
        this.swingSession.add((Component)((Object)financialStatementReportView));
    }

    public void showVatReportView(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        VatReportView vatReportView = new VatReportView((JAXXContext)mainView);
        this.showTab(mainView, I18n.t((String)"lima.reports.vat", (Object[])new Object[0]), (Component)((Object)vatReportView));
        this.swingSession.add((Component)((Object)vatReportView));
    }

    public void showImportExportView(JAXXContext rootContext, ImportExportEnum type) {
        MainView mainView = this.getUI(rootContext);
        ImportExport importExport = new ImportExport(mainView);
        importExport.importExport(type, "", true);
    }

    public void loadURI(MainView ui) {
        int port = ((HttpServerService)LimaServiceFactory.getService(HttpServerService.class)).getHttpPort();
        String address = LimaConfig.getInstance().getHostAdress();
        String url = "http://" + address + ":" + port + "/";
        if (log.isDebugEnabled()) {
            log.debug((Object)("URL : " + url));
        }
        SwingUtil.openLink((String)url);
    }

    protected void showTab(MainView ui, String name, Component container, boolean canClose) {
        final JTabbedPane contentTabbedPane = ui.getContentTabbedPane();
        if (contentTabbedPane.indexOfTab(name) == -1) {
            ClosableTabHeader closableHeader = new ClosableTabHeader();
            closableHeader.setTitle(name);
            closableHeader.setCanClose(canClose);
            contentTabbedPane.addTab(name, container);
            contentTabbedPane.setSelectedComponent(container);
            contentTabbedPane.setTabComponentAt(contentTabbedPane.indexOfTab(name), (Component)((Object)closableHeader));
            closableHeader.getCloseTab().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JButton button = (JButton)e.getSource();
                    ClosableTabHeader closableTab = (ClosableTabHeader)((Object)button.getParent());
                    String name = closableTab.getTitle();
                    contentTabbedPane.remove(contentTabbedPane.indexOfTab(name));
                }
            });
        } else {
            contentTabbedPane.setSelectedIndex(contentTabbedPane.indexOfTab(name));
        }
    }

    protected void showTab(MainView ui, String name, Component container) {
        this.showTab(ui, name, container, true);
    }
}

