/*
 * #%L
 * Lima :: Swing
 * $Id: LetteringEditModel.java 3585 2012-08-08 14:52:14Z tchemit $
 * $HeadURL: https://svn.chorem.org/lima/tags/lima-0.7.2/lima-swing/src/main/java/org/chorem/lima/ui/lettering/LetteringEditModel.java $
 * %%
 * Copyright (C) 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.chorem.lima.ui.lettering;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author sletellier <letellier@codelutin.com>
 */
public class LetteringEditModel implements Serializable {

    public static final String DEBIT_PROPERTY = "debit";

    public static final String CREDIT_PROPERTY = "credit";

    public static final String SOLDE_PROPERTY = "solde";

    public static final String LETTRED_PROPERTY = "lettred";

    public static final String UNLETTRED_PROPERTY = "unLettred";

    public static final String EQUALIZED_PROPERTY = "equalized";

    protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    protected LetteringTableModel model;
    protected boolean lettred;
    protected boolean unLettred;
    protected boolean equalized;
    protected BigDecimal debit = BigDecimal.ZERO;
    protected BigDecimal credit = BigDecimal.ZERO;
    protected BigDecimal solde = BigDecimal.ZERO;

    public boolean isEqualized() {
        return equalized;
    }

    public void setEqualized(boolean equalized) {
        boolean oldEqualized = isEqualized();
        this.equalized = equalized;
        firePropertyChange(EQUALIZED_PROPERTY, oldEqualized, this.equalized);
    }

    public boolean isLettred() {
        return lettred;
    }

    public void setLettred(boolean lettred) {
        boolean oldLettrer = isLettred();
        if(lettred && (solde == BigDecimal.ZERO || solde.doubleValue() == 0)){
            this.lettred = lettred;
        }else{
            this.lettred = false;
        }
        firePropertyChange(LETTRED_PROPERTY, oldLettrer, this.lettred);
    }

    public boolean isUnLettred() {
        return unLettred;
    }

    public void setUnLettred(boolean unLettred) {
        boolean oldDelettrer = isUnLettred();
        this.unLettred = unLettred;
        firePropertyChange(UNLETTRED_PROPERTY, oldDelettrer, this.unLettred);
    }

    public BigDecimal getDebit() {
        return debit;
    }

    public void setDebit(BigDecimal debit) {
        BigDecimal oldDebit = getDebit();

        if (debit !=  BigDecimal.ZERO){
            this.debit = debit.add(oldDebit);
        }else{
            this.debit = BigDecimal.ZERO;
        }

        firePropertyChange(DEBIT_PROPERTY, oldDebit, this.debit);
    }

    public BigDecimal getCredit() {
        return credit;
    }

    public void setCredit(BigDecimal credit) {
        BigDecimal oldCredit = getCredit();

        if (credit != BigDecimal.ZERO){
            this.credit = credit.add(oldCredit);
        }else{
            this.credit=BigDecimal.ZERO;
        }

        firePropertyChange(CREDIT_PROPERTY, oldCredit, this.credit);
    }

    public BigDecimal getSolde() {
        return solde;
    }

    public void setSolde(BigDecimal solde, boolean credit) {
        BigDecimal oldSolde = getSolde();

        if (solde != BigDecimal.ZERO){
            if (credit){
                this.solde = oldSolde.subtract(solde);
            }else{
                this.solde = oldSolde.add(solde);
            }
        }else{
            this.solde=BigDecimal.ZERO;
        }

        firePropertyChange(SOLDE_PROPERTY, oldSolde, this.solde);
    }

    public void resetDebitCreditBalance(){
        setDebit(BigDecimal.ZERO);
        setCredit(BigDecimal.ZERO);
        setSolde(BigDecimal.ZERO, false);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, Object newValue) {
        firePropertyChange(propertyName, null, newValue);
    }
}
