package org.chorem.lima.ui.financialtransaction;

/*
 * #%L
 * Lima :: Swing
 * $Id: LetterColumn.java 3777 2014-04-14 07:29:08Z sbavencoff $
 * $HeadURL: https://svn.chorem.org/lima/tags/lima-0.7.2/lima-swing/src/main/java/org/chorem/lima/ui/financialtransaction/LetterColumn.java $
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.chorem.lima.entity.Entry;
import org.chorem.lima.ui.common.AbstractColumn;
import org.chorem.lima.ui.common.FinancialTransactionTableModel;

import static org.nuiton.i18n.I18n.t;

/**
 * @author Sylvain Bavencoff <bavencoff@codelutin.com>
 */
public class LetterColumn extends AbstractColumn<FinancialTransactionTableModel> {

    public LetterColumn() {
        super(String.class, t("lima.table.letter"), true);
    }

    @Override
    public Object getValueAt(int row) {
        Entry entry = tableModel.get(row);
        return entry.getLettering();
    }

    @Override
    public boolean setValueAt(Object value, int row) {
        Entry entry = tableModel.get(row);
        String letter = ((String) value).trim();

        boolean update = (entry.getLettering() == null || entry.getLettering().compareTo(letter) != 0);
        if (update) {
            entry.setLettering(letter);
            tableModel.updateEntry(entry);
        }
        return update;
    }
}
