/*
 * #%L
 * Lima Swing
 * 
 * $Id: FinancialStatementReportTableModel.java 3777 2014-04-14 07:29:08Z sbavencoff $
 * $HeadURL: https://svn.chorem.org/lima/tags/lima-0.7.2/lima-swing/src/main/java/org/chorem/lima/ui/financialstatementreport/FinancialStatementReportTableModel.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.financialstatementreport;

import static org.nuiton.i18n.I18n.t;

import java.math.BigDecimal;
import java.util.List;

import javax.swing.table.AbstractTableModel;

import org.chorem.lima.beans.FinancialStatementAmounts;

/**
 * Entry book table model.
 *
 * @author ore
 * @author chatellier
 * @version $Revision: 3777 $
 *          <p/>
 *          Last update : $Date: 2014-04-14 09:29:08 +0200 (Mon, 14 Apr 2014) $
 *          By : $Author: sbavencoff $
 */
public class FinancialStatementReportTableModel extends AbstractTableModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1L;

    /** data cache */
    protected List<FinancialStatementAmounts> financialStatementAmounts;

    @Override
    public int getRowCount() {
        int result = 0;
        if (financialStatementAmounts != null) {
            result = financialStatementAmounts.size();
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Class<?> getColumnClass(int column) {

        Class<?> result = null;

        switch (column) {
            case 0:
                result = String.class;
                break;
            case 1:
                result = BigDecimal.class;
                break;
            case 2:
                result = BigDecimal.class;
                break;
            case 3:
                result = BigDecimal.class;
                break;
        }

        return result;
    }

    @Override
    public String getColumnName(int column) {
        String res = "n/a";
        switch (column) {
            case 0:
                res = t("lima.table.label");
                break;
            case 1:
                res = t("lima.table.grossamount");
                break;
            case 2:
                res = t("lima.table.provisiondeprecationamount");
                break;
            case 3:
                res = t("lima.table.netamount");
                break;
        }
        return res;
    }

    public Object getElementAt(int row) {

        Object currentRow = financialStatementAmounts.get(row);
        return currentRow;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object result = financialStatementAmounts.get(row);
        //get entries for the period for the current row 
        if (result instanceof FinancialStatementAmounts) {
            FinancialStatementAmounts currentRow = (FinancialStatementAmounts) result;
            BigDecimal grossAmount = currentRow.getGrossAmount();
            if (grossAmount == null) {
                grossAmount = BigDecimal.ZERO;
            }

            BigDecimal provisionDeprecationAmount = currentRow.getProvisionDeprecationAmount();
            if (provisionDeprecationAmount == null) {
                provisionDeprecationAmount = BigDecimal.ZERO;
            }
            switch (column) {
                case 0:
                    result = "";
                    String label = currentRow.getLabel();
                    if (label != null) {
                        for (int i = 0; i <= currentRow.getLevel(); i++) {
                            result = result + "\t";
                        }
                        result = result + label;
                    }
                    break;
                case 1:
                    if (grossAmount.compareTo(BigDecimal.ZERO) == 0) {
                        result = null;
                    } else {
                        result = grossAmount;
                    }
                    break;
                case 2:
                    if (provisionDeprecationAmount.compareTo(BigDecimal.ZERO) == 0) {
                        result = null;
                    } else {
                        result = provisionDeprecationAmount;
                    }
                    break;
                case 3:
                    BigDecimal solde = grossAmount.subtract(provisionDeprecationAmount);
                    if (solde.compareTo(BigDecimal.ZERO) == 0) {
                        result = null;
                    } else {
                        result = solde;
                    }
                    break;
            }
        }

        return result;
    }

    public void setFinancialStatementAmounts(List<FinancialStatementAmounts> financialStatementAmounts) {
        this.financialStatementAmounts = financialStatementAmounts;
        fireTableDataChanged();
    }
}
