/*
 * #%L
 * Lima Swing
 * 
 * $Id: FinancialStatementsChartEnum.java 3293 2011-09-17 14:17:04Z tchemit $
 * $HeadURL: https://svn.chorem.org/lima/tags/lima-0.7.2/lima-swing/src/main/java/org/chorem/lima/enums/FinancialStatementsChartEnum.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.enums;

public enum FinancialStatementsChartEnum {

    IMPORT(""), SHORTENED("bcr_shortened.csv"), BASE("bcr_base.csv"), DEVELOPED("bcr_developed.csv");

    private final String filePath;

    FinancialStatementsChartEnum(String filePath) {
        this.filePath = filePath;

    }

    public String getFilePath() {
        String result = "";
        if (!filePath.equals("")) {
            result = getClass().getResource("/import/" + filePath).getPath();
        }
        return result;
    }
}
