/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransactionunbalanced;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableCellEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.Entry;
import org.chorem.lima.entity.EntryImpl;
import org.chorem.lima.entity.FinancialTransaction;
import org.chorem.lima.ui.combobox.FiscalPeriodComboBoxModel;
import org.chorem.lima.ui.financialtransactionunbalanced.FinancialTransactionUnbalancedTable;
import org.chorem.lima.ui.financialtransactionunbalanced.FinancialTransactionUnbalancedTableModel;
import org.chorem.lima.ui.financialtransactionunbalanced.FinancialTransactionUnbalancedView;
import org.nuiton.i18n.I18n;

public class FinancialTransactionUnbalancedViewHandler {
    private static final Log log = LogFactory.getLog(FinancialTransactionUnbalancedViewHandler.class);
    protected FinancialTransactionUnbalancedView view;

    protected FinancialTransactionUnbalancedViewHandler(FinancialTransactionUnbalancedView view) {
        this.view = view;
        this.initShortCuts();
    }

    public void init() {
        if (this.view.getFiscalPeriodComboBox().getModel().getSize() > 0) {
            this.view.getFiscalPeriodComboBox().setSelectedIndex(0);
        }
        this.refresh();
    }

    protected void initShortCuts() {
        InputMap inputMap = this.view.getInputMap(1);
        ActionMap actionMap = this.view.getActionMap();
        String binding = "delete-transaction";
        inputMap.put(KeyStroke.getKeyStroke(127, 192), binding);
        actionMap.put(binding, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FinancialTransactionUnbalancedViewHandler.this.deleteSelectedTransaction();
            }
        });
        binding = "new-entry";
        inputMap.put(KeyStroke.getKeyStroke(78, 128), binding);
        actionMap.put(binding, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FinancialTransactionUnbalancedViewHandler.this.addEntry();
            }
        });
        binding = "delete-entry";
        inputMap.put(KeyStroke.getKeyStroke(127, 128), binding);
        actionMap.put(binding, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FinancialTransactionUnbalancedViewHandler.this.deleteSelectedEntry();
            }
        });
        binding = "balance";
        inputMap.put(KeyStroke.getKeyStroke(66, 128), binding);
        actionMap.put(binding, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FinancialTransactionUnbalancedViewHandler.this.balanceTransaction();
            }
        });
        binding = "refresh";
        inputMap.put(KeyStroke.getKeyStroke(116, 0), binding);
        actionMap.put(binding, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FinancialTransactionUnbalancedViewHandler.this.refresh();
            }
        });
    }

    public void addEntry() {
        FinancialTransactionUnbalancedTable table = this.view.getFinancialTransactionUnbalancedTable();
        FinancialTransactionUnbalancedTableModel tableModel = this.view.getFinancialTransactionUnbalancedTableModel();
        int indexSelectedRow = table.getSelectedRow();
        if (indexSelectedRow != -1) {
            TableCellEditor cellEditor = table.getCellEditor();
            if (cellEditor != null) {
                cellEditor.cancelCellEditing();
            }
            Entry entry = (Entry)tableModel.get(indexSelectedRow);
            EntryImpl newEntry = new EntryImpl();
            newEntry.setFinancialTransaction(entry.getFinancialTransaction());
            newEntry.setVoucher(entry.getVoucher());
            newEntry.setDescription(entry.getDescription());
            tableModel.addEntry((Entry)newEntry);
            int row = tableModel.indexOf(newEntry.getFinancialTransaction()) + newEntry.getFinancialTransaction().sizeEntry() - 1;
            ListSelectionModel selectionModel = table.getSelectionModel();
            selectionModel.setSelectionInterval(row, row);
            table.changeSelection(row, 1, false, false);
            table.editCellAt(row, 1);
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"Call addentry selected transaction without selection");
        }
    }

    public void deleteSelectedEntry() {
        FinancialTransactionUnbalancedTable table = this.view.getFinancialTransactionUnbalancedTable();
        FinancialTransactionUnbalancedTableModel tableModel = this.view.getFinancialTransactionUnbalancedTableModel();
        int indexSelectedRow = table.getSelectedRow();
        if (indexSelectedRow != -1) {
            String message;
            int response;
            TableCellEditor cellEditor = table.getCellEditor();
            if (cellEditor != null) {
                cellEditor.cancelCellEditing();
            }
            if ((response = JOptionPane.showConfirmDialog((Component)((Object)this.view), message = I18n._((String)"lima.charts.financialtransaction.question.removeentry", (Object[])new Object[0]), I18n._((String)"lima.common.confirmation", (Object[])new Object[0]), 0)) == 0) {
                tableModel.removeEntry(indexSelectedRow);
                if (tableModel.size() > 0) {
                    if (indexSelectedRow >= tableModel.size()) {
                        indexSelectedRow = tableModel.size() - 1;
                    }
                    ListSelectionModel selectionModel = table.getSelectionModel();
                    selectionModel.setSelectionInterval(indexSelectedRow, indexSelectedRow);
                    table.changeSelection(indexSelectedRow, 1, false, false);
                    table.editCellAt(indexSelectedRow, 1);
                }
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"Call delete selected row without selection");
        }
    }

    public void deleteSelectedTransaction() {
        FinancialTransactionUnbalancedTable table = this.view.getFinancialTransactionUnbalancedTable();
        FinancialTransactionUnbalancedTableModel tableModel = this.view.getFinancialTransactionUnbalancedTableModel();
        int indexSelectedRow = table.getSelectedRow();
        if (indexSelectedRow != -1) {
            String message;
            int response;
            TableCellEditor cellEditor = table.getCellEditor();
            if (cellEditor != null) {
                cellEditor.cancelCellEditing();
            }
            if ((response = JOptionPane.showConfirmDialog((Component)((Object)this.view), message = I18n._((String)"lima.charts.financialtransaction.question.removetransaction", (Object[])new Object[0]), I18n._((String)"lima.common.confirmation", (Object[])new Object[0]), 0)) == 0) {
                tableModel.removeTransaction(indexSelectedRow);
                if (tableModel.size() > 0) {
                    if (indexSelectedRow >= tableModel.size()) {
                        indexSelectedRow = tableModel.size() - 1;
                    }
                    ListSelectionModel selectionModel = table.getSelectionModel();
                    selectionModel.setSelectionInterval(indexSelectedRow, indexSelectedRow);
                    table.changeSelection(indexSelectedRow, 1, false, false);
                    table.editCellAt(indexSelectedRow, 1);
                }
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"Call delete selected row without selection");
        }
    }

    public void selectionChanged() {
        FinancialTransactionUnbalancedTable table = this.view.getFinancialTransactionUnbalancedTable();
        FinancialTransactionUnbalancedTableModel tableModel = this.view.getFinancialTransactionUnbalancedTableModel();
        int selectedRow = table.getSelectedRow();
        this.view.setSelectedRow(selectedRow >= 0 && selectedRow < tableModel.size());
        if (selectedRow >= 0 && selectedRow < tableModel.size()) {
            BigDecimal debit;
            FinancialTransaction transaction = tableModel.getTransactionAt(selectedRow);
            BigDecimal credit = transaction.getAmountCredit();
            this.view.setBalance(credit.compareTo(debit = transaction.getAmountDebit()) == 0);
        } else {
            this.view.setBalance(true);
        }
    }

    public void balanceTransaction() {
        FinancialTransactionUnbalancedTable table = this.view.getFinancialTransactionUnbalancedTable();
        FinancialTransactionUnbalancedTableModel tableModel = this.view.getFinancialTransactionUnbalancedTableModel();
        int rowSelected = table.getSelectedRow();
        if (rowSelected != -1) {
            if (table.isEditing()) {
                TableCellEditor editor = table.getCellEditor();
                editor.stopCellEditing();
            }
            Entry entry = (Entry)tableModel.get(rowSelected);
            FinancialTransaction transaction = entry.getFinancialTransaction();
            BigDecimal credit = transaction.getAmountCredit();
            BigDecimal debit = transaction.getAmountDebit();
            if (entry.isDebit()) {
                debit = debit.subtract(entry.getAmount());
            } else {
                credit = credit.subtract(entry.getAmount());
            }
            BigDecimal balance = credit.subtract(debit);
            entry.setAmount(balance.abs());
            entry.setDebit(balance.signum() > 0);
            tableModel.updateEntry(entry);
            int firstRow = tableModel.indexOf(transaction);
            int lastRow = firstRow + transaction.sizeEntry() - 1;
            tableModel.fireTableRowsUpdated(firstRow, lastRow);
            this.view.setBalance(true);
            ListSelectionModel selectionModel = table.getSelectionModel();
            selectionModel.setSelectionInterval(rowSelected, rowSelected);
            table.changeSelection(rowSelected, 1, false, false);
            table.editCellAt(rowSelected, 1);
        }
    }

    public void refresh() {
        FinancialTransactionUnbalancedTableModel tableModel = this.view.getFinancialTransactionUnbalancedTableModel();
        FinancialTransactionUnbalancedTable table = this.view.getFinancialTransactionUnbalancedTable();
        table.exit();
        tableModel.refresh();
        table.clearSelection();
        FiscalPeriodComboBoxModel comboBoxModel = this.view.getModelFiscalPeriod();
        comboBoxModel.refresh();
    }
}

