/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialstatementreport;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaConfig;
import org.chorem.lima.business.api.FinancialPeriodService;
import org.chorem.lima.business.api.FinancialStatementService;
import org.chorem.lima.business.api.FiscalPeriodService;
import org.chorem.lima.business.api.HttpServerService;
import org.chorem.lima.business.utils.DocumentsEnum;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.financialstatementreport.FinancialStatementReportView;

public class FinancialStatementReportViewHandler {
    private static final Log log = LogFactory.getLog(FinancialStatementReportViewHandler.class);
    protected FinancialStatementReportView view;
    protected FiscalPeriodService fiscalPeriodService;
    protected FinancialPeriodService financialPeriodService;
    protected FinancialStatementService financialStatementService;
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    protected FinancialStatementReportViewHandler(FinancialStatementReportView view) {
        this.view = view;
        this.fiscalPeriodService = (FiscalPeriodService)LimaServiceFactory.getService(FiscalPeriodService.class);
        this.financialPeriodService = (FinancialPeriodService)LimaServiceFactory.getService(FinancialPeriodService.class);
        this.financialStatementService = (FinancialStatementService)LimaServiceFactory.getService(FinancialStatementService.class);
    }

    public void init() {
        List fiscalPeriod = this.fiscalPeriodService.getAllFiscalPeriods();
        List financialPeriod = this.financialPeriodService.getUnblockedFinancialPeriods();
        this.view.getIntervalPanel().init(fiscalPeriod, financialPeriod);
    }

    public void createDocument() {
        Date beginDate = this.view.getIntervalPanel().getBeginDate();
        Date endDate = this.view.getIntervalPanel().getEndDate();
        if (beginDate != null && endDate != null) {
            String address = LimaConfig.getInstance().getHostAdress();
            int port = ((HttpServerService)LimaServiceFactory.getService(HttpServerService.class)).getHttpPort();
            String url = "http://" + address + ":" + port + "/?beginDate=" + dateFormat.format(beginDate) + "&endDate=" + dateFormat.format(endDate) + "&format=.html&model=" + DocumentsEnum.FINANCIALSTATEMENT.getFileName();
            try {
                Desktop.getDesktop().browse(new URI(url));
            }
            catch (IOException e) {
                log.error((Object)"Can't open browser", (Throwable)e);
            }
            catch (URISyntaxException e) {
                log.error((Object)"Can't create news URI", (Throwable)e);
            }
        }
    }
}

