/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialstatementchart;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.api.FinancialStatementService;
import org.chorem.lima.business.api.ImportService;
import org.chorem.lima.entity.FinancialStatement;
import org.chorem.lima.entity.FinancialStatementImpl;
import org.chorem.lima.enums.FinancialStatementsChartEnum;
import org.chorem.lima.enums.ImportExportEnum;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.financialstatementchart.FinancialStatementChartTreeTable;
import org.chorem.lima.ui.financialstatementchart.FinancialStatementChartTreeTableModel;
import org.chorem.lima.ui.financialstatementchart.FinancialStatementChartView;
import org.chorem.lima.ui.financialstatementchart.FinancialStatementHeaderForm;
import org.chorem.lima.ui.financialstatementchart.FinancialStatementImportForm;
import org.chorem.lima.ui.financialstatementchart.FinancialStatementMovementForm;
import org.chorem.lima.ui.importexport.ImportExport;
import org.chorem.lima.util.ReportDialogView;
import org.nuiton.i18n.I18n;
import org.nuiton.util.Resource;

public class FinancialStatementChartViewHandler
implements ServiceListener {
    private static final Log log = LogFactory.getLog(FinancialStatementChartViewHandler.class);
    protected FinancialStatementService financialStatementService;
    protected FinancialStatementChartView view;

    protected FinancialStatementChartViewHandler(FinancialStatementChartView view) {
        this.view = view;
        this.financialStatementService = (FinancialStatementService)LimaServiceFactory.getService(FinancialStatementService.class);
        LimaServiceFactory.addServiceListener(ImportService.class, (ServiceListener)this);
        this.init();
    }

    public void init() {
        InputMap inputMap = this.view.getInputMap(1);
        ActionMap actionMap = this.view.getActionMap();
        String binding = "add-FinancialStatementHeader";
        inputMap.put(KeyStroke.getKeyStroke(78, 192), binding);
        actionMap.put(binding, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FinancialStatementChartViewHandler.this.addFinancialStatementHeader();
            }
        });
        binding = "add-FinancialStatementMovement";
        inputMap.put(KeyStroke.getKeyStroke(78, 128), binding);
        actionMap.put(binding, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FinancialStatementChartViewHandler.this.addFinancialStatementMovement();
            }
        });
        binding = "update-FinancialStatement";
        inputMap.put(KeyStroke.getKeyStroke(77, 128), binding);
        actionMap.put(binding, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FinancialStatementChartViewHandler.this.updateFinancialStatement();
            }
        });
        binding = "remove-FinancialStatement";
        inputMap.put(KeyStroke.getKeyStroke(127, 0), binding);
        actionMap.put(binding, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FinancialStatementChartViewHandler.this.removeFinancialStatement();
            }
        });
        binding = "import-FinancialStatement";
        inputMap.put(KeyStroke.getKeyStroke(73, 128), binding);
        actionMap.put(binding, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FinancialStatementChartViewHandler.this.importFinancialStatementChart();
            }
        });
        binding = "check-FinancialStatement";
        inputMap.put(KeyStroke.getKeyStroke(75, 128), binding);
        actionMap.put(binding, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FinancialStatementChartViewHandler.this.financialStatementChartCheck();
            }
        });
    }

    public void addFinancialStatementHeader() {
        FinancialStatementChartTreeTable treeTable = this.view.getTreeTable();
        FinancialStatementChartTreeTableModel treeTableModel = (FinancialStatementChartTreeTableModel)treeTable.getTreeTableModel();
        FinancialStatementImpl newFinancialStatementHeader = new FinancialStatementImpl();
        final FinancialStatementHeaderForm financialStatementHeaderForm = new FinancialStatementHeaderForm((JAXXContext)this.view);
        financialStatementHeaderForm.setFinancialStatement((FinancialStatement)newFinancialStatementHeader);
        InputMap inputMap = financialStatementHeaderForm.getRootPane().getInputMap(1);
        ActionMap actionMap = financialStatementHeaderForm.getRootPane().getActionMap();
        String binding = "dispose";
        inputMap.put(KeyStroke.getKeyStroke(27, 0), binding);
        actionMap.put(binding, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                financialStatementHeaderForm.performCancel();
            }
        });
        financialStatementHeaderForm.setLocationRelativeTo((Component)((Object)this.view));
        financialStatementHeaderForm.setVisible(true);
        newFinancialStatementHeader = financialStatementHeaderForm.getFinancialStatement();
        if (newFinancialStatementHeader != null) {
            newFinancialStatementHeader.setHeader(true);
            int selectedRow = treeTable.getSelectedRow();
            TreePath treePath = selectedRow != -1 ? treeTable.getPathForRow(selectedRow) : new TreePath(treeTableModel.getRoot());
            treeTableModel.addFinancialStatement(treePath, (FinancialStatement)newFinancialStatementHeader);
        }
    }

    public void addFinancialStatementMovement() {
        FinancialStatementChartTreeTable treeTable = this.view.getTreeTable();
        FinancialStatementChartTreeTableModel treeTableModel = (FinancialStatementChartTreeTableModel)treeTable.getTreeTableModel();
        FinancialStatementImpl newFinancialStatementMovement = new FinancialStatementImpl();
        final FinancialStatementMovementForm financialStatementMovementForm = new FinancialStatementMovementForm((JAXXContext)this.view);
        financialStatementMovementForm.setFinancialStatement((FinancialStatement)newFinancialStatementMovement);
        InputMap inputMap = financialStatementMovementForm.getRootPane().getInputMap(1);
        ActionMap actionMap = financialStatementMovementForm.getRootPane().getActionMap();
        String binding = "dispose";
        inputMap.put(KeyStroke.getKeyStroke(27, 0), binding);
        actionMap.put(binding, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                financialStatementMovementForm.performCancel();
            }
        });
        financialStatementMovementForm.setLocationRelativeTo((Component)((Object)this.view));
        financialStatementMovementForm.setVisible(true);
        newFinancialStatementMovement = financialStatementMovementForm.getFinancialStatement();
        if (newFinancialStatementMovement != null) {
            int selectedRow = this.view.treeTable.getSelectedRow();
            TreePath treePath = this.view.treeTable.getPathForRow(selectedRow);
            treeTableModel.addFinancialStatement(treePath, (FinancialStatement)newFinancialStatementMovement);
        }
    }

    public void updateFinancialStatement() {
        FinancialStatementChartTreeTable treeTable = this.view.getTreeTable();
        FinancialStatementChartTreeTableModel treeTableModel = (FinancialStatementChartTreeTableModel)treeTable.getTreeTableModel();
        int selectedRow = this.view.treeTable.getSelectedRow();
        TreePath treePath = this.view.treeTable.getPathForRow(selectedRow);
        FinancialStatement financialStatement = (FinancialStatement)treePath.getLastPathComponent();
        if (financialStatement != null) {
            treePath = selectedRow != -1 ? this.view.treeTable.getPathForRow(selectedRow) : new TreePath(treeTableModel.getRoot());
            log.debug((Object)financialStatement.getHeader());
            if (financialStatement.getHeader()) {
                final FinancialStatementHeaderForm financialStatementHeaderForm = new FinancialStatementHeaderForm((JAXXContext)this.view);
                financialStatementHeaderForm.setFinancialStatement(financialStatement);
                InputMap inputMap = financialStatementHeaderForm.getRootPane().getInputMap(1);
                ActionMap actionMap = financialStatementHeaderForm.getRootPane().getActionMap();
                String binding = "dispose";
                inputMap.put(KeyStroke.getKeyStroke(27, 0), binding);
                actionMap.put(binding, new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        financialStatementHeaderForm.performCancel();
                    }
                });
                financialStatementHeaderForm.setLocationRelativeTo((Component)((Object)this.view));
                financialStatementHeaderForm.setVisible(true);
                financialStatement = financialStatementHeaderForm.getFinancialStatement();
            } else {
                final FinancialStatementMovementForm financialStatementMovementForm = new FinancialStatementMovementForm((JAXXContext)this.view);
                financialStatementMovementForm.setFinancialStatement(financialStatement);
                InputMap inputMap = financialStatementMovementForm.getRootPane().getInputMap(1);
                ActionMap actionMap = financialStatementMovementForm.getRootPane().getActionMap();
                String binding = "dispose";
                inputMap.put(KeyStroke.getKeyStroke(27, 0), binding);
                actionMap.put(binding, new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        financialStatementMovementForm.performCancel();
                    }
                });
                financialStatementMovementForm.setLocationRelativeTo((Component)((Object)this.view));
                financialStatementMovementForm.setVisible(true);
                financialStatement = financialStatementMovementForm.getFinancialStatement();
            }
            if (financialStatement != null) {
                treeTableModel.updateFinancialStatement(treePath, financialStatement);
            }
        }
    }

    public void removeFinancialStatement() {
        int n;
        FinancialStatementChartTreeTable treeTable = this.view.getTreeTable();
        FinancialStatementChartTreeTableModel treeTableModel = (FinancialStatementChartTreeTableModel)treeTable.getTreeTableModel();
        int selectedRow = this.view.treeTable.getSelectedRow();
        if (selectedRow != -1 && (n = JOptionPane.showConfirmDialog((Component)((Object)this.view), I18n._((String)"lima.charts.account.question.remove", (Object[])new Object[0]), I18n._((String)"lima.common.confirmation", (Object[])new Object[0]), 0, 3)) == 0) {
            TreePath treePath = this.view.treeTable.getPathForRow(selectedRow);
            FinancialStatement financialStatement = (FinancialStatement)treePath.getLastPathComponent();
            treeTableModel.removeFinancialStatementObject(treePath, financialStatement);
        }
    }

    public void refresh() {
        FinancialStatementChartTreeTable treeTable = this.view.getTreeTable();
        FinancialStatementChartTreeTableModel treeTableModel = (FinancialStatementChartTreeTableModel)treeTable.getTreeTableModel();
        treeTableModel.refreshTree();
        this.view.repaint();
    }

    public void importFinancialStatementChart() {
        final FinancialStatementImportForm form = new FinancialStatementImportForm();
        InputMap inputMap = form.getRootPane().getInputMap(1);
        ActionMap actionMap = form.getRootPane().getActionMap();
        String binding = "dispose";
        inputMap.put(KeyStroke.getKeyStroke(27, 0), binding);
        actionMap.put(binding, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                form.performCancel();
            }
        });
        form.setLocationRelativeTo((Component)((Object)this.view));
        form.setVisible(true);
        Object value = form.getRadioButtons().getSelectedValue();
        if (value != null) {
            if (form.getDeleteFinancialStatementChart().isSelected()) {
                this.financialStatementService.removeAllFinancialStatement();
            }
            FinancialStatementsChartEnum defaultFinancialStatementsEnum = (FinancialStatementsChartEnum)((Object)value);
            ImportExport importExport = new ImportExport((Component)((Object)this.view));
            importExport.importExport(ImportExportEnum.CSV_FINANCIALSTATEMENTS_IMPORT, defaultFinancialStatementsEnum.getFilePath(), true);
        }
    }

    public void financialStatementChartCheck() {
        String result = this.financialStatementService.checkFinancialStatementChart();
        this.showReportDialog(result, I18n._((String)"lima.financialstatement.check", (Object[])new Object[0]), (Component)((Object)this.view));
    }

    public void showReportDialog(String message, String title, Component parent) {
        ReportDialogView reportDialogView = new ReportDialogView();
        reportDialogView.setIconImage(Resource.getIcon((String)"icons/lima.png").getImage());
        JTextArea textArea = reportDialogView.getTextArea();
        textArea.setText(message);
        reportDialogView.setSize(600, 400);
        reportDialogView.setTitle(title);
        reportDialogView.setLocationRelativeTo(parent);
        reportDialogView.setVisible(true);
    }

    public void notifyMethod(String serviceName, String methodName) {
        if (methodName.contains("FinancialStatements") || methodName.contains("importAll") || methodName.contains("importAs")) {
            this.refresh();
        }
    }
}

