/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.common;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang3.time.DateUtils;
import org.chorem.lima.entity.FinancialPeriod;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.enums.ComboBoxDatesEnum;
import org.chorem.lima.ui.common.FinancialPeriodComboBoxModel;
import org.chorem.lima.ui.common.FinancialPeriodListRenderer;
import org.chorem.lima.ui.common.FiscalPeriodComboBoxModel;
import org.chorem.lima.ui.common.FiscalPeriodListRenderer;
import org.chorem.lima.ui.common.IntervalListener;
import org.jdesktop.swingx.JXDatePicker;
import org.nuiton.i18n.I18n;

public class IntervalPanel
extends JPanel
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = 5973427750255668999L;
    protected List<IntervalListener> listeners = new ArrayList<IntervalListener>();
    protected JComboBox typeComboBox;
    protected CardLayout typeLayout;
    protected JPanel specificTypePanel;
    protected FiscalPeriodComboBoxModel fiscalPeriodComoboBoxModel;
    protected FinancialPeriodComboBoxModel financialPeriodComoboBoxModel;
    protected JXDatePicker beginDatePicker;
    protected JXDatePicker endDatePicker;

    public IntervalPanel() {
        super(new BorderLayout());
        this.initUI();
    }

    public void addIntervalListener(IntervalListener listener) {
        this.listeners.add(listener);
    }

    public void removeIntervalListener(IntervalListener listener) {
        this.listeners.remove(listener);
    }

    private void initUI() {
        this.typeComboBox = new JComboBox<String>(ComboBoxDatesEnum.descriptions());
        this.add((Component)this.typeComboBox, "West");
        this.typeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComboBoxDatesEnum type = ComboBoxDatesEnum.valueOfDescription((String)IntervalPanel.this.typeComboBox.getSelectedItem());
                IntervalPanel.this.typeLayout.show(IntervalPanel.this.specificTypePanel, type.name());
            }
        });
        this.typeLayout = new CardLayout();
        this.specificTypePanel = new JPanel(this.typeLayout);
        this.fiscalPeriodComoboBoxModel = new FiscalPeriodComboBoxModel();
        JComboBox<Object> fiscalPeriodComboBox = new JComboBox<Object>(this.fiscalPeriodComoboBoxModel);
        fiscalPeriodComboBox.setRenderer(new FiscalPeriodListRenderer());
        fiscalPeriodComboBox.addItemListener(this);
        this.specificTypePanel.add(fiscalPeriodComboBox, ComboBoxDatesEnum.FISCAL_PERIOD.name());
        this.financialPeriodComoboBoxModel = new FinancialPeriodComboBoxModel();
        JComboBox<Object> financialPeriodComboBox = new JComboBox<Object>(this.financialPeriodComoboBoxModel);
        financialPeriodComboBox.setRenderer(new FinancialPeriodListRenderer());
        financialPeriodComboBox.addItemListener(this);
        this.specificTypePanel.add(financialPeriodComboBox, ComboBoxDatesEnum.FINANCIAL_PERIOD.name());
        JPanel periodPanel = new JPanel(new GridBagLayout());
        JLabel beginLabel = new JLabel(I18n._((String)"lima.common.begindate", (Object[])new Object[0]));
        periodPanel.add((Component)beginLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.beginDatePicker = new JXDatePicker();
        this.beginDatePicker.addActionListener((ActionListener)this);
        periodPanel.add((Component)this.beginDatePicker, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        JLabel endLabel = new JLabel(I18n._((String)"lima.common.enddate", (Object[])new Object[0]));
        periodPanel.add((Component)endLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.endDatePicker = new JXDatePicker();
        this.endDatePicker.addActionListener((ActionListener)this);
        periodPanel.add((Component)this.endDatePicker, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.specificTypePanel.add((Component)periodPanel, ComboBoxDatesEnum.PERIOD.name());
        Date beginDate = DateUtils.truncate((Date)new Date(), (int)1);
        this.beginDatePicker.setDate(beginDate);
        this.endDatePicker.setDate(new Date());
        this.add((Component)this.specificTypePanel, "Center");
    }

    public void init(List<FiscalPeriod> fiscalPeriods, List<FinancialPeriod> financialPeriods) {
        this.fiscalPeriodComoboBoxModel.setObjects(fiscalPeriods);
        this.financialPeriodComoboBoxModel.setObjects(financialPeriods);
    }

    public Date getBeginDate() {
        Date beginDate = null;
        ComboBoxDatesEnum type = ComboBoxDatesEnum.valueOfDescription((String)this.typeComboBox.getSelectedItem());
        switch (type) {
            case PERIOD: {
                beginDate = this.beginDatePicker.getDate();
                break;
            }
            case FINANCIAL_PERIOD: {
                FinancialPeriod period = (FinancialPeriod)this.financialPeriodComoboBoxModel.getSelectedItem();
                if (period == null) break;
                beginDate = period.getBeginDate();
                break;
            }
            case FISCAL_PERIOD: {
                FiscalPeriod period = (FiscalPeriod)this.fiscalPeriodComoboBoxModel.getSelectedItem();
                if (period == null) break;
                beginDate = period.getBeginDate();
                break;
            }
        }
        return beginDate;
    }

    public Date getEndDate() {
        Date endDate = null;
        ComboBoxDatesEnum type = ComboBoxDatesEnum.valueOfDescription((String)this.typeComboBox.getSelectedItem());
        switch (type) {
            case PERIOD: {
                endDate = this.endDatePicker.getDate();
                break;
            }
            case FINANCIAL_PERIOD: {
                FinancialPeriod period = (FinancialPeriod)this.financialPeriodComoboBoxModel.getSelectedItem();
                if (period == null) break;
                endDate = period.getEndDate();
                break;
            }
            case FISCAL_PERIOD: {
                FiscalPeriod period = (FiscalPeriod)this.fiscalPeriodComoboBoxModel.getSelectedItem();
                if (period == null) break;
                endDate = period.getEndDate();
                break;
            }
        }
        return endDate;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.fireEvent();
        }
    }

    protected void fireEvent() {
        for (IntervalListener l : this.listeners) {
            l.intervalChanged(null);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.fireEvent();
    }
}

