/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.common;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.api.FinancialTransactionService;
import org.chorem.lima.business.utils.EntryComparator;
import org.chorem.lima.entity.Entry;
import org.chorem.lima.entity.EntryImpl;
import org.chorem.lima.entity.FinancialTransaction;
import org.chorem.lima.entity.FinancialTransactionImpl;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.common.TableModelWithGroup;
import org.chorem.lima.ui.financialtransaction.AccountColumn;
import org.chorem.lima.ui.financialtransaction.CreditColumn;
import org.chorem.lima.ui.financialtransaction.DateColumn;
import org.chorem.lima.ui.financialtransaction.DebitColumn;
import org.chorem.lima.ui.financialtransaction.DescriptionColumn;
import org.chorem.lima.ui.financialtransaction.VoucherColumn;

public class FinancialTransactionTableModel
extends TableModelWithGroup<Entry> {
    private static final long serialVersionUID = -7495388454688562991L;
    protected static final Log log = LogFactory.getLog(FinancialTransactionTableModel.class);
    protected FinancialTransactionService financialTransactionService;

    public FinancialTransactionTableModel() {
        this.setComparator(new EntryComparator());
        this.financialTransactionService = (FinancialTransactionService)LimaServiceFactory.getService(FinancialTransactionService.class);
    }

    @Override
    protected void initColumn() {
        this.addColumn(new DateColumn());
        this.addColumn(new VoucherColumn());
        this.addColumn(new AccountColumn());
        this.addColumn(new DescriptionColumn());
        this.addColumn(new DebitColumn());
        this.addColumn(new CreditColumn());
    }

    public void setTransactions(List<FinancialTransaction> transactions) {
        this.clear();
        for (FinancialTransaction transaction : transactions) {
            this.addAll(transaction.getEntry());
        }
    }

    public FinancialTransaction getTransactionAt(int row) {
        Entry entry = (Entry)this.get(row);
        return entry.getFinancialTransaction();
    }

    @Override
    public int indexOf(FinancialTransaction transaction) {
        Entry entry;
        int index = 0;
        Collection entriesTransaction = transaction.getEntry();
        Iterator i$ = this.values.iterator();
        while (i$.hasNext() && !entriesTransaction.contains(entry = (Entry)i$.next())) {
            ++index;
        }
        return index;
    }

    @Override
    public boolean contains(FinancialTransaction transaction) {
        boolean result = false;
        for (Entry entry : transaction.getEntry()) {
            if (!this.contains(entry)) continue;
            result = true;
            break;
        }
        return result;
    }

    public Entry addEntry(Entry entry) {
        EntryImpl newEntry = null;
        FinancialTransaction transaction = entry.getFinancialTransaction();
        if (this.contains(transaction)) {
            newEntry = new EntryImpl();
            newEntry.setFinancialTransaction(transaction);
            newEntry.setVoucher(entry.getVoucher());
            newEntry.setAccount(entry.getAccount());
            newEntry.setDescription(entry.getDescription());
            newEntry.setAmount(entry.getAmount());
            newEntry.setDebit(entry.getDebit());
            newEntry = this.financialTransactionService.createEntry((Entry)newEntry);
            transaction.addEntry((Entry)newEntry);
            this.financialTransactionService.updateFinancialTransaction(transaction);
            this.addValue(newEntry);
        }
        return newEntry;
    }

    public void removeTransaction(int row) {
        FinancialTransaction transaction = this.getTransactionAt(row);
        this.removeAll(transaction.getEntry());
        this.financialTransactionService.removeFinancialTransaction(transaction);
    }

    public void removeEntry(int row) {
        Entry entry = (Entry)this.get(row);
        FinancialTransaction transaction = entry.getFinancialTransaction();
        if (transaction.sizeEntry() > 1) {
            this.financialTransactionService.removeEntry(entry);
            transaction.removeEntry(entry);
            this.remove(entry);
        } else {
            this.financialTransactionService.removeFinancialTransaction(transaction);
            this.removeAll(transaction.getEntry());
        }
    }

    public FinancialTransaction addTransaction(FinancialTransaction transaction) {
        FinancialTransactionImpl newTransaction = new FinancialTransactionImpl();
        newTransaction.setEntryBook(transaction.getEntryBook());
        newTransaction.setTransactionDate(transaction.getTransactionDate());
        newTransaction = this.financialTransactionService.createFinancialTransaction((FinancialTransaction)newTransaction);
        if (transaction.getEntry() == null || transaction.getEntry().isEmpty()) {
            EntryImpl newEntry = new EntryImpl();
            newEntry.setFinancialTransaction((FinancialTransaction)newTransaction);
            newEntry = this.financialTransactionService.createEntry((Entry)newEntry);
            newTransaction.addEntry((Entry)newEntry);
            newEntry = new EntryImpl();
            newEntry.setFinancialTransaction((FinancialTransaction)newTransaction);
            newEntry = this.financialTransactionService.createEntry((Entry)newEntry);
            newTransaction.addEntry((Entry)newEntry);
        } else {
            for (Entry entry : transaction.getEntry()) {
                EntryImpl newEntry = new EntryImpl();
                newEntry.setFinancialTransaction((FinancialTransaction)newTransaction);
                newEntry.setVoucher(entry.getVoucher());
                newEntry.setAccount(entry.getAccount());
                newEntry.setDescription(entry.getDescription());
                newEntry.setAmount(entry.getAmount());
                newEntry.setDebit(entry.getDebit());
                newEntry = this.financialTransactionService.createEntry((Entry)newEntry);
                newTransaction.addEntry((Entry)newEntry);
            }
            this.financialTransactionService.updateFinancialTransaction((FinancialTransaction)newTransaction);
        }
        this.addAll(newTransaction.getEntry());
        return newTransaction;
    }

    public BigDecimal getBalanceTransactionInRow(int row) {
        FinancialTransaction transaction = this.getTransactionAt(row);
        BigDecimal debit = transaction.getAmountDebit();
        BigDecimal credit = transaction.getAmountCredit();
        BigDecimal balance = debit.subtract(credit);
        return balance;
    }

    @Override
    public boolean sameGroup(Entry e1, Entry e2) {
        return e1.getFinancialTransaction().equals(e2.getFinancialTransaction());
    }

    public void updateEntry(Entry entry) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Update Entry");
        }
        this.financialTransactionService.updateEntry(entry);
    }

    public void updateTransaction(FinancialTransaction transaction) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Update transaction");
        }
        this.financialTransactionService.updateFinancialTransaction(transaction);
    }

    public void fireTransaction(FinancialTransaction transaction) {
        int firstRow = this.indexOf(transaction);
        int lastRow = firstRow + transaction.sizeEntry() - 1;
        this.fireTableRowsUpdated(firstRow, lastRow);
    }
}

