/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.combobox;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.api.AccountService;
import org.chorem.lima.business.api.ImportService;
import org.chorem.lima.business.utils.AccountComparator;
import org.chorem.lima.entity.Account;
import org.chorem.lima.service.LimaServiceFactory;

public class LeafAccountComboBoxModel
extends AbstractListModel
implements ComboBoxModel,
ServiceListener {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(LeafAccountComboBoxModel.class);
    protected Object selectedAccount;
    protected List<Account> datasCache;
    protected AccountService accountService = (AccountService)LimaServiceFactory.getService(AccountService.class);

    public LeafAccountComboBoxModel() {
        LimaServiceFactory.addServiceListener(AccountService.class, (ServiceListener)this);
        LimaServiceFactory.addServiceListener(ImportService.class, (ServiceListener)this);
        this.datasCache = this.getDataList();
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedAccount;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.selectedAccount = anItem;
        this.fireContentsChanged(this, -1, -1);
    }

    @Override
    public Object getElementAt(int index) {
        return this.datasCache.get(index);
    }

    @Override
    public int getSize() {
        return this.datasCache.size();
    }

    public List<Account> getDataList() {
        ArrayList<Account> result;
        block2: {
            result = new ArrayList();
            try {
                result = this.accountService.getAllLeafAccounts();
            }
            catch (LimaException eee) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)"Can't get list subaccounts", (Throwable)eee);
            }
        }
        Collections.sort(result, new AccountComparator());
        return result;
    }

    public void refresh() {
        this.datasCache = this.getDataList();
        this.fireContentsChanged(this, 0, this.datasCache.size());
    }

    public void notifyMethod(String serviceName, String methodName) {
        if (serviceName.contains("Account") || methodName.contains("importAll")) {
            this.refresh();
        }
    }
}

