/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.combobox;

import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.api.FinancialPeriodService;
import org.chorem.lima.business.api.FiscalPeriodService;
import org.chorem.lima.business.api.ImportService;
import org.chorem.lima.entity.FinancialPeriod;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.service.LimaServiceFactory;

public class FinancialPeriodComboBoxModel
extends AbstractListModel
implements ComboBoxModel,
ServiceListener {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(FinancialPeriodComboBoxModel.class);
    protected Object selectedFinancialPeriod;
    protected List<FinancialPeriod> datasCache;
    protected FinancialPeriodService financialPeriodService;
    protected FiscalPeriod selectedFiscalPeriod;
    private boolean displayAllPeriods;

    public FinancialPeriodComboBoxModel() {
        this(false);
    }

    public FinancialPeriodComboBoxModel(boolean displayAllPeriods) {
        this.displayAllPeriods = displayAllPeriods;
        this.financialPeriodService = (FinancialPeriodService)LimaServiceFactory.getService(FinancialPeriodService.class);
        LimaServiceFactory.addServiceListener(FinancialPeriodService.class, (ServiceListener)this);
        LimaServiceFactory.addServiceListener(FiscalPeriodService.class, (ServiceListener)this);
        LimaServiceFactory.addServiceListener(ImportService.class, (ServiceListener)this);
        this.datasCache = displayAllPeriods ? this.getAllDataList() : this.getDataList();
        for (FinancialPeriod financialPeriod : this.datasCache) {
        }
    }

    public void setSelectedFiscalPeriod(FiscalPeriod fiscalPeriod) {
        this.selectedFiscalPeriod = fiscalPeriod;
        this.datasCache = this.displayAllPeriods ? this.getAllDataList() : this.getDataList();
        this.fireContentsChanged(this, 0, this.datasCache.size());
    }

    @Override
    public int getSize() {
        return this.datasCache.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.datasCache.get(index);
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.selectedFinancialPeriod = anItem;
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedFinancialPeriod;
    }

    public List<FinancialPeriod> getDataList() {
        List result;
        block2: {
            result = null;
            try {
                result = this.selectedFiscalPeriod != null ? this.financialPeriodService.getFinancialPeriods(this.selectedFiscalPeriod.getBeginDate(), this.selectedFiscalPeriod.getEndDate()) : this.financialPeriodService.getUnblockedFinancialPeriods();
            }
            catch (LimaException ex) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)"Can't get Financial Period list", (Throwable)ex);
            }
        }
        return result;
    }

    public List<FinancialPeriod> getAllDataList() {
        List result;
        block2: {
            result = null;
            try {
                result = this.selectedFiscalPeriod != null ? this.financialPeriodService.getFinancialPeriods(this.selectedFiscalPeriod.getBeginDate(), this.selectedFiscalPeriod.getEndDate()) : this.financialPeriodService.getAllFinancialPeriods();
            }
            catch (LimaException ex) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)"Can't get Financial Period list", (Throwable)ex);
            }
        }
        return result;
    }

    public void refresh() {
        this.datasCache = this.getDataList();
        this.fireContentsChanged(this, 0, this.datasCache.size());
    }

    public void refreshAll() {
        this.datasCache = this.getAllDataList();
        this.fireContentsChanged(this, 0, this.datasCache.size());
    }

    public void notifyMethod(String serviceName, String methodeName) {
        if (serviceName.contains("Period") || methodeName.contains("importAll")) {
            this.datasCache = this.displayAllPeriods ? this.getAllDataList() : this.getDataList();
        }
    }
}

