/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima;

import java.util.Arrays;
import java.util.Date;
import javax.swing.SwingUtilities;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaConfig;
import org.chorem.lima.LimaContext;
import org.chorem.lima.LimaExceptionHandler;
import org.chorem.lima.LimaSplash;
import org.chorem.lima.business.api.AccountService;
import org.chorem.lima.business.api.HttpServerService;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.MainView;
import org.chorem.lima.ui.MainViewHandler;
import org.chorem.lima.ui.opening.OpeningView;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.i18n.I18n;

public class LimaMain {
    private static final Log log = LogFactory.getLog(LimaMain.class);
    public static LimaConfig config;
    private static LimaSplash splash;

    public static void main(String[] args) throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("Lima starts at " + new Date()));
            log.info((Object)("Args: " + Arrays.toString(args)));
        }
        LimaContext context = LimaMain.init(args);
        config = context.getConfig();
        config.doAction(1);
        if (config.isLaunchui()) {
            Thread.setDefaultUncaughtExceptionHandler(new LimaExceptionHandler());
            System.setProperty("sun.awt.exception.handler", LimaExceptionHandler.class.getName());
            LimaMain.launch(context);
        }
    }

    public static LimaContext init(String ... args) throws Exception {
        splash = new LimaSplash();
        splash.initSplash();
        System.setSecurityManager(null);
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        LimaContext context = LimaContext.init();
        LimaConfig config = context.getConfig();
        config.parse(args);
        context.initI18n(config);
        return context;
    }

    protected static void launch(LimaContext context) throws Exception {
        block5: {
            try {
                SwingUtil.initNimbusLoookAndFeel();
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block5;
                log.warn((Object)I18n._((String)"lima.warning.nimbus.landf", (Object[])new Object[0]));
            }
        }
        splash.drawVersion(config.getVersion());
        splash.updateProgression(0.1, I18n._((String)"lima.splash.1", (Object[])new Object[0]));
        LimaServiceFactory.initFactory((ApplicationConfig)config);
        MainViewHandler uiHandler = (MainViewHandler)context.getContextValue(MainViewHandler.class);
        final MainView ui = uiHandler.initUI(context, context.getConfig().isFullScreen());
        ui.setLocationRelativeTo(null);
        uiHandler.showHomeView((JAXXContext)context);
        splash.updateProgression(0.7, I18n._((String)"lima.splash.2", (Object[])new Object[0]));
        ((HttpServerService)LimaServiceFactory.getService(HttpServerService.class)).start();
        AccountService accountService = (AccountService)LimaServiceFactory.getService(AccountService.class);
        long accountCount = accountService.getAccountCount();
        if (accountCount == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Propose for default account loading");
            }
            OpeningView openingView = new OpeningView();
            openingView.setSize(800, 400);
            openingView.setLocationRelativeTo(null);
            openingView.setVisible(true);
        } else {
            splash.updateProgression(1.0, I18n._((String)"lima.splash.3", (Object[])new Object[0]));
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ui.setVisible(true);
            }
        });
    }

    public static class ShutdownHook
    extends Thread {
        public ShutdownHook() {
            super("Shutdown Lima");
        }

        @Override
        public void run() {
            try {
                LimaContext.get().close();
                LimaServiceFactory.destroy();
                if (log.isInfoEnabled()) {
                    log.info((Object)I18n._((String)"lima.init.closed", (Object[])new Object[]{new Date()}));
                }
                Runtime.getRuntime().halt(0);
            }
            catch (Exception ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)I18n._((String)"lima.init.errorclosing", (Object[])new Object[0]), (Throwable)ex);
                }
                Runtime.getRuntime().halt(1);
            }
        }
    }
}

