/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima;

import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaConfig;
import org.chorem.lima.business.LimaBusinessException;
import org.chorem.lima.util.ErrorHelper;
import org.nuiton.i18n.I18n;

public class LimaExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Log log = LogFactory.getLog(LimaExceptionHandler.class);

    @Override
    public void uncaughtException(Thread t, Throwable ex) {
        this.handleException(t.getName(), ex);
    }

    public void handle(Throwable thrown) {
        this.handleException(Thread.currentThread().getName(), thrown);
    }

    protected void handleException(String tname, Throwable ex) {
        Throwable cause;
        if (log.isErrorEnabled()) {
            log.error((Object)"Global application exception", ex);
        }
        for (cause = ex; cause != null && !(cause instanceof LimaBusinessException); cause = cause.getCause()) {
        }
        if (cause instanceof LimaBusinessException) {
            JOptionPane.showMessageDialog(null, cause.getMessage(), I18n._((String)"lima.ui.common.error", (Object[])new Object[0]), 0);
        } else {
            ErrorHelper errorHelper = new ErrorHelper(LimaConfig.getInstance());
            errorHelper.showErrorDialog(null, ex.getMessage(), ex);
        }
    }
}

