/*
 * #%L
 * Lima Swing
 * 
 * $Id: IdentityHandler.java 3377 2012-04-18 08:42:09Z echatellier $
 * $HeadURL: https://svn.chorem.org/lima/tags/lima-0.7.1/lima-swing/src/main/java/org/chorem/lima/ui/identity/IdentityHandler.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.identity;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.api.IdentityService;
import org.chorem.lima.entity.Identity;
import org.chorem.lima.entity.IdentityImpl;
import org.chorem.lima.service.LimaServiceFactory;

public class IdentityHandler {

    protected IdentityService identityService;

    private static final Log log = LogFactory.getLog(IdentityHandler.class);


    public IdentityHandler() {
        identityService =
                LimaServiceFactory.getService(
                        IdentityService.class);
    }

    public Identity getIdentity() {
        Identity identity = null;
        try {
            identity = identityService.getIdentity();
        } catch (LimaException eee) {
            if (log.isDebugEnabled()) {
                log.debug("Can't get Identity", eee);
            }
        }
        if (identity == null) {
            identity = new IdentityImpl();
        }
        return identity;
    }

    public void updateIdentity(Identity identity) {

        try {
            identityService.updateIdentity(identity);
        } catch (LimaException eee) {
            if (log.isDebugEnabled()) {
                log.debug("Can't update Identity", eee);
            }
        }
    }
}
