package org.chorem.lima.ui.financialstatementchart;

/*
 * #%L
 * Lima :: Swing
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2008 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JToolBar.Separator;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import static org.nuiton.i18n.I18n._;

public class FinancialStatementChartView extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_SELECTED_ROW = "selectedRow";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_FINANCIAL_STATEMENT_MOVEMENT_ENABLED = "addFinancialStatementMovement.enabled";
    public static final String BINDING_REMOVE_BUTTON_ENABLED = "removeButton.enabled";
    public static final String BINDING_UPDATE_BUTTON_ENABLED = "updateButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK2VO28TQRDHNyYPHCcB4pCHkkAAU9CckSgoEiAPZEJwIIothHDD+m7j27DePXb3kqNBfAQ+AvQ0SHRUiIKaggbxFRCioEXMnmNfnFycE8aSfdbszG9nZmf/9/YH6lMSXdjGQWBJn2taJ9ba0qNHD6rbxNa3ibIl9bSQqPHpSaFUBWWcll1pdKlSNOH5vfD8iqh7ghO+L3q+iAaVfs6IcgnRGs22R9hK5Uut5fnA82WT2koqjvr618/UK+flmxRCgQfZjUApc8dFRZX0FlGKOhqNwk47OM8wr0EakvIa5DtsbCsMK3Uf18kz9AINFFG/hyXANLqYvOSQEcYHnkYDuTKuMnJVo4KQNct2hSR1i9E6tnxqbVGOuU0xUxprUgeg7WKprULTXmraV4z9ISW7nhfC+wHtYu4wIjVa/z/o1QYv2iGjCIOpIM6m2NXojOmQZbpmLQvBCOaR52BurQy2ZSyh0jHjGFhqFzprNe3GMd3yn8aOcziTVYIdU0+2DbDsay24CRxtxc/Gxq+LnfBpnCbaA4Z8zwGviHVwHXoH0UevUzhxqY9cH2s1IFciMDUYRgJacS6uFZFHOyNju8R+euQWw7m1ki0FYxuYm4GaaGNHS+2dTmtJSDiDGt3rfk7KTZrBX95XfpEqXQrHhQq+LhzCDpZ/2APmR6LptgsM0mBF0hDd3Z4K6pM+mDWarBxWk01YaujI5AEdMcBw9c949uuH7+8LTfHIwt5nY133aR9cak8KD4aSmq1PNZTD15Tl17E3X0HpxhUJhXEmJrHS3jIkB/s1rpAJt1axcgHRN/Dt46fxJ19OoFQBDTKBnQI2/nfh4FwJXRDMCbxbi2FGQ7sn4fe0yQ0Odgu8deNgRxcoZ5STOaxBz6q+JjcD6MVMTC9aCVXTn39nS+8Wm/3ogfymjnSPetL3GPU3dgvldE8pY+Uz4yniOyJSxDiN7DHPrLenJdfC3+txBfdSW3CNRhbgIuO5KuUOTBXUaQLmwwLMvxshbzwBL6PhOpapVyZBqBjL/4oy5qUOhKkEyQwQbo7S6QpjzHe6JnQqZToRYaNrQqcqkhE6VTHbdRXJCJ2qSEboVMX5rnNIRuiUQ67rHI4nwMvXpTWXwVcTqTqwriRgDav9r6AuYSOtl2v4PjuG9hf55tWPfQsAAA==";
    public static final String PROPERTY$LIST_SELECTION_MODEL0 = "$ListSelectionModel0";
    private static final Log log = LogFactory.getLog(FinancialStatementChartView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addFinancialStatementHeader;
    protected JButton addFinancialStatementMovement;
    protected JButton checkButton;
    protected FinancialStatementChartViewHandler handler;
    protected JButton importButton;
    protected JButton removeButton;
    protected Boolean selectedRow;
    protected FinancialStatementChartTreeTable treeTable;
    protected JButton updateButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JScrollPane $JScrollPane0;
    private Separator $JToolBar$Separator0;
    private JToolBar $JToolBar0;
    private ListSelectionModel $ListSelectionModel0;
    private FinancialStatementChartView $Table0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FinancialStatementChartView() {
        $initialize();
    }

    public FinancialStatementChartView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addFinancialStatementHeader(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addFinancialStatementHeader();
    }

    public void doActionPerformed__on__addFinancialStatementMovement(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addFinancialStatementMovement();
    }

    public void doActionPerformed__on__checkButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.financialStatementChartCheck();
    }

    public void doActionPerformed__on__importButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.importFinancialStatementChart();
    }

    public void doActionPerformed__on__removeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.removeFinancialStatement();
    }

    public void doActionPerformed__on__updateButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.updateFinancialStatement();
    }

    public void doValueChanged__on__$ListSelectionModel0(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setSelectedRow(treeTable.getSelectedRow() != -1);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddFinancialStatementHeader() {
        return addFinancialStatementHeader;
    }

    public JButton getAddFinancialStatementMovement() {
        return addFinancialStatementMovement;
    }

    public JButton getCheckButton() {
        return checkButton;
    }

    public FinancialStatementChartViewHandler getHandler() {
        return handler;
    }

    public JButton getImportButton() {
        return importButton;
    }

    public JButton getRemoveButton() {
        return removeButton;
    }

    public Boolean getSelectedRow() {
        return selectedRow;
    }

    public FinancialStatementChartTreeTable getTreeTable() {
        return treeTable;
    }

    public JButton getUpdateButton() {
        return updateButton;
    }

    public Boolean isSelectedRow() {
        return selectedRow !=null && selectedRow;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$ListSelectionModel0(ListSelectionModel $ListSelectionModel0) {
        ListSelectionModel oldValue = this.$ListSelectionModel0;
        this.$ListSelectionModel0 = $ListSelectionModel0;
        firePropertyChange(PROPERTY$LIST_SELECTION_MODEL0, oldValue, $ListSelectionModel0);
    }

    public void setHandler(FinancialStatementChartViewHandler handler) {
        FinancialStatementChartViewHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    public void setSelectedRow(Boolean selectedRow) {
        Boolean oldValue = this.selectedRow;
        this.selectedRow = selectedRow;
        firePropertyChange(PROPERTY_SELECTED_ROW, oldValue, selectedRow);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Separator get$JToolBar$Separator0() {
        return $JToolBar$Separator0;
    }

    protected JToolBar get$JToolBar0() {
        return $JToolBar0;
    }

    protected ListSelectionModel get$ListSelectionModel0() {
        return $ListSelectionModel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAddFinancialStatementHeader() {
        $objectMap.put("addFinancialStatementHeader", addFinancialStatementHeader = new JButton());
        
        addFinancialStatementHeader.setName("addFinancialStatementHeader");
        addFinancialStatementHeader.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addFinancialStatementHeader"));
    }

    protected void createAddFinancialStatementMovement() {
        $objectMap.put("addFinancialStatementMovement", addFinancialStatementMovement = new JButton());
        
        addFinancialStatementMovement.setName("addFinancialStatementMovement");
        addFinancialStatementMovement.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addFinancialStatementMovement"));
    }

    protected void createCheckButton() {
        $objectMap.put("checkButton", checkButton = new JButton());
        
        checkButton.setName("checkButton");
        checkButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__checkButton"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new FinancialStatementChartViewHandler(this));
    }

    protected void createImportButton() {
        $objectMap.put("importButton", importButton = new JButton());
        
        importButton.setName("importButton");
        importButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__importButton"));
    }

    protected void createRemoveButton() {
        $objectMap.put("removeButton", removeButton = new JButton());
        
        removeButton.setName("removeButton");
        removeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeButton"));
    }

    protected void createSelectedRow() {
        $objectMap.put("selectedRow", selectedRow = false);
    }

    protected void createTreeTable() {
        $objectMap.put("treeTable", treeTable = new FinancialStatementChartTreeTable(getHandler()));
        
        treeTable.setName("treeTable");
    }

    protected void createUpdateButton() {
        $objectMap.put("updateButton", updateButton = new JButton());
        
        updateButton.setName("updateButton");
        updateButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__updateButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add($JToolBar0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JToolBar0
        $JToolBar0.add(addFinancialStatementHeader);
        $JToolBar0.add(addFinancialStatementMovement);
        $JToolBar0.add(updateButton);
        $JToolBar0.add(removeButton);
        $JToolBar0.add(importButton);
        $JToolBar0.add($JToolBar$Separator0);
        $JToolBar0.add(checkButton);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(treeTable);
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 15 property setters
        addFinancialStatementHeader.setIcon(SwingUtil.createActionIcon("financialstatement-add-header"));
        addFinancialStatementHeader.setToolTipText( _("lima.financialstatement.header.add") + " (Ctrl+Maj+N)");
        addFinancialStatementMovement.setIcon(SwingUtil.createActionIcon("financialstatement-add-movement"));
        addFinancialStatementMovement.setToolTipText( _("lima.financialstatement.movement.add") + " (Ctrl+N)");
        updateButton.setIcon(SwingUtil.createActionIcon("financialstatement-edit"));
        updateButton.setToolTipText( _("lima.common.update") + " (Ctrl+M)");
        removeButton.setIcon(SwingUtil.createActionIcon("financialstatement-remove"));
        removeButton.setToolTipText( _("lima.common.remove") + " (Del)");
        importButton.setIcon(SwingUtil.createActionIcon("financialstatement-import"));
        importButton.setToolTipText( _("lima.ui.importexport.import") + " (Ctrl+I)");
        checkButton.setIcon(SwingUtil.createActionIcon("financialstatement-check"));
        checkButton.setToolTipText( _("lima.financialstatement.check") + " (Ctrl+F)");
        treeTable.setHighlighters(HighlighterFactory.createSimpleStriping(new java.awt.Color(222,222,222)));
        treeTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        treeTable.setTreeTableModel(new FinancialStatementChartTreeTableModel());
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        createSelectedRow();
        // inline creation of $JToolBar0
        $objectMap.put("$JToolBar0", $JToolBar0 = new JToolBar());
        
        $JToolBar0.setName("$JToolBar0");
        $JToolBar0.setFloatable(false);
        createAddFinancialStatementHeader();
        createAddFinancialStatementMovement();
        createUpdateButton();
        createRemoveButton();
        createImportButton();
        // inline creation of $JToolBar$Separator0
        $objectMap.put("$JToolBar$Separator0", $JToolBar$Separator0 = new Separator());
        
        $JToolBar$Separator0.setName("$JToolBar$Separator0");
        createCheckButton();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createTreeTable();
        // inline creation of $ListSelectionModel0
        $objectMap.put("$ListSelectionModel0", $ListSelectionModel0 = getTreeTable().getSelectionModel());
        
        $ListSelectionModel0.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__$ListSelectionModel0"));
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ADD_FINANCIAL_STATEMENT_MOVEMENT_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                addFinancialStatementMovement.setEnabled(isSelectedRow());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_UPDATE_BUTTON_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                updateButton.setEnabled(isSelectedRow());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_BUTTON_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                removeButton.setEnabled(isSelectedRow());
            }
        });
    }

}