/*
 * #%L
 * Lima Swing
 * 
 * $Id: EntryBookComboBoxModel.java 3603 2012-08-13 14:42:17Z mallon $
 * $HeadURL: https://svn.chorem.org/lima/tags/lima-0.7.1/lima-swing/src/main/java/org/chorem/lima/ui/combobox/EntryBookComboBoxModel.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.combobox;

import java.util.List;

import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.api.EntryBookService;
import org.chorem.lima.business.api.ImportService;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.service.LimaServiceFactory;

/**
 * Opened financial period combo box model.
 *
 * @author chatellier
 * @version $Revision: 3603 $
 *          <p/>
 *          Last update : $Date: 2012-08-13 16:42:17 +0200 (Mon, 13 Aug 2012) $
 *          By : $Author: mallon $
 */
public class EntryBookComboBoxModel extends AbstractListModel implements ComboBoxModel, ServiceListener {

    private static final long serialVersionUID = 1L;

    private static final Log log =
            LogFactory.getLog(EntryBookComboBoxModel.class);

    protected Object selectedEntryBook;

    protected EntryBookService entryBookService;

    protected List<EntryBook> cacheDatas;

    public EntryBookComboBoxModel() {
        entryBookService =
                LimaServiceFactory.getService(EntryBookService.class);
        LimaServiceFactory.addServiceListener(EntryBookService.class, this);
        LimaServiceFactory.addServiceListener(ImportService.class, this);
        cacheDatas = getDataList();
    }

    @Override
    public int getSize() {
        return cacheDatas.size();
    }

    @Override
    public Object getElementAt(int index) {
        return cacheDatas.get(index);
    }

    @Override
    public void setSelectedItem(Object anItem) {
        selectedEntryBook = anItem;
        fireContentsChanged(this, -1, -1);
    }

    @Override
    public Object getSelectedItem() {
        return selectedEntryBook;
    }

    /** get the accounts list */
    public List<EntryBook> getDataList() {
        List<EntryBook> result = null;
        try {
            result = entryBookService.getAllEntryBooks();
        } catch (LimaException eee) {
            if (log.isDebugEnabled()) {
                log.debug("Can't get list entry books", eee);
            }
        }
        return result;
    }


    public void refresh() {
        cacheDatas = getDataList();
        fireContentsChanged(this, 0, cacheDatas.size());
    }

    @Override
    public void notifyMethod(String serviceName, String methodeName) {
        if (methodeName.contains("EntryBook") || methodeName.contains("importAll")) {
            refresh();
        }
    }
}
