/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransactionsearch;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComboBox;
import org.chorem.lima.ui.combobox.LetterComboBoxModel;
import org.chorem.lima.ui.financialtransactionsearch.FinancialTransactionSearchViewHandler;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;

public class LetterSearchComboBox
extends JComboBox
implements KeyListener {
    private static final long serialVersionUID = 1L;
    protected FinancialTransactionSearchViewHandler handler;

    public LetterSearchComboBox(FinancialTransactionSearchViewHandler handler) {
        this.handler = handler;
        LetterComboBoxModel letterComboBoxModel = new LetterComboBoxModel();
        this.setModel(letterComboBoxModel);
        this.setEditable(true);
        ObjectToStringConverter objectToStringConverter = new ObjectToStringConverter(){

            public String getPreferredStringForItem(Object item) {
                String result = null;
                if (item != null && item instanceof String) {
                    result = item.toString();
                }
                return result;
            }
        };
        AutoCompleteDecorator.decorate((JComboBox)this, (ObjectToStringConverter)objectToStringConverter);
        this.getEditor().getEditorComponent().addKeyListener(this);
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object object = this.getSelectedItem();
        if (object instanceof String) {
            this.handler.setLetter((String)this.getSelectedItem());
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        String letter;
        Object object = this.getSelectedItem();
        if (object instanceof String && !(letter = (String)this.getSelectedItem()).equals(this.handler.getLetter())) {
            this.handler.setLetter(letter);
        }
        if (e.getKeyChar() == '\n') {
            this.firePopupMenuCanceled();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

