/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransaction;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.api.EntryBookService;
import org.chorem.lima.business.api.FinancialPeriodService;
import org.chorem.lima.business.api.FinancialTransactionService;
import org.chorem.lima.business.api.FiscalPeriodService;
import org.chorem.lima.business.api.ImportService;
import org.chorem.lima.business.utils.EntryComparator;
import org.chorem.lima.entity.Entry;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.entity.EntryImpl;
import org.chorem.lima.entity.FinancialPeriod;
import org.chorem.lima.entity.FinancialTransaction;
import org.chorem.lima.entity.FinancialTransactionImpl;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionTable;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionTableModel;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionView;
import org.nuiton.i18n.I18n;

public class FinancialTransactionViewHandler
implements ServiceListener {
    private static final Log log = LogFactory.getLog(FinancialTransactionViewHandler.class);
    protected FinancialTransactionView view;
    protected Object clipBoard;
    protected EntryBookService entryBookService;
    protected FinancialPeriodService financialPeriodService;
    protected FiscalPeriodService fiscalPeriodService;
    protected FinancialTransactionService financialTransactionService;

    public FinancialTransactionViewHandler(FinancialTransactionView view) {
        this.view = view;
        this.entryBookService = (EntryBookService)LimaServiceFactory.getService(EntryBookService.class);
        this.financialPeriodService = (FinancialPeriodService)LimaServiceFactory.getService(FinancialPeriodService.class);
        this.fiscalPeriodService = (FiscalPeriodService)LimaServiceFactory.getService(FiscalPeriodService.class);
        this.financialTransactionService = (FinancialTransactionService)LimaServiceFactory.getService(FinancialTransactionService.class);
        LimaServiceFactory.addServiceListener(FinancialPeriodService.class, (ServiceListener)this);
        LimaServiceFactory.addServiceListener(FiscalPeriodService.class, (ServiceListener)this);
        LimaServiceFactory.addServiceListener(ImportService.class, (ServiceListener)this);
    }

    public void init() {
        List fiscalPeriods = this.fiscalPeriodService.getAllUnblockedFiscalPeriods();
        this.view.getFiscalPeriodComboBoxModel().setObjects(fiscalPeriods);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Loaded %d fiscal periods", fiscalPeriods.size()));
        }
        if (!fiscalPeriods.isEmpty()) {
            this.view.getFiscalPeriodComboBoxModel().setSelectedItem(fiscalPeriods.get(0));
        }
        List allEntryBooks = this.entryBookService.getAllEntryBooks();
        this.view.getEntryBookComboBoxModel().setObjects(allEntryBooks);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Loaded %d entry books", allEntryBooks.size()));
        }
    }

    public void fiscalPeriodSelected(ItemEvent event) {
        if (event.getStateChange() == 1) {
            FiscalPeriod selectedFiscalPeriod = (FiscalPeriod)event.getItem();
            List financialPeriods = this.financialPeriodService.getFinancialPeriods(selectedFiscalPeriod.getBeginDate(), selectedFiscalPeriod.getEndDate());
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Loaded %d financial periods", financialPeriods.size()));
            }
            this.view.getFinancialPeriodComboBoxModel().setObjects(financialPeriods);
            this.view.getFinancialPeriodComboBoxModel().setSelectedItem(financialPeriods.get(0));
            this.updateFinancialTransactions();
        }
    }

    public void financialPeriodSelected(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.updateFinancialTransactions();
        }
    }

    public void entryBookSelected(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.updateFinancialTransactions();
        }
    }

    public void updateFinancialTransactions() {
        FinancialPeriod financialPeriod = (FinancialPeriod)this.view.getFinancialPeriodComboBox().getSelectedItem();
        EntryBook entryBook = (EntryBook)this.view.getEntryBookComboBox().getSelectedItem();
        if (financialPeriod == null) {
            return;
        }
        ArrayList<Object> transAndEntries = new ArrayList<Object>();
        List transactions = entryBook == null ? this.financialTransactionService.getAllFinancialTransactions(financialPeriod) : this.financialTransactionService.getAllFinancialTransactions(financialPeriod, entryBook);
        for (FinancialTransaction transaction : transactions) {
            transAndEntries.add(transaction);
            List entries = (List)transaction.getEntry();
            Collections.sort(entries, new EntryComparator());
            transAndEntries.addAll(entries);
        }
        this.view.getFinancialTransactionTableModel().setTransactionAndEntries(transAndEntries);
    }

    public void copyRow(int indexSelectedRow) {
        this.clipBoard = this.view.getFinancialTransactionTableModel().getElementAt(indexSelectedRow);
    }

    public void pasteRow(int indexSelectedRow) {
        FinancialTransactionTable table = this.view.getFinancialTransactionTable();
        ListSelectionModel selectionModel = table.getSelectionModel();
        if (this.clipBoard instanceof Entry) {
            int index = this.addEntry((Entry)this.clipBoard, indexSelectedRow);
            selectionModel.setSelectionInterval(indexSelectedRow + 1, indexSelectedRow + 1);
            table.changeSelection(index, 1, false, false);
            table.requestFocusInWindow();
        } else {
            FinancialTransactionTableModel tableModel = this.view.getFinancialTransactionTableModel();
            FinancialTransaction financialTransactionTemp = (FinancialTransaction)this.clipBoard;
            int nbentries = financialTransactionTemp.getEntry().size() + 1;
            FinancialTransactionImpl financialTransaction = new FinancialTransactionImpl();
            financialTransaction.setEntryBook(financialTransactionTemp.getEntryBook());
            financialTransaction.setTransactionDate(financialTransactionTemp.getTransactionDate());
            this.financialTransactionService.createFinancialTransaction((FinancialTransaction)financialTransaction);
            tableModel.addRow(financialTransaction);
            selectionModel.setSelectionInterval(indexSelectedRow + nbentries, indexSelectedRow + nbentries);
        }
    }

    protected int addEntry(Entry entry, int row) {
        FinancialTransactionTableModel tableModel = this.view.getFinancialTransactionTableModel();
        FinancialTransactionTable table = this.view.getFinancialTransactionTable();
        FinancialTransaction currentTransaction = null;
        int financialTransactionRow = 0;
        Object currentRow = tableModel.getElementAt(row);
        if (currentRow instanceof FinancialTransaction) {
            currentTransaction = (FinancialTransaction)currentRow;
            financialTransactionRow = tableModel.indexOf(currentRow);
        } else if (currentRow instanceof Entry) {
            Entry currentEntry = (Entry)currentRow;
            currentTransaction = currentEntry.getFinancialTransaction();
            financialTransactionRow = tableModel.indexOf(((Entry)currentRow).getFinancialTransaction());
        }
        entry.setFinancialTransaction(currentTransaction);
        Entry newEntry = this.financialTransactionService.createEntry(entry);
        currentTransaction.addEntry(entry);
        int newRow = financialTransactionRow + currentTransaction.getEntry().size();
        tableModel.addRow(newEntry, newRow);
        table.addRowSelectionInterval(newRow, newRow);
        return newRow;
    }

    public void addFinancialTransaction() {
        FinancialTransactionTable table = this.view.getFinancialTransactionTable();
        ListSelectionModel selectionModel = table.getSelectionModel();
        this.addFinancialTransactionAfterService();
        int numberRow = table.getRowCount() - 1;
        selectionModel.setSelectionInterval(numberRow, numberRow);
        table.changeSelection(numberRow, 0, false, false);
        table.scrollCellToVisible(numberRow, 0);
    }

    public void addFinancialTransactionAfterService() {
        FinancialPeriod financialPeriod = (FinancialPeriod)this.view.getFinancialPeriodComboBox().getSelectedItem();
        EntryBook entryBook = (EntryBook)this.view.getEntryBookComboBox().getSelectedItem();
        FinancialTransactionTableModel tableModel = this.view.getFinancialTransactionTableModel();
        FinancialTransactionImpl financialTransaction = new FinancialTransactionImpl();
        if (entryBook != null) {
            financialTransaction.setEntryBook(entryBook);
        }
        Calendar actualCalendar = Calendar.getInstance();
        Date transactionDate = financialPeriod.getBeginDate();
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(financialPeriod.getEndDate());
        int dayMax = calEnd.get(5);
        Calendar calBegin = Calendar.getInstance();
        calBegin.setTime(financialPeriod.getBeginDate());
        int dayMin = calBegin.get(5);
        int toDay = actualCalendar.get(5);
        transactionDate = toDay > dayMax || toDay < dayMin ? DateUtils.setDays((Date)transactionDate, (int)dayMax) : DateUtils.setDays((Date)transactionDate, (int)toDay);
        financialTransaction.setTransactionDate(transactionDate);
        FinancialTransaction fTransaction = this.financialTransactionService.createFinancialTransaction((FinancialTransaction)financialTransaction);
        tableModel.addRow(fTransaction);
    }

    public void addEntry() {
        FinancialTransactionTable table = this.view.getFinancialTransactionTable();
        FinancialTransactionTableModel tableModel = this.view.getFinancialTransactionTableModel();
        int indexSelectedRow = table.getSelectedRow();
        if (indexSelectedRow != -1) {
            String defaultAccount;
            Object entryOrTransaction = tableModel.getObjectAt(indexSelectedRow);
            Entry lastEntryOfTransaction = entryOrTransaction instanceof Entry ? this.financialTransactionService.getLastEntry(((Entry)entryOrTransaction).getFinancialTransaction()) : this.financialTransactionService.getLastEntry((FinancialTransaction)entryOrTransaction);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Selected row : " + indexSelectedRow));
            }
            String defaultVoucher = null;
            String defaultDescription = null;
            if (lastEntryOfTransaction != null) {
                defaultVoucher = lastEntryOfTransaction.getVoucher();
                defaultDescription = lastEntryOfTransaction.getDescription();
            }
            EntryImpl entry = new EntryImpl();
            entry.setVoucher(defaultVoucher);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Description of precedent entry : " + defaultDescription));
            }
            entry.setDescription(defaultDescription);
            BigDecimal tvaPercentAdd = new BigDecimal(0.196);
            BigDecimal tvaTax = null;
            if (lastEntryOfTransaction != null && lastEntryOfTransaction.getAccount() != null && ((defaultAccount = lastEntryOfTransaction.getAccount().getAccountNumber()).equals("410") || defaultAccount.equals("418"))) {
                tvaTax = lastEntryOfTransaction.getAmount().multiply(tvaPercentAdd);
            }
            if (tvaTax != null) {
                entry.setAmount(tvaTax);
                entry.setDebit(true);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("tva : " + tvaTax));
            }
            FinancialTransaction currentTransaction = null;
            Object currentRow = tableModel.getElementAt(indexSelectedRow);
            if (currentRow instanceof FinancialTransaction) {
                currentTransaction = (FinancialTransaction)currentRow;
            } else if (currentRow instanceof Entry) {
                Entry currentEntry = (Entry)currentRow;
                currentTransaction = currentEntry.getFinancialTransaction();
            }
            entry.setFinancialTransaction(currentTransaction);
            Entry newEntry = this.financialTransactionService.createEntry((Entry)entry);
            currentTransaction.addEntry(newEntry);
            int addIndex = tableModel.indexOf(currentTransaction) + currentTransaction.getEntry().size();
            tableModel.addRow(newEntry, addIndex);
            ListSelectionModel selectionModel = table.getSelectionModel();
            selectionModel.setSelectionInterval(addIndex, addIndex);
            table.changeSelection(addIndex, 1, false, false);
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"Call addentry selected transaction without selection");
        }
    }

    public void deleteSelectedRow() {
        FinancialTransactionTable table = this.view.getFinancialTransactionTable();
        FinancialTransactionTableModel tableModel = this.view.getFinancialTransactionTableModel();
        int indexSelectedRow = table.getSelectedRow();
        if (indexSelectedRow != -1) {
            Object selectedValue = tableModel.getElementAt(indexSelectedRow);
            int response = selectedValue instanceof FinancialTransaction ? JOptionPane.showConfirmDialog((Component)((Object)this.view), I18n._((String)"lima.ui.financialtransaction.messageremovetransaction", (Object[])new Object[0]), I18n._((String)"lima.ui.financialtransaction.titleremovetransaction", (Object[])new Object[0]), 0) : JOptionPane.showConfirmDialog((Component)((Object)this.view), I18n._((String)"lima.ui.financialtransaction.messageremoveentry", (Object[])new Object[0]), I18n._((String)"lima.ui.financialtransaction.titleremoveentry", (Object[])new Object[0]), 0);
            if (response == 0) {
                if (selectedValue instanceof FinancialTransaction) {
                    FinancialTransaction currentTransaction = (FinancialTransaction)selectedValue;
                    Collection entries = currentTransaction.getEntry();
                    if (entries != null) {
                        for (Entry entry : entries) {
                            tableModel.deleteRow(tableModel.indexOf(entry));
                        }
                    }
                    this.financialTransactionService.removeFinancialTransaction(currentTransaction);
                } else if (selectedValue instanceof Entry) {
                    Entry currentEntry = (Entry)selectedValue;
                    this.financialTransactionService.removeEntry(currentEntry);
                    currentEntry.getFinancialTransaction().removeEntry(currentEntry);
                }
                tableModel.deleteRow(indexSelectedRow);
                ListSelectionModel selectionModel = table.getSelectionModel();
                selectionModel.setSelectionInterval(indexSelectedRow - 1, indexSelectedRow - 1);
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"Call delete selected row without selection");
        }
    }

    public void back(JComboBox comboBox) {
        int row = comboBox.getSelectedIndex();
        if (row > 0) {
            comboBox.setSelectedIndex(row - 1);
        }
    }

    public void next(JComboBox comboBox) {
        int size = comboBox.getModel().getSize();
        int row = comboBox.getSelectedIndex();
        if (row < size - 1) {
            comboBox.setSelectedIndex(row + 1);
        }
    }

    public void notifyMethod(String serviceName, String methodName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Method notified " + serviceName + "#" + methodName));
        }
        if (serviceName.contains("FinancialTransaction") || methodName.contains("importEntries") || methodName.contains("importAll")) {
            this.updateFinancialTransactions();
        }
    }
}

