/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransaction;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaContext;
import org.chorem.lima.business.api.FinancialTransactionService;
import org.chorem.lima.entity.Account;
import org.chorem.lima.entity.Entry;
import org.chorem.lima.entity.FinancialTransaction;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionViewHandler;
import org.nuiton.i18n.I18n;
import org.nuiton.util.decorator.Decorator;
import org.nuiton.util.decorator.DecoratorProvider;

public class FinancialTransactionTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -7495388454688562991L;
    private static final Log log = LogFactory.getLog(FinancialTransactionViewHandler.class);
    protected FinancialTransactionService financialTransactionService = (FinancialTransactionService)LimaServiceFactory.getService(FinancialTransactionService.class);
    protected List<Object> transactionAndEntries;
    protected final Decorator<Account> accountDecorator;

    public FinancialTransactionTableModel() {
        DecoratorProvider decoratorProvider = LimaContext.get().getDecoratorProvider();
        this.accountDecorator = decoratorProvider.getDecoratorByType(Account.class);
    }

    public void setTransactionAndEntries(List<Object> transactionAndEntries) {
        this.transactionAndEntries = transactionAndEntries;
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        Class result = null;
        switch (column) {
            case 0: {
                result = Date.class;
                break;
            }
            case 1: {
                result = String.class;
                break;
            }
            case 2: {
                result = Account.class;
                break;
            }
            case 3: {
                result = String.class;
                break;
            }
            case 4: {
                result = BigDecimal.class;
                break;
            }
            case 5: {
                result = BigDecimal.class;
                break;
            }
            case 6: {
                result = BigDecimal.class;
            }
        }
        return result;
    }

    @Override
    public String getColumnName(int column) {
        String result = "n/a";
        switch (column) {
            case 0: {
                result = I18n._((String)"lima.ui.financialtransaction.date", (Object[])new Object[0]);
                break;
            }
            case 1: {
                result = I18n._((String)"lima.ui.financialtransaction.voucher", (Object[])new Object[0]);
                break;
            }
            case 2: {
                result = I18n._((String)"lima.ui.financialtransaction.account", (Object[])new Object[0]);
                break;
            }
            case 3: {
                result = I18n._((String)"lima.ui.financialtransaction.description", (Object[])new Object[0]);
                break;
            }
            case 4: {
                result = I18n._((String)"lima.ui.financialtransaction.debit", (Object[])new Object[0]);
                break;
            }
            case 5: {
                result = I18n._((String)"lima.ui.financialtransaction.credit", (Object[])new Object[0]);
                break;
            }
            case 6: {
                result = I18n._((String)"lima.ui.financialtransaction.balance", (Object[])new Object[0]);
            }
        }
        return result;
    }

    @Override
    public int getRowCount() {
        int result = 0;
        if (this.transactionAndEntries != null) {
            result = this.transactionAndEntries.size();
        }
        return result;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object result = this.transactionAndEntries.get(row);
        if (result instanceof FinancialTransaction) {
            FinancialTransaction currentRow = (FinancialTransaction)result;
            BigDecimal amountDebit = currentRow.getAmountDebit();
            BigDecimal amountCredit = currentRow.getAmountCredit();
            switch (column) {
                case 0: {
                    result = currentRow.getTransactionDate();
                    break;
                }
                case 1: {
                    result = null;
                    break;
                }
                case 2: {
                    result = null;
                    break;
                }
                case 3: {
                    result = null;
                    break;
                }
                case 4: {
                    result = amountDebit;
                    break;
                }
                case 5: {
                    result = amountCredit;
                    break;
                }
                case 6: {
                    result = amountDebit.subtract(amountCredit);
                }
            }
        } else if (result instanceof Entry) {
            Entry currentEntry = (Entry)result;
            switch (column) {
                case 0: {
                    result = null;
                    break;
                }
                case 1: {
                    result = currentEntry.getVoucher();
                    break;
                }
                case 2: {
                    if (currentEntry.getAccount() == null) {
                        result = null;
                        break;
                    }
                    Account acc = currentEntry.getAccount();
                    result = this.accountDecorator.toString((Object)acc);
                    break;
                }
                case 3: {
                    result = currentEntry.getDescription();
                    break;
                }
                case 4: {
                    result = currentEntry.getDebit() ? currentEntry.getAmount() : BigDecimal.ZERO;
                    break;
                }
                case 5: {
                    result = currentEntry.getDebit() ? BigDecimal.ZERO : currentEntry.getAmount();
                    break;
                }
                case 6: {
                    result = null;
                }
            }
        }
        return result;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        boolean editableCell = false;
        Object currentRow = this.transactionAndEntries.get(rowIndex);
        if (currentRow instanceof FinancialTransaction && columnIndex == 0) {
            editableCell = true;
        }
        if (currentRow instanceof Entry && columnIndex != 0 && columnIndex != 6) {
            editableCell = true;
        }
        return editableCell;
    }

    public int getFirstEntry(int selectedRow) {
        int result = -1;
        int currentRow = selectedRow;
        while (currentRow > -1) {
            Object o = this.transactionAndEntries.get(currentRow);
            if (o instanceof Entry) {
                --currentRow;
                continue;
            }
            if (!(o instanceof FinancialTransaction)) continue;
            if (currentRow == selectedRow) {
                result = -1;
                break;
            }
            result = currentRow + 1;
            break;
        }
        return result;
    }

    public Object getObjectAt(int row) {
        if (row == -1) {
            return null;
        }
        return this.transactionAndEntries.get(row);
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        Object currentRow = this.transactionAndEntries.get(row);
        if (currentRow instanceof FinancialTransaction) {
            FinancialTransaction currentFinancialTransaction = (FinancialTransaction)currentRow;
            switch (column) {
                case 0: {
                    currentFinancialTransaction.setTransactionDate((Date)value);
                }
            }
            this.financialTransactionService.updateFinancialTransaction(currentFinancialTransaction);
        } else if (currentRow instanceof Entry && !value.equals(BigDecimal.ZERO) && !value.equals(new BigDecimal("0.00"))) {
            int trIndex;
            Entry currentEntry = (Entry)currentRow;
            FinancialTransaction currentFinancialTransaction = currentEntry.getFinancialTransaction();
            boolean updateTransaction = false;
            switch (column) {
                case 1: {
                    String voucher = ((String)value).trim();
                    int firstEntryRow = this.getFirstEntry(row);
                    if (row == firstEntryRow) {
                        for (Entry entry : currentFinancialTransaction.getEntry()) {
                            entry.setVoucher(voucher);
                        }
                        updateTransaction = true;
                        break;
                    }
                    currentEntry.setVoucher(voucher);
                    break;
                }
                case 2: {
                    Account account = (Account)value;
                    currentEntry.setAccount(account);
                    String description1 = account.getLabel();
                    int firstEntryRow = this.getFirstEntry(row);
                    if (row == firstEntryRow) {
                        for (Entry entry : currentFinancialTransaction.getEntry()) {
                            entry.setDescription(description1);
                        }
                        updateTransaction = true;
                        break;
                    }
                    currentEntry.setDescription(description1);
                    break;
                }
                case 3: {
                    String description = ((String)value).trim();
                    int firstEntryRow = this.getFirstEntry(row);
                    if (row == firstEntryRow) {
                        for (Entry entry : currentFinancialTransaction.getEntry()) {
                            entry.setDescription(description);
                        }
                        updateTransaction = true;
                        break;
                    }
                    currentEntry.setDescription(description);
                    break;
                }
                case 4: {
                    currentEntry.setAmount((BigDecimal)value);
                    currentEntry.setDebit(true);
                    break;
                }
                case 5: {
                    currentEntry.setAmount((BigDecimal)value);
                    currentEntry.setDebit(false);
                }
            }
            if (updateTransaction) {
                for (Entry entry : currentFinancialTransaction.getEntry()) {
                    this.financialTransactionService.updateEntry(entry);
                }
            } else {
                this.financialTransactionService.updateEntry(currentEntry);
            }
            int endIndex = trIndex = this.indexOf(currentFinancialTransaction);
            if (currentFinancialTransaction.getEntry() != null) {
                endIndex += currentFinancialTransaction.getEntry().size();
            }
            this.fireTableRowsUpdated(trIndex, endIndex);
        }
    }

    public Object getElementAt(int row) {
        Object result = this.transactionAndEntries.get(row);
        return result;
    }

    public int indexOf(Object o) {
        return this.transactionAndEntries.indexOf(o);
    }

    public void deleteRow(int row) {
        this.transactionAndEntries.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    public void addRow(Object object, int newRow) {
        this.transactionAndEntries.add(newRow, object);
        this.fireTableRowsInserted(newRow, newRow);
    }

    public void addRow(Object object) {
        this.transactionAndEntries.add(object);
        this.fireTableRowsInserted(this.transactionAndEntries.size() - 1, this.transactionAndEntries.size() - 1);
    }
}

