/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransaction;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.util.Collection;
import java.util.Date;
import javax.swing.SwingWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.Account;
import org.chorem.lima.entity.Entry;
import org.chorem.lima.entity.FinancialTransaction;
import org.chorem.lima.ui.celleditor.AccountTableCellEditor;
import org.chorem.lima.ui.celleditor.BigDecimalTableCellEditor;
import org.chorem.lima.ui.celleditor.BigDecimalTableCellRenderer;
import org.chorem.lima.ui.celleditor.DateTableCellEditor;
import org.chorem.lima.ui.celleditor.EmptyCellRenderer;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionViewHandler;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;

public class FinancialTransactionTable
extends JXTable {
    private static final long serialVersionUID = 3133690382049594727L;
    private static final Log log = LogFactory.getLog(FinancialTransactionTable.class);
    protected FinancialTransactionViewHandler handler;
    private int x_tab;
    private int y_tab;

    public FinancialTransactionTable(FinancialTransactionViewHandler handler) {
        this.handler = handler;
        this.addKeyListener(new MyKeyAdapter());
        this.addMouseListener(new MyMouseAdapter());
        this.setDefaultEditor(Date.class, new DateTableCellEditor());
        this.setDefaultEditor(Account.class, new AccountTableCellEditor());
        this.setDefaultEditor(BigDecimal.class, new BigDecimalTableCellEditor());
        this.setDefaultRenderer(BigDecimal.class, new BigDecimalTableCellRenderer());
        this.setDefaultRenderer(String.class, new EmptyCellRenderer());
        this.setDefaultRenderer(Account.class, new EmptyCellRenderer());
        Object predicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                return adapter.getValueAt(adapter.row, 0) instanceof Date;
            }
        };
        ColorHighlighter colorTransaction = new ColorHighlighter(predicate, new Color(222, 222, 222), null);
        this.addHighlighter((Highlighter)colorTransaction);
        predicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                boolean isHighlighted = false;
                Object valueDebit = adapter.getValueAt(adapter.row, 4);
                Object valueCredit = adapter.getValueAt(adapter.row, 5);
                Object value = adapter.getValueAt(adapter.row, 6);
                if (value instanceof BigDecimal) {
                    BigDecimal currentBalance = (BigDecimal)value;
                    DecimalFormat decimalFormat = new DecimalFormat();
                    Double currentBalanceDouble = decimalFormat.parse(currentBalance.toString(), new ParsePosition(0)).doubleValue();
                    Double debitDouble = decimalFormat.parse(valueDebit.toString(), new ParsePosition(0)).doubleValue();
                    Double creditDouble = decimalFormat.parse(valueCredit.toString(), new ParsePosition(0)).doubleValue();
                    if (!currentBalanceDouble.toString().equals("0.0") || (valueDebit.equals(BigDecimal.ZERO) || debitDouble.toString().equals("0.0")) && (valueCredit.equals(BigDecimal.ZERO) || creditDouble.toString().equals("0.0"))) {
                        isHighlighted = true;
                    }
                }
                return isHighlighted;
            }
        };
        colorTransaction = new ColorHighlighter(predicate, new Color(255, 0, 0), null);
        this.addHighlighter((Highlighter)colorTransaction);
        HighlightPredicate debitCreditZero = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                Object valueDebit = adapter.getValueAt(adapter.row, 4);
                Object valueCredit = adapter.getValueAt(adapter.row, 5);
                boolean isEntry = !(adapter.getValueAt(adapter.row, 0) instanceof Date);
                DecimalFormat decimalFormat = new DecimalFormat();
                Double debitDouble = decimalFormat.parse(valueDebit.toString(), new ParsePosition(0)).doubleValue();
                Double creditDouble = decimalFormat.parse(valueCredit.toString(), new ParsePosition(0)).doubleValue();
                return !(!isEntry || !valueDebit.equals(BigDecimal.ZERO) && !debitDouble.toString().equals("0.0") || !valueCredit.equals(BigDecimal.ZERO) && !creditDouble.toString().equals("0.0"));
            }
        };
        ColorHighlighter entryDebitCreditZero = new ColorHighlighter(debitCreditZero, new Color(255, 198, 209), null);
        this.addHighlighter((Highlighter)entryDebitCreditZero);
    }

    public FinancialTransactionViewHandler getHandler() {
        return this.handler;
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        private MyMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (FinancialTransactionTable.this.rowAtPoint(e.getPoint()) == -1) {
                FinancialTransactionTable.this.clearSelection();
            }
        }
    }

    private class MyKeyAdapter
    extends KeyAdapter {
        FinancialTransactionTable table;

        private MyKeyAdapter() {
            this.table = FinancialTransactionTable.this;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            final FinancialTransactionViewHandler handler = FinancialTransactionTable.this.getHandler();
            if (e.getKeyCode() == 10) {
                int selectedRow = this.table.getSelectedRow();
                if (selectedRow == this.table.getRowCount() - 1) {
                    this.table.setRowSelectionInterval(this.table.getRowCount() - 2, this.table.getRowCount() - 2);
                } else {
                    this.table.setRowSelectionInterval(selectedRow, selectedRow);
                }
            }
            if (e.getKeyCode() == 127 || e.getKeyCode() == 12 && e.getModifiers() == 2) {
                handler.deleteSelectedRow();
            }
            if (e.getKeyCode() == 155 || e.getKeyCode() == 10 && e.getModifiers() == 2) {
                handler.addEntry();
            }
            if (e.getKeyCode() == 67 && e.getModifiers() == 2) {
                handler.copyRow(FinancialTransactionTable.this.getSelectedRow());
            }
            if (e.getKeyCode() == 86 && e.getModifiers() == 2) {
                handler.pasteRow(FinancialTransactionTable.this.getSelectedRow());
            }
            if (e.getKeyCode() == 9 && e.getModifiers() == 2) {
                handler.addFinancialTransaction();
            }
            if (e.getKeyCode() == 27 && !FinancialTransactionTable.this.isEditing()) {
                FinancialTransactionTable.this.clearSelection();
            }
            if (e.getKeyChar() == '\t') {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Key tab used");
                }
                int max_x = FinancialTransactionTable.this.getColumnCount();
                int max_y = FinancialTransactionTable.this.getRowCount();
                FinancialTransactionTable.this.x_tab = FinancialTransactionTable.this.getSelectedColumn();
                FinancialTransactionTable.this.y_tab = FinancialTransactionTable.this.getSelectedRow();
                Boolean end = true;
                if (FinancialTransactionTable.this.x_tab < max_x - 1) {
                    FinancialTransactionTable.this.x_tab++;
                } else {
                    FinancialTransactionTable.this.x_tab = 0;
                }
                while (!FinancialTransactionTable.this.isCellEditable(FinancialTransactionTable.this.y_tab, FinancialTransactionTable.this.x_tab) && end.booleanValue()) {
                    if (FinancialTransactionTable.this.x_tab == max_x - 1) {
                        Object object = handler.view.getFinancialTransactionTableModel().getElementAt(FinancialTransactionTable.this.y_tab);
                        if (object instanceof FinancialTransaction) {
                            FinancialTransaction financialTransaction = (FinancialTransaction)object;
                            if (CollectionUtils.isEmpty((Collection)financialTransaction.getEntry())) {
                                handler.addEntry();
                                FinancialTransactionTable.this.setColumnSelectionInterval(0, 0);
                            }
                        } else {
                            final int y_t = FinancialTransactionTable.this.y_tab;
                            final int m_t = max_y;
                            new SwingWorker<Void, Void>(){

                                @Override
                                protected Void doInBackground() throws InterruptedException {
                                    Thread.sleep(500L);
                                    return null;
                                }

                                @Override
                                protected void done() {
                                    Object object = handler.view.getFinancialTransactionTableModel().getElementAt(FinancialTransactionTable.this.y_tab - 1);
                                    FinancialTransaction financialTransaction = null;
                                    if (object instanceof Entry) {
                                        financialTransaction = ((Entry)object).getFinancialTransaction();
                                    } else if (object instanceof FinancialTransaction) {
                                        financialTransaction = (FinancialTransaction)object;
                                    }
                                    BigDecimal amountC = financialTransaction.getAmountCredit();
                                    BigDecimal amountD = financialTransaction.getAmountDebit();
                                    if (amountC.equals(amountD)) {
                                        if (y_t == m_t - 1) {
                                            handler.addFinancialTransaction();
                                            FinancialTransactionTable.this.setColumnSelectionInterval(0, 0);
                                        }
                                    } else {
                                        handler.addEntry();
                                        FinancialTransactionTable.this.setColumnSelectionInterval(0, 0);
                                        FinancialTransactionTable.this.y_tab++;
                                        FinancialTransactionTable.this.setRowSelectionInterval(FinancialTransactionTable.this.y_tab, FinancialTransactionTable.this.y_tab);
                                        FinancialTransactionTable.this.x_tab = 0;
                                    }
                                }
                            }.execute();
                        }
                        end = false;
                        continue;
                    }
                    if (FinancialTransactionTable.this.x_tab >= max_x) continue;
                    FinancialTransactionTable.this.setRowSelectionInterval(FinancialTransactionTable.this.y_tab, FinancialTransactionTable.this.y_tab);
                    FinancialTransactionTable.this.setColumnSelectionInterval(FinancialTransactionTable.this.x_tab, FinancialTransactionTable.this.x_tab);
                    FinancialTransactionTable.this.x_tab++;
                }
            }
        }
    }
}

