/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialperiod;

import java.text.SimpleDateFormat;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.chorem.lima.entity.ClosedPeriodicEntryBook;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.entity.FinancialPeriod;
import org.nuiton.i18n.I18n;

public class FinancialPeriodTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 77027335135838258L;
    protected List<ClosedPeriodicEntryBook> closedPeriodicEntryBooks;

    public void setClosedPeriodicEntryBooks(List<ClosedPeriodicEntryBook> closedPeriodicEntryBooks) {
        this.closedPeriodicEntryBooks = closedPeriodicEntryBooks;
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        int result = 0;
        if (this.closedPeriodicEntryBooks != null) {
            result = this.closedPeriodicEntryBooks.size();
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int columnIndex) {
        String result = "n/a";
        switch (columnIndex) {
            case 0: {
                result = I18n._((String)"lima.ui.financialperiod.period", (Object[])new Object[0]);
                break;
            }
            case 1: {
                result = I18n._((String)"lima.ui.financialperiod.entrybook", (Object[])new Object[0]);
                break;
            }
            case 2: {
                result = I18n._((String)"lima.ui.financialperiod.closure", (Object[])new Object[0]);
            }
        }
        return result;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public ClosedPeriodicEntryBook getElementAt(int row) {
        ClosedPeriodicEntryBook currentRow = this.closedPeriodicEntryBooks.get(row);
        return currentRow;
    }

    public void setElementAt(int row, ClosedPeriodicEntryBook closedPeriodicEntryBook) {
        this.closedPeriodicEntryBooks.set(row, closedPeriodicEntryBook);
        this.fireTableRowsUpdated(row, row);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String result = null;
        ClosedPeriodicEntryBook closedPeriodicEntryBook = this.getElementAt(rowIndex);
        switch (columnIndex) {
            case 0: {
                SimpleDateFormat df = new SimpleDateFormat("dd MMM yyyy");
                FinancialPeriod financialPeriod = closedPeriodicEntryBook.getFinancialPeriod();
                result = df.format(financialPeriod.getBeginDate()) + " - " + df.format(financialPeriod.getEndDate());
                break;
            }
            case 1: {
                EntryBook entryBook = closedPeriodicEntryBook.getEntryBook();
                result = entryBook.getCode() + " - " + entryBook.getLabel();
                break;
            }
            case 2: {
                result = closedPeriodicEntryBook.getLocked() ? I18n._((String)"lima.common.closed", (Object[])new Object[0]) : I18n._((String)"lima.common.open", (Object[])new Object[0]);
            }
        }
        return result;
    }
}

