/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.celleditor;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.Account;
import org.chorem.lima.ui.combobox.LeafAccountComboBoxModel;
import org.chorem.lima.ui.common.AccountListRenderer;
import org.chorem.lima.util.AccountToString;
import org.chorem.lima.widgets.JWideComboBox;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;

public class AccountTableCellEditor
extends AbstractCellEditor
implements TableCellEditor,
KeyListener {
    protected static final Log log = LogFactory.getLog(AccountTableCellEditor.class);
    private final JWideComboBox comboBox = new JWideComboBox();
    private static final long serialVersionUID = 1L;
    private static boolean keyPressed;

    public AccountTableCellEditor() {
        LeafAccountComboBoxModel accountComboBoxModel = new LeafAccountComboBoxModel();
        this.comboBox.setModel(accountComboBoxModel);
        AccountListRenderer accountRenderer = new AccountListRenderer();
        this.comboBox.setRenderer(accountRenderer);
        AutoCompleteDecorator.decorate((JComboBox)this.comboBox, (ObjectToStringConverter)AccountToString.getInstance());
        this.comboBox.getEditor().getEditorComponent().addKeyListener(this);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof Account) {
            this.comboBox.setSelectedItem(value);
        }
        return this.comboBox;
    }

    @Override
    public Object getCellEditorValue() {
        return this.comboBox.getSelectedItem();
    }

    @Override
    public boolean isCellEditable(EventObject evt) {
        KeyEvent keyEvent;
        if (evt instanceof KeyEvent && (keyEvent = (KeyEvent)evt).getKeyChar() != '\u001b') {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AccountTableCellEditor.this.comboBox.getEditor().getEditorComponent().requestFocus();
                    JTextComponent edit = (JTextComponent)AccountTableCellEditor.this.comboBox.getEditor().getEditorComponent();
                    if (!Character.isIdentifierIgnorable(keyEvent.getKeyChar())) {
                        edit.setText(Character.toString(keyEvent.getKeyChar()));
                    }
                }
            });
        }
        keyPressed = false;
        return !(evt instanceof MouseEvent) || ((MouseEvent)evt).getClickCount() == 2;
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (!keyPressed) {
            JTextComponent edit = (JTextComponent)this.comboBox.getEditor().getEditorComponent();
            edit.select(1, edit.getText().length());
            keyPressed = true;
        }
        if (e.getKeyChar() == '\n') {
            this.fireEditingStopped();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

