/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.lettering;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.FinancialTransactionServiceMonitorable;
import org.chorem.lima.business.ImportServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.utils.EntryComparator;
import org.chorem.lima.entity.Account;
import org.chorem.lima.entity.Entry;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.entity.FinancialTransaction;
import org.chorem.lima.entity.Letter;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.util.DialogHelper;
import org.chorem.lima.util.ErrorHelper;
import org.nuiton.i18n.I18n;
import org.nuiton.util.Resource;

public class LetteringTableModel
extends AbstractTableModel
implements ServiceListener {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(LetteringTableModel.class);
    protected final FinancialTransactionServiceMonitorable financialTransactionService = LimaServiceFactory.getInstance().getService(FinancialTransactionServiceMonitorable.class);
    protected Date selectedBeginDate;
    protected Date selectedEndDate;
    protected List<Object> cacheDataList;

    public LetteringTableModel() {
        this.financialTransactionService.addListener((ServiceListener)this);
        LimaServiceFactory.getInstance().getService(ImportServiceMonitorable.class).addListener((ServiceListener)this);
    }

    public void setSelectedBeginDate(Date date) {
        this.selectedBeginDate = date;
    }

    public void setSelectedEndDate(Date date) {
        this.selectedEndDate = date;
    }

    protected List<Object> getDataList() {
        ArrayList<Object> results = new ArrayList<Object>();
        if (this.selectedBeginDate != null && this.selectedEndDate != null) {
            try {
                List financialtransactions = this.financialTransactionService.getAllFinancialTransactionsFromDateToDate(this.selectedBeginDate, this.selectedEndDate);
                for (FinancialTransaction financialtransaction : financialtransactions) {
                    results.add(financialtransaction);
                    List entries = (List)financialtransaction.getEntry();
                    Collections.sort(entries, new EntryComparator());
                    results.addAll(entries);
                }
            }
            catch (LimaException eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't update model", (Throwable)eee);
                }
                ErrorHelper.showErrorDialog(I18n._((String)"lima.lettering.listerror", (Object[])new Object[0]), eee);
            }
        }
        return results;
    }

    public void setLetter(int row, Letter letter) {
        Object currentRow = this.cacheDataList.get(row);
        if (currentRow instanceof Entry) {
            Entry entry = (Entry)currentRow;
            entry.setLetter(letter);
            try {
                this.financialTransactionService.updateEntry(entry);
            }
            catch (LimaException eee) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Can't set letter", (Throwable)eee);
                }
                JFrame f = new JFrame();
                f.setIconImage(Resource.getIcon((String)"icons/lima.png").getImage());
                JOptionPane.showMessageDialog(f, eee.getMessage(), I18n._((String)"lima.common.error", (Object[])new Object[0]), 0);
                f.dispose();
            }
        }
    }

    public void removeLetter(int row) {
        try {
            Object currentRow = this.cacheDataList.get(row);
            if (currentRow instanceof Entry) {
                Entry entry = (Entry)currentRow;
                this.financialTransactionService.removeEntryLetter(entry);
            }
        }
        catch (LimaException eee) {
            log.error((Object)"Can't remove letter", (Throwable)eee);
        }
    }

    public void refresh() {
        this.cacheDataList = this.getDataList();
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 9;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        Class result = null;
        switch (column) {
            case 0: {
                result = Date.class;
                break;
            }
            case 1: {
                result = EntryBook.class;
                break;
            }
            case 2: {
                result = String.class;
                break;
            }
            case 3: {
                result = Account.class;
                break;
            }
            case 4: {
                result = String.class;
                break;
            }
            case 5: {
                result = Letter.class;
                break;
            }
            case 6: {
                result = BigDecimal.class;
                break;
            }
            case 7: {
                result = BigDecimal.class;
                break;
            }
            case 8: {
                result = BigDecimal.class;
            }
        }
        return result;
    }

    @Override
    public String getColumnName(int column) {
        String result = "n/a";
        switch (column) {
            case 0: {
                result = I18n._((String)"lima.table.date", (Object[])new Object[0]);
                break;
            }
            case 1: {
                result = I18n._((String)"lima.table.entrybook", (Object[])new Object[0]);
                break;
            }
            case 2: {
                result = I18n._((String)"lima.table.voucher", (Object[])new Object[0]);
                break;
            }
            case 3: {
                result = I18n._((String)"lima.table.account", (Object[])new Object[0]);
                break;
            }
            case 4: {
                result = I18n._((String)"lima.table.description", (Object[])new Object[0]);
                break;
            }
            case 5: {
                result = I18n._((String)"lima.table.letter", (Object[])new Object[0]);
                break;
            }
            case 6: {
                result = I18n._((String)"lima.table.debit", (Object[])new Object[0]);
                break;
            }
            case 7: {
                result = I18n._((String)"lima.table.credit", (Object[])new Object[0]);
                break;
            }
            case 8: {
                result = I18n._((String)"lima.table.balance", (Object[])new Object[0]);
            }
        }
        return result;
    }

    @Override
    public int getRowCount() {
        int result = 0;
        if (this.cacheDataList != null) {
            result = this.cacheDataList.size();
        }
        return result;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object result = null;
        if (this.cacheDataList != null) {
            result = this.cacheDataList.get(row);
            if (result instanceof FinancialTransaction) {
                FinancialTransaction currentRow = (FinancialTransaction)result;
                BigDecimal amountDebit = currentRow.getAmountDebit();
                BigDecimal amountCredit = currentRow.getAmountCredit();
                switch (column) {
                    case 0: {
                        result = currentRow.getTransactionDate();
                        break;
                    }
                    case 1: {
                        if (currentRow.getEntryBook() != null) {
                            result = currentRow.getEntryBook().getCode();
                            break;
                        }
                        result = null;
                        break;
                    }
                    case 2: {
                        result = null;
                        break;
                    }
                    case 3: {
                        result = null;
                        break;
                    }
                    case 4: {
                        result = null;
                        break;
                    }
                    case 5: {
                        result = null;
                        break;
                    }
                    case 6: {
                        result = amountDebit;
                        break;
                    }
                    case 7: {
                        result = amountCredit;
                        break;
                    }
                    case 8: {
                        result = amountDebit.subtract(amountCredit);
                    }
                }
            } else if (result instanceof Entry) {
                Entry currentEntry = (Entry)result;
                switch (column) {
                    case 0: {
                        result = null;
                        break;
                    }
                    case 1: {
                        result = null;
                        break;
                    }
                    case 2: {
                        result = currentEntry.getVoucher();
                        break;
                    }
                    case 3: {
                        if (currentEntry.getAccount() != null) {
                            result = currentEntry.getAccount().getAccountNumber();
                            break;
                        }
                        result = null;
                        break;
                    }
                    case 4: {
                        result = currentEntry.getDescription();
                        break;
                    }
                    case 5: {
                        if (currentEntry.getLetter() != null) {
                            result = currentEntry.getLetter().getCode();
                            break;
                        }
                        result = null;
                        break;
                    }
                    case 6: {
                        result = currentEntry.getDebit() ? currentEntry.getAmount() : BigDecimal.ZERO;
                        break;
                    }
                    case 7: {
                        result = currentEntry.getDebit() ? BigDecimal.ZERO : currentEntry.getAmount();
                        break;
                    }
                    case 8: {
                        result = null;
                    }
                }
            }
        }
        return result;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        boolean editableCell = false;
        Object currentRow = this.cacheDataList.get(rowIndex);
        if (currentRow instanceof Entry && columnIndex == 5) {
            editableCell = true;
        }
        return editableCell;
    }

    public Object getElementAt(int row) {
        Object result = null;
        if (this.cacheDataList != null) {
            result = this.cacheDataList.get(row);
        }
        return result;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        int financialTransactionRow = 0;
        if (this.cacheDataList != null) {
            Object currentRow = this.cacheDataList.get(row);
            if (currentRow instanceof Entry) {
                Entry currentEntry = (Entry)currentRow;
                switch (column) {
                    case 5: {
                        currentEntry.setLetter((Letter)value);
                    }
                }
                try {
                    this.financialTransactionService.updateEntry(currentEntry);
                }
                catch (LimaException eee) {
                    if (log.isDebugEnabled()) {
                        log.error((Object)"Can't update entry", (Throwable)eee);
                    }
                    DialogHelper.showMessageDialog(eee.getMessage());
                }
                financialTransactionRow = this.getDataList().indexOf(((Entry)currentRow).getFinancialTransaction());
            }
            this.cacheDataList = this.getDataList();
            this.fireTableRowsUpdated(financialTransactionRow, this.getRowCount() - 1);
        }
    }

    public void notifyMethod(String serviceName, String methodeName) {
        if (serviceName.contains("FinancialTransaction") || methodeName.contains("importEntries") || methodeName.contains("importAll")) {
            this.refresh();
        }
    }
}

