/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransactionsearch;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.Letter;
import org.chorem.lima.ui.combobox.LetterComboBoxModel;
import org.chorem.lima.ui.combobox.LetterRenderer;
import org.chorem.lima.ui.financialtransactionsearch.FinancialTransactionSearchViewHandler;
import org.chorem.lima.util.LetterToString;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;

public class LetterSearchComboBox
extends JComboBox
implements KeyListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(LetterSearchComboBox.class);
    protected FinancialTransactionSearchViewHandler handler;

    public LetterSearchComboBox(FinancialTransactionSearchViewHandler handler) {
        this.handler = handler;
        LetterComboBoxModel letterComboBoxModel = new LetterComboBoxModel();
        LetterRenderer letterRenderer = new LetterRenderer();
        this.setModel(letterComboBoxModel);
        this.setRenderer(letterRenderer);
        this.setEditable(true);
        AutoCompleteDecorator.decorate((JComboBox)this, (ObjectToStringConverter)LetterToString.getInstance());
        this.getEditor().getEditorComponent().addKeyListener(this);
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object object = this.getSelectedItem();
        if (object instanceof Letter) {
            this.handler.setLetter((Letter)this.getSelectedItem());
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        Object object = this.getSelectedItem();
        if (object instanceof Letter) {
            this.handler.setLetter((Letter)this.getSelectedItem());
        }
        if (e.getKeyChar() == '\n') {
            this.firePopupMenuCanceled();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

