/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransactionsearch;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.beans.FinancialTransactionSearch;
import org.chorem.lima.business.FinancialPeriodServiceMonitorable;
import org.chorem.lima.business.FinancialTransactionServiceMonitorable;
import org.chorem.lima.business.LimaBusinessException;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.entity.Account;
import org.chorem.lima.entity.Entry;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.entity.EntryImpl;
import org.chorem.lima.entity.FinancialPeriod;
import org.chorem.lima.entity.FinancialTransaction;
import org.chorem.lima.entity.FinancialTransactionImpl;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.entity.Letter;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.util.DialogHelper;
import org.chorem.lima.util.ErrorHelper;
import org.nuiton.i18n.I18n;

public class FinancialTransactionSearchTableModel
extends AbstractTableModel
implements ServiceListener {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(FinancialTransactionSearchTableModel.class);
    protected final FinancialTransactionServiceMonitorable financialTransactionService = LimaServiceFactory.getInstance().getService(FinancialTransactionServiceMonitorable.class);
    protected final FinancialPeriodServiceMonitorable financialPeriodService;
    protected FiscalPeriod selectedFiscalPeriod;
    protected FinancialTransactionSearch financialTransactionSearch;
    protected List<Object> cacheDataList;

    public FinancialTransactionSearchTableModel() {
        this.financialTransactionService.addListener((ServiceListener)this);
        this.financialPeriodService = LimaServiceFactory.getInstance().getService(FinancialPeriodServiceMonitorable.class);
    }

    protected List<Object> getDataList(FinancialTransactionSearch financialTransactionSearch) {
        List results = null;
        if (financialTransactionSearch != null && (financialTransactionSearch.getVoucher() != null || financialTransactionSearch.getDescription() != null || financialTransactionSearch.getLetter() != null || financialTransactionSearch.getAccountList() != null || financialTransactionSearch.getAccount() != null || financialTransactionSearch.getEntryBook() != null || financialTransactionSearch.getAmount() != null && financialTransactionSearch.getOperator() != null || financialTransactionSearch.getAmount() != null && financialTransactionSearch.getAmount2() != null)) {
            try {
                results = this.financialTransactionService.searchFinancialTransaction(financialTransactionSearch);
            }
            catch (LimaException eee) {
                if (log.isErrorEnabled()) {
                    log.debug((Object)"Can't update model", (Throwable)eee);
                }
                ErrorHelper.showErrorDialog("Can't get transaction list", eee);
            }
        }
        return results;
    }

    protected void refresh(FinancialTransactionSearch financialTransactionSearch) {
        this.financialTransactionSearch = financialTransactionSearch;
        this.cacheDataList = this.getDataList(financialTransactionSearch);
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 9;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        Class result = null;
        switch (column) {
            case 0: {
                result = Date.class;
                break;
            }
            case 1: {
                result = EntryBook.class;
                break;
            }
            case 2: {
                result = String.class;
                break;
            }
            case 3: {
                result = Account.class;
                break;
            }
            case 4: {
                result = String.class;
                break;
            }
            case 5: {
                result = Letter.class;
                break;
            }
            case 6: {
                result = BigDecimal.class;
                break;
            }
            case 7: {
                result = BigDecimal.class;
                break;
            }
            case 8: {
                result = BigDecimal.class;
            }
        }
        return result;
    }

    @Override
    public String getColumnName(int column) {
        String result = "n/a";
        switch (column) {
            case 0: {
                result = I18n._((String)"lima.table.date", (Object[])new Object[0]);
                break;
            }
            case 1: {
                result = I18n._((String)"lima.table.entrybook", (Object[])new Object[0]);
                break;
            }
            case 2: {
                result = I18n._((String)"lima.table.voucher", (Object[])new Object[0]);
                break;
            }
            case 3: {
                result = I18n._((String)"lima.table.account", (Object[])new Object[0]);
                break;
            }
            case 4: {
                result = I18n._((String)"lima.table.description", (Object[])new Object[0]);
                break;
            }
            case 5: {
                result = I18n._((String)"lima.table.letter", (Object[])new Object[0]);
                break;
            }
            case 6: {
                result = I18n._((String)"lima.table.debit", (Object[])new Object[0]);
                break;
            }
            case 7: {
                result = I18n._((String)"lima.table.credit", (Object[])new Object[0]);
                break;
            }
            case 8: {
                result = I18n._((String)"lima.table.balance", (Object[])new Object[0]);
            }
        }
        return result;
    }

    @Override
    public int getRowCount() {
        int result = 0;
        if (this.cacheDataList != null) {
            result = this.cacheDataList.size();
        }
        return result;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object result = null;
        if (this.cacheDataList != null) {
            result = this.cacheDataList.get(row);
            if (result instanceof FinancialTransaction) {
                FinancialTransaction currentRow = (FinancialTransaction)result;
                BigDecimal amountDebit = currentRow.getAmountDebit();
                BigDecimal amountCredit = currentRow.getAmountCredit();
                switch (column) {
                    case 0: {
                        result = currentRow.getTransactionDate();
                        break;
                    }
                    case 1: {
                        if (currentRow.getEntryBook() != null) {
                            result = currentRow.getEntryBook().getCode();
                            break;
                        }
                        result = null;
                        break;
                    }
                    case 2: {
                        result = null;
                        break;
                    }
                    case 3: {
                        result = null;
                        break;
                    }
                    case 4: {
                        result = null;
                        break;
                    }
                    case 5: {
                        result = null;
                        break;
                    }
                    case 6: {
                        result = amountDebit;
                        break;
                    }
                    case 7: {
                        result = amountCredit;
                        break;
                    }
                    case 8: {
                        result = amountDebit.subtract(amountCredit);
                    }
                }
            } else if (result instanceof Entry) {
                Entry currentEntry = (Entry)result;
                switch (column) {
                    case 0: {
                        result = null;
                        break;
                    }
                    case 1: {
                        result = null;
                        break;
                    }
                    case 2: {
                        result = currentEntry.getVoucher();
                        break;
                    }
                    case 3: {
                        if (currentEntry.getAccount() != null) {
                            result = currentEntry.getAccount().getAccountNumber();
                            break;
                        }
                        result = null;
                        break;
                    }
                    case 4: {
                        result = currentEntry.getDescription();
                        break;
                    }
                    case 5: {
                        if (currentEntry.getLetter() != null) {
                            result = currentEntry.getLetter().getCode();
                            break;
                        }
                        result = null;
                        break;
                    }
                    case 6: {
                        result = currentEntry.getDebit() ? currentEntry.getAmount() : BigDecimal.ZERO;
                        break;
                    }
                    case 7: {
                        result = currentEntry.getDebit() ? BigDecimal.ZERO : currentEntry.getAmount();
                        break;
                    }
                    case 8: {
                        result = null;
                    }
                }
            }
        }
        return result;
    }

    public void setFiscalPeriod(FiscalPeriod fiscalPeriod) {
        this.selectedFiscalPeriod = fiscalPeriod;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        boolean editableCell = false;
        Object currentRow = this.cacheDataList.get(rowIndex);
        if (currentRow instanceof Entry && columnIndex != 0 && columnIndex != 1) {
            editableCell = true;
        }
        if (currentRow instanceof FinancialTransaction && (columnIndex == 0 || columnIndex == 1)) {
            editableCell = true;
        }
        return editableCell;
    }

    public int addFinancialTransaction() throws LimaException {
        FinancialTransactionImpl financialTransaction = new FinancialTransactionImpl();
        financialTransaction.setAmountDebit(BigDecimal.ZERO);
        financialTransaction.setAmountCredit(BigDecimal.ZERO);
        if (this.selectedFiscalPeriod != null) {
            List financialPeriodsList = this.financialPeriodService.getFinancialPeriods(this.selectedFiscalPeriod.getBeginDate(), this.selectedFiscalPeriod.getEndDate());
            FinancialPeriod financialPeriod = null;
            if (financialPeriodsList == null) {
                throw new LimaException("Can't set new transaction");
            }
            financialPeriod = (FinancialPeriod)financialPeriodsList.get(0);
            financialTransaction.setFinancialPeriod(financialPeriod);
            Calendar actualCalendar = Calendar.getInstance();
            Date transactionDate = financialPeriod.getBeginDate();
            Calendar calEnd = Calendar.getInstance();
            calEnd.setTime(financialPeriod.getEndDate());
            int dayMax = calEnd.get(5);
            Calendar calBegin = Calendar.getInstance();
            calBegin.setTime(financialPeriod.getBeginDate());
            int dayMin = calBegin.get(5);
            int toDay = actualCalendar.get(5);
            transactionDate = toDay > dayMax || toDay < dayMin ? DateUtils.setDays((Date)transactionDate, (int)dayMax) : DateUtils.setDays((Date)transactionDate, (int)toDay);
            financialTransaction.setTransactionDate(transactionDate);
            FinancialTransaction fTransaction = this.financialTransactionService.createFinancialTransaction((FinancialTransaction)financialTransaction);
            this.cacheDataList = this.getDataList(this.financialTransactionSearch);
            int row = this.cacheDataList.indexOf(fTransaction);
            this.fireTableRowsInserted(row, row);
            return row;
        }
        throw new LimaBusinessException("No financial period selected");
    }

    public int addEmptyEntry(Object value, int row) throws LimaException {
        FinancialTransaction currentTransaction = null;
        Object currentRow = this.cacheDataList.get(row);
        EntryImpl entry = new EntryImpl();
        entry.setAmount(BigDecimal.ZERO);
        if (currentRow instanceof FinancialTransaction) {
            currentTransaction = (FinancialTransaction)currentRow;
        } else if (currentRow instanceof Entry) {
            Entry currentEntry = (Entry)currentRow;
            currentTransaction = currentEntry.getFinancialTransaction();
        }
        entry.setFinancialTransaction(currentTransaction);
        Entry newEntry = this.financialTransactionService.createEntry((Entry)entry);
        this.cacheDataList = this.getDataList(this.financialTransactionSearch);
        int newrow = this.cacheDataList.indexOf(newEntry);
        this.fireTableRowsInserted(newrow, newrow);
        return newrow;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        int financialTransactionRow = 0;
        Object currentRow = this.cacheDataList.get(row);
        if (currentRow instanceof FinancialTransaction) {
            FinancialTransaction currentFinancialTransaction = (FinancialTransaction)currentRow;
            switch (column) {
                case 0: {
                    currentFinancialTransaction.setTransactionDate((Date)value);
                    break;
                }
                case 1: {
                    currentFinancialTransaction.setEntryBook((EntryBook)value);
                }
            }
            try {
                this.financialTransactionService.updateFinancialTransaction(currentFinancialTransaction);
            }
            catch (LimaException eee) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Can't update financial transaction", (Throwable)eee);
                }
                DialogHelper.showMessageDialog(eee.getMessage());
            }
            financialTransactionRow = this.cacheDataList.indexOf((FinancialTransaction)currentRow);
        } else if (currentRow instanceof Entry) {
            Entry currentEntry = (Entry)currentRow;
            switch (column) {
                case 2: {
                    currentEntry.setVoucher((String)value);
                    break;
                }
                case 3: {
                    currentEntry.setAccount((Account)value);
                    break;
                }
                case 4: {
                    currentEntry.setDescription((String)value);
                    break;
                }
                case 5: {
                    currentEntry.setAmount((BigDecimal)value);
                    currentEntry.setDebit(true);
                    break;
                }
                case 6: {
                    currentEntry.setAmount((BigDecimal)value);
                    currentEntry.setDebit(false);
                    break;
                }
                case 8: {
                    currentEntry.setLetter((Letter)value);
                }
            }
            try {
                this.financialTransactionService.updateEntry(currentEntry);
            }
            catch (LimaException eee) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Can't update entry", (Throwable)eee);
                }
                DialogHelper.showMessageDialog(eee.getMessage());
            }
            financialTransactionRow = this.cacheDataList.indexOf(((Entry)currentRow).getFinancialTransaction());
        }
        this.cacheDataList = this.getDataList(this.financialTransactionSearch);
        this.fireTableDataChanged();
    }

    public Object getElementAt(int row) {
        Object currentRow = this.cacheDataList.get(row);
        return currentRow;
    }

    public void removeObject(Object object, int row) throws LimaException {
        Object currentRow = this.cacheDataList.get(row);
        if (currentRow instanceof FinancialTransaction) {
            FinancialTransaction currentTransaction = (FinancialTransaction)currentRow;
            this.financialTransactionService.removeFinancialTransaction(currentTransaction);
        } else if (currentRow instanceof Entry) {
            Entry currentEntry = (Entry)currentRow;
            this.financialTransactionService.removeEntry(currentEntry);
        }
        this.cacheDataList = this.getDataList(this.financialTransactionSearch);
        this.fireTableDataChanged();
    }

    public int addEmptyEntry(Object value, String description, int row) throws LimaException {
        FinancialTransaction currentTransaction = null;
        Object currentRow = this.cacheDataList.get(row);
        EntryImpl entry = new EntryImpl();
        entry.setAmount(BigDecimal.ZERO);
        if (description != null) {
            entry.setDescription(description);
        }
        if (currentRow instanceof FinancialTransaction) {
            currentTransaction = (FinancialTransaction)currentRow;
        } else if (currentRow instanceof Entry) {
            Entry currentEntry = (Entry)currentRow;
            currentTransaction = currentEntry.getFinancialTransaction();
        }
        entry.setFinancialTransaction(currentTransaction);
        Entry newEntry = this.financialTransactionService.createEntry((Entry)entry);
        this.cacheDataList = this.getDataList(this.financialTransactionSearch);
        int newrow = this.cacheDataList.indexOf(newEntry);
        this.fireTableRowsInserted(newrow, newrow);
        return newrow;
    }

    public int addEntry(Object value, Entry entry, int row) throws LimaException {
        FinancialTransaction currentTransaction = null;
        int financialTransactionRow = 0;
        Object currentRow = this.cacheDataList.get(row);
        if (currentRow instanceof FinancialTransaction) {
            currentTransaction = (FinancialTransaction)currentRow;
            financialTransactionRow = this.getDataList(this.financialTransactionSearch).indexOf((FinancialTransaction)currentRow);
        } else if (currentRow instanceof Entry) {
            Entry currentEntry = (Entry)currentRow;
            currentTransaction = currentEntry.getFinancialTransaction();
            financialTransactionRow = this.getDataList(this.financialTransactionSearch).indexOf(((Entry)currentRow).getFinancialTransaction());
        }
        entry.setFinancialTransaction(currentTransaction);
        Entry newEntry = this.financialTransactionService.createEntry(entry);
        this.fireTableRowsUpdated(financialTransactionRow, this.getRowCount() - 1);
        this.cacheDataList = this.getDataList(this.financialTransactionSearch);
        int newrow = this.cacheDataList.indexOf(newEntry);
        this.fireTableRowsInserted(newrow, newrow);
        return newrow;
    }

    public void notifyMethod(String serviceName, String methodeName) {
        if ((serviceName.contains("FinancialTransaction") || methodeName.contains("importEntries") || methodeName.contains("importAll")) && !methodeName.contains("search")) {
            this.cacheDataList = this.getDataList(this.financialTransactionSearch);
            this.fireTableDataChanged();
        }
    }
}

