/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransactionsearch;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.Account;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.ui.celleditor.AccountTableCellEditor;
import org.chorem.lima.ui.celleditor.BigDecimalTableCellEditor;
import org.chorem.lima.ui.celleditor.BigDecimalTableCellRenderer;
import org.chorem.lima.ui.celleditor.DateTableCellEditor;
import org.chorem.lima.ui.celleditor.EmptyCellRenderer;
import org.chorem.lima.ui.celleditor.EntryBookTableCellEditor;
import org.chorem.lima.ui.financialtransactionsearch.FinancialTransactionSearchViewHandler;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;

public class FinancialTransactionSearchTable
extends JXTable
implements KeyListener,
MouseListener {
    private static final long serialVersionUID = 3133690382049594727L;
    private static final Log log = LogFactory.getLog(FinancialTransactionSearchTable.class);
    protected FinancialTransactionSearchViewHandler handler;
    private Highlighter colorTransaction;
    private ColorHighlighter colorBalance;
    private int x_tab;
    private int y_tab;

    public FinancialTransactionSearchTable(FinancialTransactionSearchViewHandler handler) {
        this.handler = handler;
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.setDefaultEditor(Date.class, new DateTableCellEditor());
        this.setDefaultEditor(EntryBook.class, new EntryBookTableCellEditor());
        this.setDefaultEditor(Account.class, new AccountTableCellEditor());
        this.setDefaultEditor(BigDecimal.class, new BigDecimalTableCellEditor());
        this.setDefaultRenderer(BigDecimal.class, new BigDecimalTableCellRenderer());
        this.setDefaultRenderer(String.class, new EmptyCellRenderer());
        this.setDefaultRenderer(Account.class, new EmptyCellRenderer());
        this.setDefaultRenderer(EntryBook.class, new EmptyCellRenderer());
        this.addColorTransaction();
        this.addColorNonBalancedTransaction();
    }

    protected void addColorTransaction() {
        if (this.colorTransaction != null) {
            this.removeHighlighter(this.colorTransaction);
        }
        HighlightPredicate predicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                return adapter.getValueAt(adapter.row, 0) instanceof Date;
            }
        };
        this.colorTransaction = new ColorHighlighter(predicate, new Color(222, 222, 222), null);
        this.addHighlighter(this.colorTransaction);
    }

    protected void addColorNonBalancedTransaction() {
        if (this.colorBalance != null) {
            this.removeHighlighter((Highlighter)this.colorBalance);
        }
        HighlightPredicate predicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                BigDecimal currentBalance;
                boolean isHighlighted = false;
                Object value = adapter.getValueAt(adapter.row, 8);
                if (value instanceof BigDecimal && (currentBalance = (BigDecimal)value).compareTo(BigDecimal.ZERO) != 0) {
                    isHighlighted = true;
                }
                return isHighlighted;
            }
        };
        this.colorTransaction = new ColorHighlighter(predicate, new Color(255, 198, 209), null);
        this.addHighlighter(this.colorTransaction);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 127 || e.getKeyCode() == 12 && e.getModifiers() == 2) {
            this.handler.deleteSelectedRow();
        }
        if (e.getKeyCode() == 155 || e.getKeyCode() == 10 && e.getModifiers() == 2) {
            this.handler.addEmptyEntry();
        }
        if (e.getKeyCode() == 67 && e.getModifiers() == 2) {
            this.handler.copyRow();
        }
        if (e.getKeyCode() == 86 && e.getModifiers() == 2) {
            this.handler.pasteRow();
        }
        if (e.getKeyCode() == 9 && e.getModifiers() == 2) {
            this.handler.addFinancialTransaction();
        }
        if (e.getKeyCode() == 27 && !this.isEditing()) {
            this.clearSelection();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.rowAtPoint(e.getPoint()) == -1) {
            this.clearSelection();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

