/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransactionsearch;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.chorem.lima.entity.Account;
import org.chorem.lima.enums.ComboBoxAccountsEnum;
import org.chorem.lima.ui.financialtransactionsearch.AccountSearchComboBox;
import org.chorem.lima.ui.financialtransactionsearch.FinancialTransactionSearchViewHandler;
import org.nuiton.i18n.I18n;

public class AccountSearchPanel
extends JPanel {
    protected FinancialTransactionSearchViewHandler handler;
    static final long serialVersionUID = 1L;

    public AccountSearchPanel(FinancialTransactionSearchViewHandler handler) {
        this.handler = handler;
    }

    public void refresh(ComboBoxAccountsEnum comboBoxAccountsEnum) {
        switch (comboBoxAccountsEnum) {
            case ALL: {
                this.handler.setAccount(null);
                this.handler.refresh();
                this.removeAll();
                break;
            }
            case ACCOUNT: {
                AccountSearchComboBox accountComboBox = new AccountSearchComboBox(this.handler);
                this.handler.setAccount((Account)accountComboBox.getSelectedItem());
                this.handler.refresh();
                this.removeAll();
                this.add(accountComboBox);
                break;
            }
            case ACCOUNT_LIST: {
                final JTextField accountsList = new JTextField(16);
                accountsList.setMinimumSize(accountsList.getPreferredSize());
                accountsList.setToolTipText(I18n._((String)"lima.tooltip.filter", (Object[])new Object[0]));
                KeyListener accountsListKeyListener = new KeyListener(){

                    @Override
                    public void keyTyped(KeyEvent e) {
                    }

                    @Override
                    public void keyReleased(KeyEvent e) {
                        String accounts = accountsList.getText();
                        if (!accounts.equals(AccountSearchPanel.this.handler.getAccountsList())) {
                            AccountSearchPanel.this.handler.setAccountsList(accounts);
                        }
                    }

                    @Override
                    public void keyPressed(KeyEvent e) {
                    }
                };
                accountsList.addKeyListener(accountsListKeyListener);
                this.handler.setAccountsList(accountsList.getText());
                this.handler.setAccount(null);
                this.removeAll();
                this.add(accountsList);
            }
        }
    }
}

