/*
 * #%L
 * Lima :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.chorem.lima.ui.opening;

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.FiscalPeriodServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.service.LimaServiceFactory;
import org.jdesktop.swingx.JXDatePicker;
import static org.nuiton.i18n.I18n._;

public class CreateFiscalPeriodPanel extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUPW8TQRAdO3ES54NAIkJQAkqIRYO0BgeqIAhKZJHIQIQpItywvlvZm6zvlt09clAgfgI/AXoaJDoqREFNQYP4CwhR0CJm9xw7jo8EiSvuTjtv3ryZnZk33yGnFSzu0DgmKgoMbzGyeWt7+159h3lmnWlPcWlCBcmTyUK2BmN+51wbWKpVrHux7V5cC1syDFhwwHulAqPaPBVMNxkzBs71enhaF6sd80osI7XP2hGVxvrq54/sS//F6yxALFHdOKaycJxXN5PBCmS5b2AKIz2hRUGDBspQPGig3gl7tiao1ndpiz2G5zBcgSFJFZIZuPDvKTsO5x9LAyOFzS0aMHHZQClUDeI1Q8VaRPAWJREnoWQBxidrilHDylx7VGwxxUPfeUnpmIYMTBeqLtBGwA2ngj9jCikvuuQ9VMMFUyTRQvqQR9JcsaYTR0JKx0OWj4dcPQQZLjygdcEwjdmeO9R7tiLOZpH5jgPWskLrrpZT9rbiNjQ5taAzfViX3XyvbbLOGjxYx4JvcW+XKQML9mp2sMt3TSgT1phsbnch6eSlFPIJFvi9fottgIK5njxxCkh3CrptmqlBTkV4jIWp9Q/OfTQlIzN7aGQsobP+npn+8v7bu/L+nAxg7NOp0ANjjv0rFfajMtyGnkyGJDJcFO9QuVKDvGYCd4TbAfMpwqptM4rDeKesO7Hu5DbVTaTIDX/98HHm0ecByJZhVITUL1OL34C8aSqsQij8WN5cdYrG90bwfdJqMzBoWIxDOHWdB4IHbIEanNp6ZNiNGMswn1KGjpZ6/tOv6erb1f1SZFDa2b/Cu+XIPYShJJpbGu19kLokxqRmkR925z5tE2Tsd062u/+Sexf7c7XHrmVLcWQ/y06y/bvmbOf/m2EJGf4A641KewYGAAA=";
    private static final Log log = LogFactory.getLog(CreateFiscalPeriodPanel.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JXDatePicker beginDatePicker;
    protected JXDatePicker endDatePicker;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private CreateFiscalPeriodPanel $JPanel0 = this;
    private Table $Table0;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected FiscalPeriodServiceMonitorable fiscalPeriodService;
    // set begin date picker
            Date endDate;
    Calendar calendarBegin;
    // set begindate to JAN 1 - 0:00.000 of this years
            Date beginDate;
    // get end date
            Calendar calendarEnd;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CreateFiscalPeriodPanel(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CreateFiscalPeriodPanel(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateFiscalPeriodPanel(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public CreateFiscalPeriodPanel(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateFiscalPeriodPanel(boolean param0) {
        super(param0);
        $initialize();
    }

    public CreateFiscalPeriodPanel(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateFiscalPeriodPanel() {
        $initialize();
    }

    public CreateFiscalPeriodPanel(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JXDatePicker getBeginDatePicker() {
        return beginDatePicker;
    }

    public JXDatePicker getEndDatePicker() {
        return endDatePicker;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createBeginDatePicker() {
        $objectMap.put("beginDatePicker", beginDatePicker = new JXDatePicker());
        
        beginDatePicker.setName("beginDatePicker");
    }

    protected void createEndDatePicker() {
        $objectMap.put("endDatePicker", endDatePicker = new JXDatePicker());
        
        endDatePicker.setName("endDatePicker");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(beginDatePicker, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel2, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(endDatePicker, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        fiscalPeriodService = LimaServiceFactory.getInstance().getService(
                            FiscalPeriodServiceMonitorable.class);
        endDate = null;
        calendarBegin = Calendar.getInstance();
        beginDate = calendarBegin.getTime();
        calendarEnd = Calendar.getInstance();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("lima.charts.fiscalperiod.create"));
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("lima.common.begindate"));
        createBeginDatePicker();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("lima.common.enddate"));
        createEndDatePicker();
        // inline creation of $JPanel0
        setName("$JPanel0");
        
        beginDate = DateUtils.truncate(beginDate, Calendar.DATE);try {
                    FiscalPeriod result = fiscalPeriodService.getLastFiscalPeriod();
                    if (result != null){
                        beginDate = result.getEndDate();
                    }
                }
                catch (LimaException eee){
                    if(log.isDebugEnabled()){
                        log.debug("Can't get last fiscal period", eee);
                    }
                };beginDate = DateUtils.addDays(beginDate, 1);getBeginDatePicker().setDate(beginDate);endDate = DateUtils.addYears(beginDate, 1);endDate = DateUtils.addDays(endDate, -1);getEndDatePicker().setDate(endDate);$completeSetup();
    }

}