/*
 * #%L
 * Lima Swing
 * 
 * $Id: LetterComboBox.java 3051 2010-11-29 14:57:16Z echatellier $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.5/lima-swing/src/main/java/org/chorem/lima/ui/lettering/LetterComboBox.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.lettering;

import javax.swing.JComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.ui.combobox.LetterComboBoxModel;
import org.chorem.lima.ui.combobox.LetterRenderer;
import org.chorem.lima.util.LetterToString;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;

public class LetterComboBox extends JComboBox {

    private static final long serialVersionUID = 1L;

    private static final Log log =
        LogFactory.getLog(LetterComboBox.class);
    
    
    public LetterComboBox() {
        
        LetterComboBoxModel letterComboBoxModel = new LetterComboBoxModel();
        LetterRenderer letterRenderer = new LetterRenderer();
        setModel(letterComboBoxModel);
        setRenderer(letterRenderer);
        setEditable(true);
        AutoCompleteDecorator.decorate(this, LetterToString.getInstance());
    }
    
}
