/*
 * #%L
 * Lima :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.chorem.lima.ui.lettering;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class AddLetterForm extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_LETTER_LIST_COMBO_BOX = "LetterListComboBox";
    public static final String PROPERTY_RADIO_BUTTONS = "radioButtons";
    public static final String PROPERTY_VALID_OK = "validOk";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_LETTER_LIST_COMBO_BOX_VISIBLE = "LetterListComboBox.visible";
    public static final String BINDING_LIST_LETTER_BUTTON_GROUP = "listLetter.buttonGroup";
    public static final String BINDING_NEW_LETTER_BUTTON_GROUP = "newLetter.buttonGroup";
    public static final String BINDING_NEW_LETTER_TEXT_FIELD_VISIBLE = "newLetterTextField.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUz08TQRSeVkppQVEIFSIaRE4ctmq8GAgCJRVJkQRIJPbitDO2A9OddWa2rBfjn+CfoHcvJt48GQ+ePXgx/gvGePBqfLPb7rK4QGN72O6+975vvvdr3v5AGSXR9X3seZZ0bc1a1NpY2dvbqu3Tul6jqi6Zo4VEwS+VRukqGiahXWl0o1ox8GIHXiyJliNsah9BL1RQXunnnKompVqjq3FEXaniTuhe8BxXdllDUUmsr3/9TL8iL9+kEfIcUJeHVGbOQkWZDFRQmhGNxuCkNi5ybDdAhmR2A/SeN7YSx0o9xC36DL1A2QoadLAEMo1me0/Z5/DxnqNRbm5jjWEuGjc1mheyYdWbQtKWxVkLWy6zOJSHGgnWCiEV/6MsZMtxfIpBjUYkJkysuloLG4o/G0tXHRqk6V8QcF8K14mw2TbmjGwdaHTJZGeZjK1VITjF9pGouV1c4xQETiaQ+z4TmQsBOZseBlJ9SBt7XSHbkVYTOxZCxkLILvV0mVEOfSjEsKEjjsxzpnQANZbLx3gDTwVioCc1sSo8jSZivF17HAh9CXRC2uOx+CT5aXFg3mY7VomuxCoF82xF8xwNXKqKMtIFM9Sp+u8KbIMrGP7JY8NvCH3vn8L41w/f35e7Ez8KZ08khh5ZWJhERwoH2sPM0aPBuLua8eImdhaqKKcoh233t3k6QdhOxw3i4LxgdgzcWseqCRSZ7LePnwpPvpxD6TI0SGBSxib+AcrppoQqCE48596yr2jkcAieF402aA2hT7HLdYkLRbdAItZM2BpdWCRY45kaswk0YcmDmkwn1CQUVst9/j2+8265W5cU6Jw6MTyqTeYxGmQ2Zzb174LOmifu/rCjqEtEtM5JC54y//nuys37Tysp8UxLEMxhYBeD42ewhpun5moKyRrUbT8L83anZ9LhWrT1JuhWMlWhB6qhYCSoX5K7/88zoGGN++TIwLXl0n4TooTp7t11gpipHniybaZYh+YEOWfTGPPSKQzTPTGUTkmlN4b1vhk2+87i0SkM1/rO4nrfDHPA8BcjhXgAJwkAAA==";
    private static final Log log = LogFactory.getLog(AddLetterForm.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JComboBox LetterListComboBox;
    protected JRadioButton listLetter;
    protected JRadioButton newLetter;
    protected JTextField newLetterTextField;
    protected JButton ok;
    protected JAXXButtonGroup radioButtons;
    protected Boolean validOk;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AddLetterForm $JDialog0 = this;
    private Table $Table0;
    private JButton $JButton0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
        protected void performCancel() {
            setValidOk(false);
            dispose();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AddLetterForm() {
        $initialize();
    }

    public AddLetterForm(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddLetterForm(Frame param0) {
        super(param0);
        $initialize();
    }

    public AddLetterForm(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddLetterForm(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AddLetterForm(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddLetterForm(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AddLetterForm(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddLetterForm(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AddLetterForm(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddLetterForm(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AddLetterForm(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddLetterForm(Dialog param0) {
        super(param0);
        $initialize();
    }

    public AddLetterForm(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddLetterForm(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AddLetterForm(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddLetterForm(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AddLetterForm(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddLetterForm(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AddLetterForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddLetterForm(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AddLetterForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddLetterForm(Window param0) {
        super(param0);
        $initialize();
    }

    public AddLetterForm(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddLetterForm(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AddLetterForm(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddLetterForm(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AddLetterForm(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddLetterForm(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AddLetterForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddLetterForm(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AddLetterForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    public void doActionPerformed__on__ok(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    public void doWindowClosing__on__$JDialog0(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JComboBox getLetterListComboBox() {
        return LetterListComboBox;
    }

    public JRadioButton getListLetter() {
        return listLetter;
    }

    public JRadioButton getNewLetter() {
        return newLetter;
    }

    public JTextField getNewLetterTextField() {
        return newLetterTextField;
    }

    public JButton getOk() {
        return ok;
    }

    public JAXXButtonGroup getRadioButtons() {
        return radioButtons;
    }

    public Boolean getValidOk() {
        return validOk;
    }

    public Boolean isValidOk() {
        return validOk !=null && validOk;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setLetterListComboBox(JComboBox LetterListComboBox) {
        JComboBox oldValue = this.LetterListComboBox;
        this.LetterListComboBox = LetterListComboBox;
        firePropertyChange(PROPERTY_LETTER_LIST_COMBO_BOX, oldValue, LetterListComboBox);
    }

    public void setRadioButtons(JAXXButtonGroup radioButtons) {
        JAXXButtonGroup oldValue = this.radioButtons;
        this.radioButtons = radioButtons;
        firePropertyChange(PROPERTY_RADIO_BUTTONS, oldValue, radioButtons);
    }

    public void setValidOk(Boolean validOk) {
        Boolean oldValue = this.validOk;
        this.validOk = validOk;
        firePropertyChange(PROPERTY_VALID_OK, oldValue, validOk);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createLetterListComboBox() {
        $objectMap.put("LetterListComboBox", LetterListComboBox = new LetterComboBox());
        
        LetterListComboBox.setName("LetterListComboBox");
    }

    protected void createListLetter() {
        $objectMap.put("listLetter", listLetter = new JRadioButton());
        
        listLetter.setName("listLetter");
        listLetter.setSelected(true);
        listLetter.setText(_("lima.entries.lettering.radiobutton.list"));
    }

    protected void createNewLetter() {
        $objectMap.put("newLetter", newLetter = new JRadioButton());
        
        newLetter.setName("newLetter");
        newLetter.setSelected(true);
        newLetter.setText(_("lima.entries.lettering.radiobutton.new"));
    }

    protected void createNewLetterTextField() {
        $objectMap.put("newLetterTextField", newLetterTextField = new JTextField());
        
        newLetterTextField.setName("newLetterTextField");
        newLetterTextField.setColumns(15);
        newLetterTextField.setEditable(false);
    }

    protected void createOk() {
        $objectMap.put("ok", ok = new JButton());
        
        ok.setName("ok");
        ok.setText(_("lima.common.ok"));
        ok.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ok"));
    }

    protected void createRadioButtons() {
        $objectMap.put("radioButtons", radioButtons = new JAXXButtonGroup());
    }

    protected void createValidOk() {
        $objectMap.put("validOk", validOk = true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JDialog0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add(newLetter, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(newLetterTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(listLetter, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(LetterListComboBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton0, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(ok, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        { newLetter.putClientProperty("$value", true);  Object $buttonGroup = newLetter.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { listLetter.putClientProperty("$value", false);  Object $buttonGroup = listLetter.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        // late initializer
        $JDialog0.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JDialog0", $JDialog0);
        createRadioButtons();
        createValidOk();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createNewLetter();
        createNewLetterTextField();
        createListLetter();
        createLetterListComboBox();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("lima.common.cancel"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        createOk();
        // inline creation of $JDialog0
        setName("$JDialog0");
        setModal(true);
        $JDialog0.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__$JDialog0"));
        
        getRootPane().setDefaultButton(ok);// registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_NEW_LETTER_BUTTON_GROUP, true ,"radioButtons") {
        
            @Override
            public void processDataBinding() {
                { ButtonGroup $buttonGroup = getRadioButtons(); newLetter.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(newLetter); }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NEW_LETTER_TEXT_FIELD_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (newLetter != null) {
                    $bindingSources.put("newLetter.getModel()", newLetter.getModel());
                    newLetter.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    newLetter.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.chorem.lima.ui.lettering.AddLetterForm.this, BINDING_NEW_LETTER_TEXT_FIELD_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (newLetter != null) {
                    newLetterTextField.setVisible(newLetter.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (newLetter != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("newLetter.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    newLetter.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.chorem.lima.ui.lettering.AddLetterForm.this, BINDING_NEW_LETTER_TEXT_FIELD_VISIBLE));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LIST_LETTER_BUTTON_GROUP, true ,"radioButtons") {
        
            @Override
            public void processDataBinding() {
                { ButtonGroup $buttonGroup = getRadioButtons(); listLetter.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(listLetter); }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LETTER_LIST_COMBO_BOX_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (listLetter != null) {
                    $bindingSources.put("listLetter.getModel()", listLetter.getModel());
                    listLetter.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    listLetter.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.chorem.lima.ui.lettering.AddLetterForm.this, BINDING_LETTER_LIST_COMBO_BOX_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (listLetter != null) {
                    LetterListComboBox.setVisible(listLetter.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (listLetter != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("listLetter.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    }
                    listLetter.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.chorem.lima.ui.lettering.AddLetterForm.this, BINDING_LETTER_LIST_COMBO_BOX_VISIBLE));
                }
            }
        
            public void $pr$u1(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
    }

}