/*
 * #%L
 * Lima Swing
 * 
 * $Id: FiscalPeriodViewHandler.java 3209 2011-07-11 13:36:42Z vsalaun $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.5/lima-swing/src/main/java/org/chorem/lima/ui/fiscalperiod/FiscalPeriodViewHandler.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.fiscalperiod;

import static org.nuiton.i18n.I18n._;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;


import javax.swing.JOptionPane;
import org.jdesktop.swingx.JXTable;
import org.nuiton.util.DateUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.FinancialTransactionServiceMonitorable;
import org.chorem.lima.business.FiscalPeriodServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.entity.Entry;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.entity.EntryBookImpl;
import org.chorem.lima.entity.FinancialTransaction;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.fiscalperiod.AddPeriod;
import org.chorem.lima.ui.fiscalperiod.FiscalPeriodView;
import org.chorem.lima.util.DialogHelper;

/**
 * TODO add comment here.
 * 
 * @author chatellier
 * @version $Revision: 3209 $
 * 
 * Last update : $Date: 2011-07-11 15:36:42 +0200 (Mon, 11 Jul 2011) $
 * By : $Author: vsalaun $
 */
public class FiscalPeriodViewHandler {

    private static final Log log = LogFactory.getLog(FiscalPeriodViewHandler.class);
    
    private FiscalPeriodView view;
    
    protected FiscalPeriodTable table;
    
    protected FiscalPeriodTableModel tableModel;
    
    /** Service. */
    protected FiscalPeriodServiceMonitorable fiscalPeriodService;
    
    protected FinancialTransactionServiceMonitorable financialTransactionService;
    
    protected FiscalPeriodViewHandler(FiscalPeriodView view) {
        this.view=view;
        
        fiscalPeriodService =
            LimaServiceFactory.getInstance().getService(
                    FiscalPeriodServiceMonitorable.class);
        
        financialTransactionService =
            LimaServiceFactory.getInstance().getService(
                    FinancialTransactionServiceMonitorable.class);
    }

    public void addFiscalPeriod() {
        
        FiscalPeriodTableModel model =
            (FiscalPeriodTableModel)getView().getFiscalPeriodTable().getModel();
        
        AddPeriod addPeriodDialog = new AddPeriod(getView());
        // jaxx don't call super() ?
        addPeriodDialog.setLocationRelativeTo(getView());
        addPeriodDialog.setVisible(true);
        
        FiscalPeriod fiscalPeriod = addPeriodDialog.getPeriod();
        // null = cancel
        if (fiscalPeriod!= null) {
            //check if fiscalperiod have 12 months, ask a confirmation
            int nbMonth =
                DateUtil.getDifferenceInMonths(fiscalPeriod.getBeginDate(),
                        fiscalPeriod.getEndDate());
            int n = 0;
            if(nbMonth !=12){
                n = JOptionPane.showConfirmDialog(getView(),
                        _("lima.charts.fiscalperiod.question.morethan12"),
                        _("lima.common.question"),
                        JOptionPane.YES_NO_OPTION,
                        JOptionPane.QUESTION_MESSAGE);
            }
            if (n == JOptionPane.YES_OPTION || nbMonth ==11){
                try {
                    model.addFiscalPeriod(fiscalPeriod);
                } catch (LimaException eee) {
                    if (log.isErrorEnabled()) {
                        log.error("Can't add fiscal period", eee);
                    }
                    DialogHelper.showMessageDialog(eee.getMessage());
                }
            }
        }
    }

    public void blockFiscalPeriod() {
        JXTable fiscalPeriodeTable = getView().getFiscalPeriodTable();
        int selectedRow = fiscalPeriodeTable.getSelectedRow();
        FiscalPeriodTableModel model =
            (FiscalPeriodTableModel)getView().getFiscalPeriodTable().getModel();
        // blocked it
        try {
            FiscalPeriod selectedFiscalPeriod =
                model.getFiscalPeriodAtRow(selectedRow);
            //check if the user want to block the fiscal year
            int response =
                JOptionPane.showConfirmDialog(getView(),
                        _("lima.charts.fiscalperiod.question.blocked"),
                        _("lima.common.question"), JOptionPane.YES_NO_OPTION,
                        JOptionPane.QUESTION_MESSAGE);
            if (response == JOptionPane.YES_OPTION) {
                //use to tell if the user wants to create a new fiscal year
                boolean newyear = false;
                //check if two fiscal periods are open
                if (model.getRowCount()-1 != selectedRow) {
                    newyear = true; //two are open
                } else {
                    //check if the user wants to create a new fiscal year
                    response =
                        JOptionPane.showConfirmDialog(getView(),
                                _("lima.charts.fiscalperiod.question.newyear"),
                                _("lima.common.question"), JOptionPane.YES_NO_OPTION,
                                JOptionPane.QUESTION_MESSAGE);
                    //create a new fiscal year
                    if (response == JOptionPane.YES_OPTION) {
                        addFiscalPeriod();
                        newyear = true;
                    }
                }
                addRetainedEarnings(selectedFiscalPeriod, newyear);
                model.blockFiscalPeriod(selectedFiscalPeriod);
            }
        } catch (LimaException eee) {
            if (log.isErrorEnabled()) {
                log.error("Can't block fiscalperiod", eee);
            }
            DialogHelper.showMessageDialog(eee.getMessage());
        }
    }
    
    /**
     * 
     * Sets EntryBook and Date to use
     */
    public void addRetainedEarnings(FiscalPeriod selectedFiscalPeriod, boolean newyear) {
        JXTable fiscalPeriodeTable = getView().getFiscalPeriodTable();
        int selectedRow = fiscalPeriodeTable.getSelectedRow();
        FiscalPeriodTableModel model =
            (FiscalPeriodTableModel)getView().getFiscalPeriodTable().getModel();
        try {
            boolean found = false;
            List<FinancialTransaction> financialTransactionsList = 
                    financialTransactionService.getAllFinancialTransactionsFromDateToDate(
                            selectedFiscalPeriod.getBeginDate(), selectedFiscalPeriod.getEndDate());
            //check if they are at least one transaction to be report
            if (!financialTransactionsList.isEmpty()) {
                int i = 0;
                while (i < financialTransactionsList.size() && !found) {
                    Collection<Entry> entryList = financialTransactionsList.get(i).getEntry();
                    for (Entry entry : entryList) {
                        if (Integer.valueOf(entry.getAccount().getAccountNumber().substring(0, 1)) < 6
                                && !entry.getAmount().equals(BigDecimal.ZERO)) {
                            found = true;
                        }
                    }
                    i++;
                }
            }
            //report if they are at least one transaction to be report
            if (found) {
                //check if the user wants to report datas
                int response =
                    JOptionPane.showConfirmDialog(getView(),
                            _("lima.charts.fiscalperiod.question.addretainedearnings"),
                            _("lima.common.question"), JOptionPane.YES_NO_OPTION,
                            JOptionPane.QUESTION_MESSAGE);
                //ask user for the entrybook to use for retained earnings
                if (response == JOptionPane.YES_OPTION) {
                    //Sets EntryBook
                    EntryBook newEntryBook = new EntryBookImpl();
                    RetainedEarningsEntryBookForm entryBookForm = 
                            new RetainedEarningsEntryBookForm(view);
                    entryBookForm.setEntryBook(newEntryBook);
                    // jaxx constructor don't call super() ?
                    entryBookForm.setLocationRelativeTo(view);
                    entryBookForm.setVisible(true);
                    // null == cancel action
                    EntryBook entryBook = entryBookForm.getEntryBook();
                    if (entryBook != null) {
                        fiscalPeriodService.addRetainedEarnings(
                                selectedFiscalPeriod, newyear, entryBook);
                    }
                }
            }
        } catch (LimaException eee) {
            if (log.isErrorEnabled()) {
                log.error("Can't set net income", eee);
            }
            DialogHelper.showMessageDialog(eee.getMessage());
                
        }
    }

    public FiscalPeriodView getView() {
        return view;
    }
    
    public void refresh(){
        tableModel = (FiscalPeriodTableModel)getView().getFiscalPeriodTable().getModel();
        tableModel.refresh();
    }
}
