/*
 * #%L
 * Lima :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.chorem.lima.ui.fiscalperiod;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.FiscalPeriodServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.entity.FiscalPeriodImpl;
import org.chorem.lima.service.LimaServiceFactory;
import org.jdesktop.swingx.JXDatePicker;
import static org.nuiton.i18n.I18n._;

public class AddPeriod extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_PERIOD = "period";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUz08TQRSeVlooP0QgEIwQC1aNJm7xRzgIQRBspCk/Yj0Qe3G6O7QD0511dlYWD8Y/wT9B715MvHkyHjx78GL8F4zx4NX4ZrbtsrBSEnrYbt77vm++93bee/cTpVyBpnaw7xvCsyVtEKO4tLW1Ud0hplwhrimoI7lAwS+RRMkK6rPacVeiS5WSoueb9PwybzjcJvYB9lwJ9bpynxG3ToiUaDLKMF03X26n53zHEy3Vtqk41Te/fyVfW6/eJhHyHXB3DkrJdmKFlXSVUJJaEg3DSc9xnmG7BjYEtWvgd0DFlhl23XXcIM/QS9RdQmkHCxCTaPrkJWsNzfcdiTK54grFjNdmJLrGRc0w61yQhsFoAxseNbapa2LmEEG5ZSxZ1qZ+cxytkJZorMEtwgoaFeQe4yojEs12EjvCWVNKofJIrqytr9pUgkP6ggjweEW304T6KCPCCKozjiCPlbmpUkPHQm51htzuDLlzCJIOSocrerg58Kmo3I/0JKR153R/oPrxyGVy9+BqGDqnkJk2oSdXLOEqYcAYVtfGb0KDqAJNtrGDVVKj9gqWZJOau0RIlFXmdmCkdiV3AqZvFLdCSFSgdZju6nQ0N0BsK8q7HAU0S9Pci9FUv4ltk7D7npTchvZGCgmiCnk9NMJ3w7DRzAl0IdIzGG0jHO1w9hIVlBIehKHJlaPb4BGkgj0wfmgPKEGd/Ts28u3jjw+F1vCn4ezRWOiB3QVD6QgO10JSdfRgMPmepCy/hp25Csq4hMHi04ttIsZYuZkGc3DekKIbim48xG4dJFLd3z99Hnv69QxKFlAv49gqYIVfRRlZF9AFzizfubeoHfXv9aitpbxJNGqRbewxucy4SzbAIpZUfYiz8xaWOFultgWfYsGHnkzE9KRtrJr58mek/H6x1ZcE+Dz/X3jYm9QTlKY2ozbRa7G58WLXYJ/jEs/i4WaL23UJ9d/rNMdqVj/vxhWegpWGGYzOfHB8FktYwlVPEihWsRZ0Fept8cSiXZL4UmUfxGtMddRQ4eIxCldPrXDj1AozoPAP63E/j8MHAAA=";
    private static final Log log = LogFactory.getLog(AddPeriod.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JXDatePicker beginDatePicker;
    protected JButton cancelButton;
    protected JXDatePicker endDatePicker;
    protected FiscalPeriodTableModel modelFiscalPeriodTable;
    protected JButton okButton;
    protected FiscalPeriod period;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AddPeriod $JDialog0 = this;
    private Table $Table0;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private Table $Table1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected FiscalPeriodServiceMonitorable fiscalPeriodService;
    // set begin date picker
            Date endDate;
    Calendar calendarBegin;
    // set begindate to JAN 1 - 0:00.000 of this years
            Date beginDate;
    // get end date
            Calendar calendarEnd;
    
    
    
            protected void performOk() {
                if (period == null) {
                    // FIXME never ever use IMPL !!!
                    setPeriod(new FiscalPeriodImpl());
                }
                getPeriod().setBeginDate(beginDatePicker.getDate());
                getPeriod().setEndDate(endDatePicker.getDate());
                dispose();
            }
            
            protected void performCancel() {
                setPeriod(null);
                dispose();
            }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AddPeriod() {
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Frame param0) {
        super(param0);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Dialog param0) {
        super(param0);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Window param0) {
        super(param0);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    public void doActionPerformed__on__okButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performOk();
    }

    public void doWindowClosing__on__$JDialog0(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JXDatePicker getBeginDatePicker() {
        return beginDatePicker;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JXDatePicker getEndDatePicker() {
        return endDatePicker;
    }

    public FiscalPeriodTableModel getModelFiscalPeriodTable() {
        return modelFiscalPeriodTable;
    }

    public JButton getOkButton() {
        return okButton;
    }

    public FiscalPeriod getPeriod() {
        return period;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setPeriod(FiscalPeriod period) {
        FiscalPeriod oldValue = this.period;
        this.period = period;
        firePropertyChange(PROPERTY_PERIOD, oldValue, period);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createBeginDatePicker() {
        $objectMap.put("beginDatePicker", beginDatePicker = new JXDatePicker());
        
        beginDatePicker.setName("beginDatePicker");
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("lima.common.cancel"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected void createEndDatePicker() {
        $objectMap.put("endDatePicker", endDatePicker = new JXDatePicker());
        
        endDatePicker.setName("endDatePicker");
    }

    protected void createModelFiscalPeriodTable() {
        $objectMap.put("modelFiscalPeriodTable", modelFiscalPeriodTable = new FiscalPeriodTableModel());
    }

    protected void createOkButton() {
        $objectMap.put("okButton", okButton = new JButton());
        
        okButton.setName("okButton");
        okButton.setText(_("lima.common.ok"));
        okButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__okButton"));
    }

    protected void createPeriod() {
        $objectMap.put("period", period = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JDialog0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(beginDatePicker, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(endDatePicker, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add(cancelButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 1 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        // late initializer
        $JDialog0.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JDialog0", $JDialog0);
        createModelFiscalPeriodTable();
        fiscalPeriodService = LimaServiceFactory.getInstance().getService(
                            FiscalPeriodServiceMonitorable.class);
        endDate = null;
        calendarBegin = Calendar.getInstance();
        beginDate = calendarBegin.getTime();
        calendarEnd = Calendar.getInstance();
        createPeriod();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("lima.common.begindate"));
        createBeginDatePicker();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("lima.common.enddate"));
        createEndDatePicker();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createCancelButton();
        createOkButton();
        // inline creation of $JDialog0
        setName("$JDialog0");
        setModal(true);
        $JDialog0.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__$JDialog0"));
        
        getRootPane().setDefaultButton(okButton);beginDate = DateUtils.truncate(beginDate, Calendar.DATE);try {
                    FiscalPeriod result = fiscalPeriodService.getLastFiscalPeriod();
                    if (result != null){
                        beginDate = result.getEndDate();
                    }
                }
                catch (LimaException eee){
                    if(log.isDebugEnabled()){
                        log.debug("Can't get last fiscal period", eee);
                    }
                };beginDate = DateUtils.addDays(beginDate, 1);getBeginDatePicker().setDate(beginDate);endDate = DateUtils.addYears(beginDate, 1);endDate = DateUtils.addDays(endDate, -1);getEndDatePicker().setDate(endDate);$completeSetup();
    }

}