/*
 * #%L
 * Lima Swing
 * 
 * $Id: EntryBooksReportsTable.java 3131 2011-05-17 13:02:49Z vsalaun $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.5/lima-swing/src/main/java/org/chorem/lima/ui/entrybooksreports/EntryBooksReportsTable.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.entrybooksreports;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;

import org.chorem.lima.entity.Entry;
import org.chorem.lima.entity.FinancialTransaction;
import org.chorem.lima.ui.celleditor.BigDecimalTableCellRenderer;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;


public class EntryBooksReportsTable extends JXTable
    implements KeyListener, MouseListener {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1L;

    protected EntryBooksReportsViewHandler handler;
    
    protected EntryBooksReportsTableModel model;
    
    private Highlighter colorReportsDatas;
    
    private FinancialTransaction oldRow;
    
    private Boolean highlighterReportsDatasBoolean;

    /**
     */
    public EntryBooksReportsTable(EntryBooksReportsViewHandler handler, EntryBooksReportsTableModel model) {

        this.handler = handler;
        this.model = model;
        
        addKeyListener(this);
        addMouseListener(this);
        
        highlighterReportsDatasBoolean=true;
        //Get new BigDecimal renderer
        setDefaultRenderer(BigDecimal.class, new BigDecimalTableCellRenderer());
        //highlight financial financial transactions
        addColorReportsDatas();

    }

    /**
     * Cette méthode permet de colorer toutes les reportsdatas dans le tableau
     * afin de bien distinguer les entête de comptes et les entrées comptables.
     * On récupère la première cellule, on vérifie que c'est pas null
     */
   protected void addColorReportsDatas() {
       if (colorReportsDatas != null) {
           removeHighlighter(colorReportsDatas);
       }
       HighlightPredicate predicate = new HighlightPredicate() {
           @Override
           public boolean isHighlighted(Component renderer,
                   ComponentAdapter adapter) {
               Entry entry = model.getElementAt(adapter.row);
               FinancialTransaction financialTransaction = entry.getFinancialTransaction();
               if (financialTransaction != oldRow){
                   highlighterReportsDatasBoolean = !highlighterReportsDatasBoolean;
               }
               oldRow = financialTransaction;
               if (adapter.row ==0){
                   highlighterReportsDatasBoolean=false;
               }
               return highlighterReportsDatasBoolean;
           }
       };
       colorReportsDatas =
            new ColorHighlighter(predicate, new Color(222,222,222), null);
        addHighlighter(colorReportsDatas);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.rowAtPoint(e.getPoint()) == -1) {
            this.clearSelection();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    /**
     * for each action combination key are think
     * for extend keyboard and laptop keyboard
     */
    @Override
    public void keyPressed(KeyEvent e) {
        // clear row selection with the key: escape
        if (e.getKeyCode() == KeyEvent.VK_ESCAPE) {
        	if (!this.isEditing()) {
                this.clearSelection();
        	}
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}
