/*
 * #%L
 * Lima :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.chorem.lima.ui.accountsreports;

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.enums.ComboBoxDatesEnum;
import static org.nuiton.i18n.I18n._;

public class AccountsReportsView extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_PERIOD_COMBO_BOX = "periodComboBox";
    public static final String PROPERTY_SELECTED_ROW = "selectedRow";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVzW8TRxSfGJzgmPAVIHwECNSt1ArWhANVlfCRGEVJ5EAaVwjVl87ujuKB8cwyM1tve6j4E/gT4M4FiRunqgfOPfSC+BeqigNXxJvZ9a7XdhqILXl2d957v/m937x58+JfVFQSXXyIo8iRIde0TZz1pQcP7rkPiafvEOVJGmghUfwbK6BCE5X9dF5p9FWzbsKrSXi1JtqB4IT3RC/U0aTSvzGiWoRojc7lIzylqo3UvBAFoeyipqSGoT57/1/hqf/keQGhKAB2M5DK3G5RWSb766hAfY2OwUq/4irDfBtoSMq3ge+UmasxrNRd3CaP0R9ooo7GAywBTKNLn5+yxbDxUaDRROUn7DJyVaPrQm47XktI0nYYbWMnpA72PAGQSpJASK2cpeR7K/6+T0knCCzYOEC1MPcZkRrd2BvUahyfIZYVYbDrxN8SHY2OGgUco4qzLAQjmGeep9vCJ6wP02am0eKXs7GRGwYyW2K60rBSrnGqKWb0dyJBtW/s9nqgNwXqTqy2M+D5vzDzxjTTI2S8J/MancoVj+pAKTjWZjxLacChgEgqfNh1VyyLSKMTRqooCVjvzhvvM2nQpUpf0psWpEGw9FqbmBMG6dW+XLsBmPyyx5Pwht1aIevYJQxqPsfYTuZzLFfSPK6aqQt5834Xe49A3RzMcqi14H2OnETavH+Xn5+qrMPGCMYMZ8h8JoeUmfJR3Wz6Su77PZacQb2SgVfqVCVCUcFtPQKz873MBj0G6uia+ZzN8z5QiTW2Un5thuup7QhuG2J3iEt1uhF9Pt34+SG2o3F8TRJ/Z4BJJZhPdrImFBpDfSQ6mzsW0K2drFtn7XSsiYoyhGk4R83BBr8Fpri1n+pr7QbQWj+enP7n9btXK91+Xoa1Twx17bmOoM8GUsCJ1NQsfThu5qGmrLqBg4UmKqmk9ME6O4RY92QAOVgv7nom3FnFqgUQxYm3f/518pe/96HCCppkAvsr2PivoZJuSVABVIuCW7cto4OdAzAeMdyg9jXUPpy1RcoZ5WQOa7hd3FCTmxHIMDtEhpSLW3rzYbrx8nZXijGgdnpH90yO4s9oPF7NXm7JvTX0MisHioS+yO6nYTfWmHlWgqTI1+y4MZirmb5nhs0oNI8fLWXz1rC2b0dGuLwrAhxgT7CwzWuCa2gf96miyRnfAXP+MzAPtuh2i8FfE1NAhxZ9rPGcS7kP7eDm3nGL9gY1ZrJ3kJIUnVViyI2Y5ZTq7WkjsdptI38YGeHGyAhLgPAJdI3+L/sKAAA=";
    public static final String PROPERTY$ACCOUNTS_REPORTS_PERIOD_SEARCH_PANEL0 = "$AccountsReportsPeriodSearchPanel0";
    public static final String PROPERTY$JCOMBO_BOX0 = "$JComboBox0";
    public static final String PROPERTY$LIST_SELECTION_MODEL0 = "$ListSelectionModel0";
    private static final Log log = LogFactory.getLog(AccountsReportsView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel accountSelectorLabel;
    protected AccountsReportsTable accountsReportsTable;
    protected JLabel amountCreditLabel;
    protected JLabel amountDebitLabel;
    protected JLabel amountSoldeLabel;
    protected JButton back;
    protected AccountsReportsViewHandler handler;
    protected AccountsReportsTableModel modelAccountsReportsTable;
    protected JButton next;
    protected JComboBox periodComboBox;
    protected Boolean selectedRow;
    protected JLabel soldeLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AccountsReportsView $Table0 = this;
    private Table $Table1;
    private AccountsReportsPeriodSearchPanel $AccountsReportsPeriodSearchPanel0;
    private JComboBox $JComboBox0;
    private JScrollPane $JScrollPane0;
    private ListSelectionModel $ListSelectionModel0;
    private Table $Table2;
    private JLabel $JLabel0;
    private JLabel $JLabel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    AccountsReportsPeriodSearchPanel periodSearchPanel;
    AccountComboBox comboBox;
    
        
        void $afterCompleteSetup() {
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AccountsReportsView() {
        $initialize();
    }

    public AccountsReportsView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__back(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        comboBox.back();
    }

    public void doActionPerformed__on__next(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        comboBox.next();
    }

    public void doActionPerformed__on__periodComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        periodSearchPanel.refresh(ComboBoxDatesEnum.valueOfDescription((String) periodComboBox.getSelectedItem()));                  validate(); repaint();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JLabel getAccountSelectorLabel() {
        return accountSelectorLabel;
    }

    public AccountsReportsTable getAccountsReportsTable() {
        return accountsReportsTable;
    }

    public JLabel getAmountCreditLabel() {
        return amountCreditLabel;
    }

    public JLabel getAmountDebitLabel() {
        return amountDebitLabel;
    }

    public JLabel getAmountSoldeLabel() {
        return amountSoldeLabel;
    }

    public JButton getBack() {
        return back;
    }

    public AccountsReportsViewHandler getHandler() {
        return handler;
    }

    public AccountsReportsTableModel getModelAccountsReportsTable() {
        return modelAccountsReportsTable;
    }

    public JButton getNext() {
        return next;
    }

    public JComboBox getPeriodComboBox() {
        return periodComboBox;
    }

    public Boolean getSelectedRow() {
        return selectedRow;
    }

    public JLabel getSoldeLabel() {
        return soldeLabel;
    }

    public Boolean isSelectedRow() {
        return selectedRow !=null && selectedRow;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$AccountsReportsPeriodSearchPanel0(AccountsReportsPeriodSearchPanel $AccountsReportsPeriodSearchPanel0) {
        AccountsReportsPeriodSearchPanel oldValue = this.$AccountsReportsPeriodSearchPanel0;
        this.$AccountsReportsPeriodSearchPanel0 = $AccountsReportsPeriodSearchPanel0;
        firePropertyChange(PROPERTY$ACCOUNTS_REPORTS_PERIOD_SEARCH_PANEL0, oldValue, $AccountsReportsPeriodSearchPanel0);
    }

    public void set$JComboBox0(JComboBox $JComboBox0) {
        JComboBox oldValue = this.$JComboBox0;
        this.$JComboBox0 = $JComboBox0;
        firePropertyChange(PROPERTY$JCOMBO_BOX0, oldValue, $JComboBox0);
    }

    public void set$ListSelectionModel0(ListSelectionModel $ListSelectionModel0) {
        ListSelectionModel oldValue = this.$ListSelectionModel0;
        this.$ListSelectionModel0 = $ListSelectionModel0;
        firePropertyChange(PROPERTY$LIST_SELECTION_MODEL0, oldValue, $ListSelectionModel0);
    }

    public void setHandler(AccountsReportsViewHandler handler) {
        AccountsReportsViewHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    public void setPeriodComboBox(JComboBox periodComboBox) {
        JComboBox oldValue = this.periodComboBox;
        this.periodComboBox = periodComboBox;
        firePropertyChange(PROPERTY_PERIOD_COMBO_BOX, oldValue, periodComboBox);
    }

    public void setSelectedRow(Boolean selectedRow) {
        Boolean oldValue = this.selectedRow;
        this.selectedRow = selectedRow;
        firePropertyChange(PROPERTY_SELECTED_ROW, oldValue, selectedRow);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table1() {
        return $Table1;
    }

    protected AccountsReportsPeriodSearchPanel get$AccountsReportsPeriodSearchPanel0() {
        return $AccountsReportsPeriodSearchPanel0;
    }

    protected JComboBox get$JComboBox0() {
        return $JComboBox0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected ListSelectionModel get$ListSelectionModel0() {
        return $ListSelectionModel0;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAccountSelectorLabel() {
        $objectMap.put("accountSelectorLabel", accountSelectorLabel = new JLabel());
        
        accountSelectorLabel.setName("accountSelectorLabel");
        accountSelectorLabel.setText(_("lima.common.account"));
    }

    protected void createAccountsReportsTable() {
        $objectMap.put("accountsReportsTable", accountsReportsTable = new AccountsReportsTable(getHandler()));
        
        accountsReportsTable.setName("accountsReportsTable");
        accountsReportsTable.setColumnControlVisible(true);
        accountsReportsTable.setRowHeight(24);
    }

    protected void createAmountCreditLabel() {
        $objectMap.put("amountCreditLabel", amountCreditLabel = new JLabel());
        
        amountCreditLabel.setName("amountCreditLabel");
    }

    protected void createAmountDebitLabel() {
        $objectMap.put("amountDebitLabel", amountDebitLabel = new JLabel());
        
        amountDebitLabel.setName("amountDebitLabel");
    }

    protected void createAmountSoldeLabel() {
        $objectMap.put("amountSoldeLabel", amountSoldeLabel = new JLabel());
        
        amountSoldeLabel.setName("amountSoldeLabel");
    }

    protected void createBack() {
        $objectMap.put("back", back = new JButton());
        
        back.setName("back");
        back.setText(_("lima.common.buttonback"));
        back.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__back"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new AccountsReportsViewHandler(this));
    }

    protected void createModelAccountsReportsTable() {
        $objectMap.put("modelAccountsReportsTable", modelAccountsReportsTable = new AccountsReportsTableModel());
    }

    protected void createNext() {
        $objectMap.put("next", next = new JButton());
        
        next.setName("next");
        next.setText(_("lima.common.buttonnext"));
        next.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__next"));
    }

    protected void createPeriodComboBox() {
        $objectMap.put("periodComboBox", periodComboBox = new JComboBox(ComboBoxDatesEnum.descriptions()));
        
        periodComboBox.setName("periodComboBox");
        periodComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__periodComboBox"));
    }

    protected void createSelectedRow() {
        $objectMap.put("selectedRow", selectedRow = false);
    }

    protected void createSoldeLabel() {
        $objectMap.put("soldeLabel", soldeLabel = new JLabel());
        
        soldeLabel.setName("soldeLabel");
        soldeLabel.setText(_("lima.common.solde"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add($Table1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(accountSelectorLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        add($JComboBox0, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(back, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(next, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 6, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($Table2, new GridBagConstraints(0, 2, 7, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add(periodComboBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($AccountsReportsPeriodSearchPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(accountsReportsTable);
        // inline complete setup of $Table2
        $Table2.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(amountDebitLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel1, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(amountCreditLabel, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(soldeLabel, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(amountSoldeLabel, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 3 property setters
        accountsReportsTable.setHighlighters(org.jdesktop.swingx.decorator.HighlighterFactory.createSimpleStriping(new java.awt.Color(222,222,222)));
        accountsReportsTable.setModel(getModelAccountsReportsTable());
        accountsReportsTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        createSelectedRow();
        createModelAccountsReportsTable();
        periodSearchPanel = new AccountsReportsPeriodSearchPanel(handler);
        comboBox = new AccountComboBox(handler);
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createPeriodComboBox();
        // inline creation of $AccountsReportsPeriodSearchPanel0
        $objectMap.put("$AccountsReportsPeriodSearchPanel0", $AccountsReportsPeriodSearchPanel0 = periodSearchPanel);
        
        $AccountsReportsPeriodSearchPanel0.setName("$AccountsReportsPeriodSearchPanel0");
        createAccountSelectorLabel();
        // inline creation of $JComboBox0
        $objectMap.put("$JComboBox0", $JComboBox0 = comboBox);
        
        $JComboBox0.setName("$JComboBox0");
        createBack();
        createNext();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createAccountsReportsTable();
        // inline creation of $ListSelectionModel0
        $objectMap.put("$ListSelectionModel0", $ListSelectionModel0 = getAccountsReportsTable().getSelectionModel());
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("lima.common.amountdebit"));
        createAmountDebitLabel();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("lima.common.amountcredit"));
        createAmountCreditLabel();
        createSoldeLabel();
        createAmountSoldeLabel();
        // inline creation of $Table0
        setName("$Table0");
        
        $completeSetup();
    }

}