/*
 * #%L
 * Lima :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.chorem.lima.ui.account;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.AccountServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.entity.Account;
import org.chorem.lima.entity.AccountImpl;
import org.chorem.lima.service.LimaServiceFactory;
import static org.nuiton.i18n.I18n._;

public class UpdateSubLedgerForm extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ACCOUNT = "account";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DESCRIPTION_TEXT_FIELD_TEXT = "descriptionTextField.text";
    public static final String BINDING_MASTER_ACCOUNT_TEXT_FIELD_TEXT = "masterAccountTextField.text";
    public static final String BINDING_NUMBER_TEXT_FIELD_TEXT = "numberTextField.text";
    public static final String BINDING_THIRD_PARTY_TEXT_FIELD_TEXT = "thirdPartyTextField.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUz08TQRSeVgq0oCiFCooEsQdjdKsYDwYUkKYRUsVYTIi9ONsd28HZnXF2VpaL8U/wT9C7FxNvnowHzx68GP8FYzx4Nb7Zbn8sbIWkPWx333vf9773Zt579xOlXInO72DfN6TnKGoTY2N1e3vT3CE1VSRuTVKhuETNXyKJklU0YrXtrkIXqmUNL4Twwhq3BXeI04VeLKOMq/YYcRuEKIXORRE11y1U2u5FX3iyxdoWFcf65vev5Gvr1dskQr4AdSehlLnDUJ1KBsooSS2FxiHTC1xg2KmDDEmdOug9rm1rDLvufWyT5+glGiqjQYElkCk0f/SSA44A7wuF0vmNIsWM168qZHBZN2oNLoltMGpjw6MGrtU4kBqPhIUVqXhmmVh1Iktc2kIENIMKDYVRCs3upwANVO0Zq82ALkh+C5uMQNapSIPcXSjXCHw6Mt0GDOc3ytgkDBDjuhV+GNq06qCxduyY49kmkVvEVyVKGLQ0F4G0HVFYJl/kNc8GyZBkuhuhAGC0nOKApmv6eyJKNtG6k5Q7kXyneyUNWM4cZF+IYc+qBpXWAyzV3tHIF3qQX48hz9nYVUSGZ/Y/frg9dzyluAMNy0Za3DRHo5P8mX67ElolOhs5epg6ozN1nbFIVFFKemCGu1I9OKgPwdUc0al9I6oJA+/fXPbbxx8fSq25HIXck7GhXWsF5kVILohUVKceaw6lpygr3MNisYrSLmGwk4KdMxMjrBK6QRzkO6XhhoYbd7HbAIrU0PdPn3NPvh5DyRLKMI6tEtbx6yitGhK6wJnli+WVQNHo7rBeKFqbQpMWeYo9ptYYd8kmSMT6lil0YgmGFM+Z1LHgEG770JOZmJ60hZnpL3+ylfcrrb4kQOd0z/BOb1KP0SB1GHVIsLHCZRS7oUaESzyLd5ZO3BpK6P+MCG/njeB5M67wlM0tzGADLDXTz2EF+9H0FIFiNepWUIV+Wz4y6YCebu0txnNkD+XQ5nX9WIpnyB2doYeGmb41zPatYb5vDfm+NVzsW8OlvjVc7puhAAz/AGOSDJDqCAAA";
    public static final String PROPERTY$DOCUMENT0 = "$Document0";
    public static final String PROPERTY$DOCUMENT1 = "$Document1";
    public static final String PROPERTY$DOCUMENT2 = "$Document2";
    private static final Log log = LogFactory.getLog(UpdateSubLedgerForm.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Account account;
    protected JTextField descriptionTextField;
    protected JTextField masterAccountTextField;
    protected JTextField numberTextField;
    protected JButton ok;
    protected JTextField thirdPartyTextField;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private UpdateSubLedgerForm $JDialog0 = this;
    private Table $Table0;
    private JLabel $JLabel0;
    private Document $Document0;
    private JLabel $JLabel1;
    private Document $Document1;
    private JLabel $JLabel2;
    private Document $Document2;
    private JLabel $JLabel3;
    private JButton $JButton0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
        protected void performCancel() {
            setAccount(null);
            dispose();
        }
            protected void performOk() {
            if (getMasterAccountTextField().getText().length() != 0) {
                AccountServiceMonitorable accountService =
                    LimaServiceFactory.getInstance().getService(
                            AccountServiceMonitorable.class);
                Account masterAccount = new AccountImpl();
                try {
                    System.out.println("setMaster : "
                        + getMasterAccountTextField().getText() + " to : "
                        + getAccount().getAccountNumber());
                    masterAccount  = accountService
                        .getAccountByNumber(getMasterAccountTextField().getText());
                } catch (LimaException eee) {
                    log.debug("Can't search account for update : "
                        + getMasterAccountTextField().getText(), eee);
                }
                if (masterAccount != null) {
                    getAccount().setMasterAccount(masterAccount);
                } else {
                    getAccount().setMasterAccount(null);
                }
            } else {
                setAccount(null);
            }
            dispose();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public UpdateSubLedgerForm() {
        $initialize();
    }

    public UpdateSubLedgerForm(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateSubLedgerForm(Frame param0) {
        super(param0);
        $initialize();
    }

    public UpdateSubLedgerForm(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateSubLedgerForm(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public UpdateSubLedgerForm(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateSubLedgerForm(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public UpdateSubLedgerForm(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateSubLedgerForm(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public UpdateSubLedgerForm(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateSubLedgerForm(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public UpdateSubLedgerForm(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateSubLedgerForm(Dialog param0) {
        super(param0);
        $initialize();
    }

    public UpdateSubLedgerForm(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateSubLedgerForm(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public UpdateSubLedgerForm(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateSubLedgerForm(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public UpdateSubLedgerForm(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateSubLedgerForm(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public UpdateSubLedgerForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateSubLedgerForm(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public UpdateSubLedgerForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateSubLedgerForm(Window param0) {
        super(param0);
        $initialize();
    }

    public UpdateSubLedgerForm(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateSubLedgerForm(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public UpdateSubLedgerForm(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateSubLedgerForm(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public UpdateSubLedgerForm(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateSubLedgerForm(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public UpdateSubLedgerForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public UpdateSubLedgerForm(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public UpdateSubLedgerForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doInsertUpdate__on__$Document2(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getAccount().setThirdParty(getThirdPartyTextField().getText());
    }

    public void doRemoveUpdate__on__$Document2(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getAccount().setThirdParty(getThirdPartyTextField().getText());
    }

    public void doInsertUpdate__on__$Document1(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getAccount().setLabel(getDescriptionTextField().getText());
    }

    public void doRemoveUpdate__on__$Document1(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getAccount().setLabel(getDescriptionTextField().getText());
    }

    public void doInsertUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getAccount().setAccountNumber(getNumberTextField().getText());
    }

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    public void doActionPerformed__on__ok(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performOk();
    }

    public void doRemoveUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getAccount().setAccountNumber(getNumberTextField().getText());
    }

    public void doWindowClosing__on__$JDialog0(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Account getAccount() {
        return account;
    }

    public JTextField getDescriptionTextField() {
        return descriptionTextField;
    }

    public JTextField getMasterAccountTextField() {
        return masterAccountTextField;
    }

    public JTextField getNumberTextField() {
        return numberTextField;
    }

    public JButton getOk() {
        return ok;
    }

    public JTextField getThirdPartyTextField() {
        return thirdPartyTextField;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$Document0(Document $Document0) {
        Document oldValue = this.$Document0;
        this.$Document0 = $Document0;
        firePropertyChange(PROPERTY$DOCUMENT0, oldValue, $Document0);
    }

    public void set$Document1(Document $Document1) {
        Document oldValue = this.$Document1;
        this.$Document1 = $Document1;
        firePropertyChange(PROPERTY$DOCUMENT1, oldValue, $Document1);
    }

    public void set$Document2(Document $Document2) {
        Document oldValue = this.$Document2;
        this.$Document2 = $Document2;
        firePropertyChange(PROPERTY$DOCUMENT2, oldValue, $Document2);
    }

    public void setAccount(Account account) {
        Account oldValue = this.account;
        this.account = account;
        firePropertyChange(PROPERTY_ACCOUNT, oldValue, account);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected Document get$Document0() {
        return $Document0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected Document get$Document1() {
        return $Document1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected Document get$Document2() {
        return $Document2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAccount() {
        $objectMap.put("account", account = null);
    }

    protected void createDescriptionTextField() {
        $objectMap.put("descriptionTextField", descriptionTextField = new JTextField());
        
        descriptionTextField.setName("descriptionTextField");
        descriptionTextField.setColumns(15);
    }

    protected void createMasterAccountTextField() {
        $objectMap.put("masterAccountTextField", masterAccountTextField = new JTextField());
        
        masterAccountTextField.setName("masterAccountTextField");
        masterAccountTextField.setColumns(15);
    }

    protected void createNumberTextField() {
        $objectMap.put("numberTextField", numberTextField = new JTextField());
        
        numberTextField.setName("numberTextField");
        numberTextField.setColumns(15);
    }

    protected void createOk() {
        $objectMap.put("ok", ok = new JButton());
        
        ok.setName("ok");
        ok.setText(_("lima.common.ok"));
        ok.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ok"));
    }

    protected void createThirdPartyTextField() {
        $objectMap.put("thirdPartyTextField", thirdPartyTextField = new JTextField());
        
        thirdPartyTextField.setName("thirdPartyTextField");
        thirdPartyTextField.setColumns(15);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JDialog0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(numberTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(descriptionTextField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(thirdPartyTextField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(masterAccountTextField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton0, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(ok, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 1 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        // late initializer
        $JDialog0.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JDialog0", $JDialog0);
        createAccount();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("lima.common.code"));
        createNumberTextField();
        // inline creation of $Document0
        $objectMap.put("$Document0", $Document0 = getNumberTextField().getDocument());
        
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document0"));
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document0"));
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("lima.common.label"));
        createDescriptionTextField();
        // inline creation of $Document1
        $objectMap.put("$Document1", $Document1 = getDescriptionTextField().getDocument());
        
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document1"));
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document1"));
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("lima.identity.contact"));
        createThirdPartyTextField();
        // inline creation of $Document2
        $objectMap.put("$Document2", $Document2 = getThirdPartyTextField().getDocument());
        
        $Document2.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document2"));
        $Document2.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document2"));
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("lima.common.masteraccount"));
        createMasterAccountTextField();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("lima.common.cancel"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        createOk();
        // inline creation of $JDialog0
        setName("$JDialog0");
        setModal(true);
        $JDialog0.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__$JDialog0"));
        
        getRootPane().setDefaultButton(ok);// registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NUMBER_TEXT_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("account", this);
                if (getAccount() != null) {
                    getAccount().addPropertyChangeListener("accountNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getAccount() != null) {
                    SwingUtil.setText(numberTextField, getAccount().getAccountNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("account", this);
                if (getAccount() != null) {
                    getAccount().removePropertyChangeListener("accountNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DESCRIPTION_TEXT_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("account", this);
                if (getAccount() != null) {
                    getAccount().addPropertyChangeListener("label", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getAccount() != null) {
                    SwingUtil.setText(descriptionTextField, getAccount().getLabel());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("account", this);
                if (getAccount() != null) {
                    getAccount().removePropertyChangeListener("label", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_THIRD_PARTY_TEXT_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("account", this);
                if (getAccount() != null) {
                    getAccount().addPropertyChangeListener("thirdParty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getAccount() != null) {
                    SwingUtil.setText(thirdPartyTextField, getAccount().getThirdParty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("account", this);
                if (getAccount() != null) {
                    getAccount().removePropertyChangeListener("thirdParty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MASTER_ACCOUNT_TEXT_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("account", this);
                if (getAccount() != null) {
                    getAccount().addPropertyChangeListener("masterAccount", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getAccount() != null && getAccount().getMasterAccount() != null) {
                    SwingUtil.setText(masterAccountTextField, getAccount().getMasterAccount().getAccountNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("account", this);
                if (getAccount() != null) {
                    getAccount().removePropertyChangeListener("masterAccount", this);
                }
            }
        });
    }

}