/*
 * #%L
 * Lima Swing
 * 
 * $Id: FinancialTransactionUnbalancedViewHandler.java 3278 2011-08-16 14:09:44Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.5.1/lima-swing/src/main/java/org/chorem/lima/ui/financialtransactionunbalanced/FinancialTransactionUnbalancedViewHandler.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.financialtransactionunbalanced;

import static org.nuiton.i18n.I18n._;


import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.entity.FinancialTransaction;
import org.chorem.lima.ui.combobox.FiscalPeriodComboBoxModel;
import org.chorem.lima.util.DialogHelper;

/**
 * Handler associated with financial transaction view.
 * 
 * @author chatellier
 * @version $Revision: 3278 $
 * 
 * Last update : $Date: 2011-08-16 16:09:44 +0200 (Tue, 16 Aug 2011) $
 * By : $Author: tchemit $
 */
public class FinancialTransactionUnbalancedViewHandler {

    /** log. */
    private static final Log log =
        LogFactory.getLog(FinancialTransactionUnbalancedViewHandler.class);

    protected FinancialTransactionUnbalancedView view;
    
    protected FinancialTransactionUnbalancedTable table;
    
    protected FinancialTransactionUnbalancedTableModel tableModel;
    
    protected FiscalPeriodComboBoxModel comboBoxModel;

    protected FinancialTransactionUnbalancedViewHandler(FinancialTransactionUnbalancedView view) {
        this.view = view;
    }    
    
    //implement new transaction button
    //add a new entry to the selected transaction
    public void addEmptyEntry(){
        
        table = view.getFinancialTransactionUnbalancedTable();
        tableModel = view.getFinancialTransactionUnbalancedTableModel();

        int indexSelectedRow = table.getSelectedRow();
        if (indexSelectedRow != -1) {
            Object selectedValue = tableModel.getElementAt(indexSelectedRow);
            try {
            	//copy + paste the description
                String description = (String) tableModel.getValueAt(indexSelectedRow, 4);
                int index = tableModel.addEmptyEntry(selectedValue, description, indexSelectedRow);
                //select the new line
                ListSelectionModel selectionModel = 
                    table.getSelectionModel();
                  selectionModel.setSelectionInterval(indexSelectedRow+1, indexSelectedRow+1);
                  //focus on second column
                  table.changeSelection(index, 1, false, false);
                  table.requestFocusInWindow();
            } catch (LimaException eee){
                if (log.isErrorEnabled()) {
                    log.error("Can't add emptyentry", eee);
                }
                DialogHelper.showMessageDialog(eee.getMessage());

            }
        }
        else {
            if (log.isWarnEnabled()) {
                log.warn("Call addentry selected transaction without selection");
            }
        }
    }
    
    /**
     * Delete selected row in table (could be transaction or entry).
     * 
     * Called by tableModel.
     * @throws LimaException 
     */
    public void deleteSelectedRow(){

        table = view.getFinancialTransactionUnbalancedTable();
        tableModel = view.getFinancialTransactionUnbalancedTableModel();

        int indexSelectedRow = table.getSelectedRow();
        if (indexSelectedRow != -1) {

            Object selectedValue = tableModel.getElementAt(indexSelectedRow);
            String message = null;
            if (selectedValue instanceof FinancialTransaction) {
                message = _("lima.charts.financialtransaction.question.removetransaction");
            }
            else {
                message = _("lima.charts.financialtransaction.question.removeentry");
            }

            int response = JOptionPane.showConfirmDialog(view, message,
                    _("lima.common.confirmation"), JOptionPane.YES_NO_OPTION);

            if (response == JOptionPane.YES_OPTION) {
                
                try {
                    tableModel.removeObject(selectedValue, indexSelectedRow);
                    //select the upper line
                    ListSelectionModel selectionModel = 
                        table.getSelectionModel();
                    selectionModel.setSelectionInterval(indexSelectedRow-1, indexSelectedRow-1);
                } catch (LimaException eee) {
                    if (log.isErrorEnabled()) {
                        log.error("Can't remove transaction or entry", eee);
                    }
                    DialogHelper.showMessageDialog(eee.getMessage());
                }
            }
        }
        else {
            if (log.isWarnEnabled()) {
                log.warn("Call delete selected row without selection");
            }
        }
    }
    
    public void refresh(){
        tableModel = view.getFinancialTransactionUnbalancedTableModel();
        tableModel.refresh();
        
        comboBoxModel = view.getModelFiscalPeriod();
        comboBoxModel.refresh();
    }
}
