/*
 * #%L
 * Lima Swing
 * 
 * $Id: LetterSearchPanel.java 3278 2011-08-16 14:09:44Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.5.1/lima-swing/src/main/java/org/chorem/lima/ui/financialtransactionsearch/LetterSearchPanel.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.financialtransactionsearch;

import javax.swing.JPanel;
import org.chorem.lima.enums.ComboBoxLetterEnum;

public class LetterSearchPanel extends JPanel {
    
    protected FinancialTransactionSearchViewHandler handler;
    
    public LetterSearchPanel(FinancialTransactionSearchViewHandler handler) {
        this.handler = handler;
    }
    
    static final long serialVersionUID = 1L;

    public void refresh(ComboBoxLetterEnum comboBoxEnum){
        
        switch (comboBoxEnum) {
        case ALL:
            handler.setLetter(null);
            handler.refresh();
            this.removeAll();
            break;
            
        case SELECT_ONE:
            LetterSearchComboBox comboBox = new LetterSearchComboBox(handler);
            this.removeAll();
            this.add(comboBox);
            break;
            
        }
        
    }
    
}
