/*
 * #%L
 * Lima Swing
 * 
 * $Id: AccountRenderer.java 3280 2011-08-16 15:02:33Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.5.1/lima-swing/src/main/java/org/chorem/lima/ui/combobox/AccountRenderer.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.combobox;

import org.chorem.lima.entity.Account;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import java.awt.Component;

public class AccountRenderer extends DefaultListCellRenderer {

    private static final long serialVersionUID = 1L;

    @Override
    public Component getListCellRendererComponent(JList list,
                                                  Object value,
                                                  int index,
                                                  boolean isSelected,
                                                  boolean cellHasFocus) {

        Account account = (Account) value;
        if (account != null) {
            String accountLabel = account.getLabel();
            int nbChars = 30;
            if (accountLabel != null && accountLabel.length() > nbChars) {
                accountLabel = accountLabel.substring(0, nbChars) + "…";
            }
            setText(account.getAccountNumber() + " - " + accountLabel);
        }
        return this;
    }

}
