/*
 * #%L
 * Lima :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.chorem.lima.ui.opening;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.BorderFactory;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.ui.opening.*;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class OpeningView extends javax.swing.JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUz08TQRSeVgq0IAgExACmYkOMiVtITDRCAIUQIPVHxBhiL87uju3AdGecmZXlYvwT/BP07sXEmyfjwbMHL8Z/wRgPXo1vdtttC4s0aQ+z3ffe973vvZ333v1EGSXRpT0cBJb0PU1rxNq+vbt7394jjl4nypFUaC5R9EulUbqMBtzYrjS6XC4ZeLEOL67xmuAe8VrQiyWUU/qQEVUlRGs0045wlCruxO7FQPiywRqLSmJ98/tX+rX76m0aoUCAuiEoJX8aqllJTwmlqavRKGR6gYsMexWQIalXAb1njW2NYaXu4Rp5jl6ivhLqFVgCmUaznZcccoT4QGiULWyvU8x4ZV6jOS4rllPlktQsRmvY8qnFBfFAgHU/ej6m5ECIEN6rUV8Vey4jUqNrnUE3o/gWhsIjbDMCySfb+qQODDL0mcjsUcCCeR0xx3DsGqQuVEz14ZbDPeiiaVhQZ9ouYZswEzgax2cE9gg7GvjAGNsD+wsRfN68T5jjfOyD/t3xteYelDDWRhSZ26MHseNwKFEZiTFbM9MQFCAPbc73T4oYeUaVg5kgknL3pKCG4IXYN3xccOi82O5M8/1Wq0RTbV8F5sJqzkXz4qbKKCN9MMNnLB8fpYfgioZo8sgQGcLQ+3di7NvHHx82GpOTg9zjiaEtgw83Wki4ZVJTk3o4GhtfU1a8i8ViGWUVYbA1wq0wnSBsp+4GcZBvxMAtA7c2saoCRabv+6fPE0+/nkHpDZRjHLsb2MRvoayuSugCZ24gVlZDRYMH/XCeM9rgbtW4i83dWqIeox7JYw2DbPuaLAfQh+mEPsRi7OyXP2M771cbvUiBtgsnhjf7kXmCeqNs4R6pr4jEvTEgFPFd3lwFScshZZ45UR/W+fC8nlRsDw0HbmjJxRrnbeq5MABQpwHcDAsw/26FfOOd8GkSaOO9kcwxdSqHMa//h2GmI4Zlc6wkM+S7ZpjtmqHQdR/muma40jXDVWD4ByNrn8b3BwAA";
    private static final Log log = LogFactory.getLog(org.chorem.lima.ui.opening.OpeningView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel accountsIcon;
    protected javax.swing.JLabel entrybooksIcon;
    protected javax.swing.JLabel fiscalperiodsIcon;
    protected org.chorem.lima.ui.opening.OpeningViewHandler handler;
    protected javax.swing.JLabel identityIcon;
    protected javax.swing.JButton ok;
    protected javax.swing.JPanel panel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private OpeningView $JDialog0 = this;
    private jaxx.runtime.swing.Table $Table0;
    private jaxx.runtime.swing.Table $Table1;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JButton $JButton1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
        protected void performNext() {
            dispose();
        }
        protected void performCancel() {
            dispose();
        }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public OpeningView() {
        $initialize();
    }

    public OpeningView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        handler.importSave();
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        performCancel();
    }

    public void doActionPerformed__on__ok(java.awt.event.ActionEvent event) {
        handler.next();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JLabel getAccountsIcon() {
        return accountsIcon;
    }

    public javax.swing.JLabel getEntrybooksIcon() {
        return entrybooksIcon;
    }

    public javax.swing.JLabel getFiscalperiodsIcon() {
        return fiscalperiodsIcon;
    }

    public org.chorem.lima.ui.opening.OpeningViewHandler getHandler() {
        return handler;
    }

    public javax.swing.JLabel getIdentityIcon() {
        return identityIcon;
    }

    public javax.swing.JButton getOk() {
        return ok;
    }

    public javax.swing.JPanel getPanel() {
        return panel;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setHandler(org.chorem.lima.ui.opening.OpeningViewHandler newValue) {
        org.chorem.lima.ui.opening.OpeningViewHandler oldValue = this.handler;
        this.handler = newValue;
        firePropertyChange(PROPERTY_HANDLER, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToPanel() {
        if (!allComponentsCreated) {
            return;
        }
        panel.add($JLabel0);
        panel.add($JButton0);
    }

    protected void createAccountsIcon() {
        $objectMap.put("accountsIcon", accountsIcon = new javax.swing.JLabel());
        
        accountsIcon.setName("accountsIcon");
    }

    protected void createEntrybooksIcon() {
        $objectMap.put("entrybooksIcon", entrybooksIcon = new javax.swing.JLabel());
        
        entrybooksIcon.setName("entrybooksIcon");
    }

    protected void createFiscalperiodsIcon() {
        $objectMap.put("fiscalperiodsIcon", fiscalperiodsIcon = new javax.swing.JLabel());
        
        fiscalperiodsIcon.setName("fiscalperiodsIcon");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new OpeningViewHandler(this));
    }

    protected void createIdentityIcon() {
        $objectMap.put("identityIcon", identityIcon = new javax.swing.JLabel());
        
        identityIcon.setName("identityIcon");
    }

    protected void createOk() {
        $objectMap.put("ok", ok = new javax.swing.JButton());
        
        ok.setName("ok");
        ok.setText(_("lima.common.next"));
        ok.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ok"));
    }

    protected void createPanel() {
        $objectMap.put("panel", panel = new javax.swing.JPanel());
        
        panel.setName("panel");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $JDialog0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($Table1, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.9, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.8, 0.1, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton1, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.1, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(ok, new GridBagConstraints(2, 1, 1, 1, 0.1, 0.1, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add(identityIcon, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(panel, new GridBagConstraints(1, 0, 1, 4, 0.9, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(accountsIcon, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(entrybooksIcon, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(fiscalperiodsIcon, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToPanel();
        
        // apply 4 property setters
        identityIcon.setIcon(new ImageIcon(getClass().getResource("/images/identity.png")));
        accountsIcon.setIcon(new ImageIcon(getClass().getResource("/images/accounts.png")));
        entrybooksIcon.setIcon(new ImageIcon(getClass().getResource("/images/entrybooks.png")));
        fiscalperiodsIcon.setIcon(new ImageIcon(getClass().getResource("/images/fiscalperiods.png")));
        // late initializer
        $JDialog0.pack();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JDialog0", this);
        createHandler();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new jaxx.runtime.swing.Table());
        
        $Table1.setName("$Table1");
        createIdentityIcon();
        createPanel();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("lima.opening.welcome"));
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("lima.opening.import"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        createAccountsIcon();
        createEntrybooksIcon();
        createFiscalperiodsIcon();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_(""));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("lima.common.close"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        createOk();
        // inline creation of $JDialog0
        setName("$JDialog0");
        setModal(true);
        
        getRootPane().setDefaultButton(ok);$completeSetup();
    }

}