/*
 * #%L
 * Lima :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.chorem.lima.ui.fiscalperiod;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.swing.*;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.FiscalPeriodServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.entity.FiscalPeriodImpl;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.fiscalperiod.*;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class AddPeriod extends javax.swing.JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_PERIOD = "period";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUz08TQRSeVlooP6JAJBghAlaNJk7xRziIIkjTSFOUWA/EXpzuju3AdGednZXFg/FP8E/QuxcTb56MB88evBj/BWM8eDW+mW27LKzUhB52N+993zffe5333v5AGU+i2S0SBFj6jmItissrm5v361vUUkXqWZK5SkgU/lJplK6hIbsb9xQ6W6toeqFNL6yKlisc6uxhL1bQoKd2OfWalCqFpuMMy/MK1W56MXB92VHtmkpSff3rZ/qV/fJNGqHABXcnoJSZXqyokr4KSjNboTE46RkpcOI0wIZkTgP8jujYKieed4+06FP0AvVXUNYlEsQUmvv/ko2G4QeuQrl8ucgIF415hS4K2cBWU0jawpy1CPYZfsI8i3CXSiZsvGLbG+bLdY1CVqGJlrApLxlUmHtI6pwqtNBL7ABnXStFyuP5qrG+5jAFDtlzKsHjedNOC+pjnEocVocPIA+VuaJTo4dCrvaGXOsNub4Pkg1Lhyu6vznwVzG1G+tJROvPm/5A9ZOxy+TtwNXAJqeRuS5hIF+ukDrlwBjT1yZoQ8OoBk13scfrtMGcIlF0g1nbVCo0o81twUhtK+GGzACXNyNIXKBzmOnqXDw3Qh07zjsXB7RLM9wz8dSwRRyL8ju+UsKB9sYKCaMaeSkyIrajMG7nJDod6xmMNo5GO5q9VA1lpA9haHLt4DZ4AKlwD0zu2wNa0GT/TIx//fD9fakz/HqPnUyE7tldMJSuFHAtFNNHHw8n31eMF9aJu1hDOY9yWHxmsU0lGKu202AOzhvVdKzp+C7xmiCR6f/28dPE4y/HULqEBrkgdolo/BrKqaaELghuB+7tZeNoeGdAby3tTaEMTDbhcINuMoczh84QBbuo7iu6FEAfphL60DVTz33+PV59t9zpRQq8nfonPOpH5hHKhqeZVdjecomrb8j1qG+LaJsl7beUfg+67VFaMM8bScX2KRoonb0V+Pq1ZEzrr2WjMdtTQ4eLhyhcOLLC5SMrzIPCX1gS3P1iBwAA";
    private static final Log log = LogFactory.getLog(org.chorem.lima.ui.fiscalperiod.AddPeriod.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected org.jdesktop.swingx.JXDatePicker beginDatePicker;
    protected javax.swing.JButton cancelButton;
    protected org.jdesktop.swingx.JXDatePicker endDatePicker;
    protected org.chorem.lima.ui.fiscalperiod.FiscalPeriodTableModel modelFiscalPeriodTable;
    protected javax.swing.JButton okButton;
    protected org.chorem.lima.entity.FiscalPeriod period;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AddPeriod $JDialog0 = this;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;
    private jaxx.runtime.swing.Table $Table1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected FiscalPeriodServiceMonitorable fiscalPeriodService;
    // set begin date picker
            Date endDate;
    Calendar calendarBegin;
    // set begindate to JAN 1 - 0:00.000 of this years
            Date beginDate;
    // get end date
            Calendar calendarEnd;
    
    
    
            protected void performOk() {
                if (period == null) {
                    // FIXME never ever use IMPL !!!
                    setPeriod(new FiscalPeriodImpl());
                }
                getPeriod().setBeginDate(beginDatePicker.getDate());
                getPeriod().setEndDate(endDatePicker.getDate());
                dispose();
            }
            
            protected void performCancel() {
                setPeriod(null);
                dispose();
            }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AddPeriod() {
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(java.awt.event.ActionEvent event) {
        performCancel();
    }

    public void doActionPerformed__on__okButton(java.awt.event.ActionEvent event) {
        performOk();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public org.jdesktop.swingx.JXDatePicker getBeginDatePicker() {
        return beginDatePicker;
    }

    public javax.swing.JButton getCancelButton() {
        return cancelButton;
    }

    public org.jdesktop.swingx.JXDatePicker getEndDatePicker() {
        return endDatePicker;
    }

    public org.chorem.lima.ui.fiscalperiod.FiscalPeriodTableModel getModelFiscalPeriodTable() {
        return modelFiscalPeriodTable;
    }

    public javax.swing.JButton getOkButton() {
        return okButton;
    }

    public org.chorem.lima.entity.FiscalPeriod getPeriod() {
        return period;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setPeriod(org.chorem.lima.entity.FiscalPeriod newValue) {
        org.chorem.lima.entity.FiscalPeriod oldValue = this.period;
        this.period = newValue;
        firePropertyChange(PROPERTY_PERIOD, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createBeginDatePicker() {
        $objectMap.put("beginDatePicker", beginDatePicker = new org.jdesktop.swingx.JXDatePicker());
        
        beginDatePicker.setName("beginDatePicker");
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new javax.swing.JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("lima.common.cancel"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected void createEndDatePicker() {
        $objectMap.put("endDatePicker", endDatePicker = new org.jdesktop.swingx.JXDatePicker());
        
        endDatePicker.setName("endDatePicker");
    }

    protected void createModelFiscalPeriodTable() {
        $objectMap.put("modelFiscalPeriodTable", modelFiscalPeriodTable = new org.chorem.lima.ui.fiscalperiod.FiscalPeriodTableModel());
    }

    protected void createOkButton() {
        $objectMap.put("okButton", okButton = new javax.swing.JButton());
        
        okButton.setName("okButton");
        okButton.setText(_("lima.common.ok"));
        okButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__okButton"));
    }

    protected void createPeriod() {
        $objectMap.put("period", period = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $JDialog0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(beginDatePicker, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(endDatePicker, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add(cancelButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // late initializer
        $JDialog0.pack();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JDialog0", this);
        createModelFiscalPeriodTable();
        fiscalPeriodService = LimaServiceFactory.getInstance().getService(
                            FiscalPeriodServiceMonitorable.class);
        endDate = null;
        calendarBegin = Calendar.getInstance();
        beginDate = calendarBegin.getTime();
        calendarEnd = Calendar.getInstance();
        createPeriod();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("lima.common.begindate"));
        createBeginDatePicker();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("lima.common.enddate"));
        createEndDatePicker();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new jaxx.runtime.swing.Table());
        
        $Table1.setName("$Table1");
        createCancelButton();
        createOkButton();
        // inline creation of $JDialog0
        setName("$JDialog0");
        setModal(true);
        
        getRootPane().setDefaultButton(okButton);jaxx.runtime.JAXXUtil.assignment(beginDate = DateUtils.truncate(beginDate, Calendar.DATE), "beginDate", org.chorem.lima.ui.fiscalperiod.AddPeriod.this);try {
                    FiscalPeriod result = fiscalPeriodService.getLastFiscalPeriod();
                    if (result != null){
                        jaxx.runtime.JAXXUtil.assignment(beginDate = result.getEndDate(), "beginDate", org.chorem.lima.ui.fiscalperiod.AddPeriod.this);
                    }
                }
                catch (LimaException eee){
                    if(log.isDebugEnabled()){
                        log.debug("Can't get last fiscal period", eee);
                    }
                };jaxx.runtime.JAXXUtil.assignment(beginDate = DateUtils.addDays(beginDate, 1), "beginDate", org.chorem.lima.ui.fiscalperiod.AddPeriod.this);getBeginDatePicker().setDate(beginDate);jaxx.runtime.JAXXUtil.assignment(endDate = DateUtils.addYears(beginDate, 1), "endDate", org.chorem.lima.ui.fiscalperiod.AddPeriod.this);jaxx.runtime.JAXXUtil.assignment(endDate = DateUtils.addDays(endDate, -1), "endDate", org.chorem.lima.ui.fiscalperiod.AddPeriod.this);getEndDatePicker().setDate(endDate);$completeSetup();
    }

}