/*
 * #%L
 * Lima Swing
 * 
 * $Id: FinancialTransactionSearchViewHandler.java 3051 2010-11-29 14:57:16Z echatellier $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.4.3/lima-swing/src/main/java/org/chorem/lima/ui/financialtransactionsearch/FinancialTransactionSearchViewHandler.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.financialtransactionsearch;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.FinancialStatementWayEnum;
import org.chorem.lima.beans.FinancialTransactionSearch;
import org.chorem.lima.beans.FinancialTransactionSearchImpl;
import org.chorem.lima.business.FinancialTransactionServiceMonitorable;
import org.chorem.lima.business.ejbinterface.FinancialTransactionService;
import org.chorem.lima.entity.Account;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.entity.Letter;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.combobox.FiscalPeriodComboBoxModel;

/**
 * Handler associated with financial transaction view.
 * 
 * @author chatellier
 * @version $Revision: 3051 $
 * 
 * Last update : $Date: 2010-11-29 15:57:16 +0100 (lun., 29 nov. 2010) $
 * By : $Author: echatellier $
 */
public class FinancialTransactionSearchViewHandler {

    /** log. */
    private static final Log log =
        LogFactory.getLog(FinancialTransactionSearchViewHandler.class);

    protected FinancialTransactionSearchView view;
    
    protected FinancialTransactionSearchTable table;
    
    protected FinancialTransactionSearchTableModel tableModel;
    
    protected FiscalPeriodComboBoxModel comboBoxModel;
    
    /** Transaction service. */
    protected final FinancialTransactionService financialTransactionService;
    
    /** data cache */
    protected FinancialTransactionSearch financialTransactionSearch;

    protected FinancialTransactionSearchViewHandler(FinancialTransactionSearchView view) {
        this.view = view;
        
        /* Services */
        financialTransactionService =
            LimaServiceFactory.getInstance().getService(
                    FinancialTransactionServiceMonitorable.class);
        
        financialTransactionSearch = new FinancialTransactionSearchImpl();
        
    }
    
    public void setBeginDate(Date beginDate){
        financialTransactionSearch.setBeginDate(beginDate);
    }
    
    public void setEndDate(Date endDate){
        financialTransactionSearch.setEndDate(endDate);
    }
    
    public void setVoucher(String voucher){

        String result = null;
        if (!voucher.equals("")){
            result = voucher;
        }
        financialTransactionSearch.setVoucher(result);
    }
    
    public void setDescription(String description){
        String result = null;
        if (!description.equals("")){
            result = description;
        }
        financialTransactionSearch.setDescription(result);
    }
    
    public void setLetter(Letter letter){
        financialTransactionSearch.setLetter(letter);
    }
    
    public String getAccountsList(){
        return financialTransactionSearch.getAccountList();
    }
    
    public void setAccountsList(String accountsList){
        String result = null;
        if (!accountsList.equals("")){
            result = accountsList;
        }
        financialTransactionSearch.setAccountList(result);
    }

    public Account getAccount(){
        return financialTransactionSearch.getAccount();
    }
    
    public void setAccount(Account account){
        financialTransactionSearch.setAccount(account);
    }
    
    public void setEntryBook(EntryBook entryBook){
        financialTransactionSearch.setEntryBook(entryBook);
    }

    
    public String getAmount(){
        return financialTransactionSearch.getAmount();
    }
    
    public void setAmount(String amount){
        String result = null;
        if (!amount.equals("")){
            result = amount;
        }
        financialTransactionSearch.setAmount(result);
    }
    
    public String getAmount2(){
        return financialTransactionSearch.getAmount2();
    }
    
    public void setAmount2(String amount2){
        String result = null;
        if (!amount2.equals("")){
            result = amount2;
        }
        financialTransactionSearch.setAmount2(result);
    }
    
    public void setAmountWayEnum(FinancialStatementWayEnum amountWayEnum){
        financialTransactionSearch.setAmountWayEnum(amountWayEnum);
    }

    public void setOperator(String operator){
        String result = null;
        if (!operator.equals("")){
            result = operator;
        }
        financialTransactionSearch.setOperator(result);
    }


    public void refresh(){
        tableModel = view.getFinancialTransactionSearchTableModel();
        if (tableModel != null){
            tableModel.refresh(financialTransactionSearch);
        }
    }

}
