/*
 * #%L
 * Lima Swing
 * 
 * $Id: ComboBoxOperatorsEnum.java 3051 2010-11-29 14:57:16Z echatellier $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.4.3/lima-swing/src/main/java/org/chorem/lima/enums/ComboBoxOperatorsEnum.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.enums;

import static org.nuiton.i18n.I18n._;


public enum ComboBoxOperatorsEnum {

    EQUAL(_("lima.enum.comboboxoperator.equal"), "="),
    SUPERIOR_OR_EQUAL(_("lima.enum.comboboxoperator.superiororequal"), ">="),
    INFERIOR_OR_EQUAL(_("lima.enum.comboboxoperator.inferiororequal"), "<="),
    SUPERIOR(_("lima.enum.comboboxoperator.superior"), ">"),
    INFERIOR(_("lima.enum.comboboxoperator.inferior"), "<"),
    INTERVAL(_("lima.enum.comboboxoperator.interval"), ""),
    NOT_EQUAL(_("lima.enum.comboboxoperator.notequal"),"!=");
    
    private final String description;
    private final String symbol;
    
    private ComboBoxOperatorsEnum(String description, String symbol) {
        this.description = description;
        this.symbol = symbol;
    }
    
    public String getDescription() {
        return this.description;
    }
    
    public String getSymbol(){
        return this.symbol;
    }
    
    public static String[] descriptions(){
        int nbElts = ComboBoxOperatorsEnum.values().length;
        String[] descriptions = new String[nbElts];
        ComboBoxOperatorsEnum[] enums = ComboBoxOperatorsEnum.values();
        for (int i = 0; i < nbElts; i++) {
            descriptions[i] = enums[i].getDescription();
        }
        return descriptions;
    }

    
    public static ComboBoxOperatorsEnum valueOfDescription(String description){
        ComboBoxOperatorsEnum value = null;
        
        for (ComboBoxOperatorsEnum enums : ComboBoxOperatorsEnum.values()) {
            if (description.equals(enums.description)){
                value = enums;
                break;
            }
        }
        return value;
    }
}
