/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.ledger;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.beans.ReportsDatas;
import org.chorem.lima.entity.Entry;
import org.nuiton.i18n.I18n;

public class LedgerTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(LedgerTableModel.class);
    protected List<Object> cacheDataList;

    @Override
    public int getRowCount() {
        int result = 0;
        if (this.cacheDataList != null) {
            result = this.cacheDataList.size();
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public String getColumnName(int column) {
        String res = "n/a";
        switch (column) {
            case 0: {
                res = I18n._((String)"lima.table.account");
                break;
            }
            case 1: {
                res = I18n._((String)"lima.table.date");
                break;
            }
            case 2: {
                res = I18n._((String)"lima.table.entrybook");
                break;
            }
            case 3: {
                res = I18n._((String)"lima.table.voucher");
                break;
            }
            case 4: {
                res = I18n._((String)"lima.table.description");
                break;
            }
            case 5: {
                res = I18n._((String)"lima.table.debit");
                break;
            }
            case 6: {
                res = I18n._((String)"lima.table.credit");
                break;
            }
            case 7: {
                res = I18n._((String)"lima.table.solde");
            }
        }
        return res;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object result = null;
        if (this.cacheDataList != null) {
            result = this.cacheDataList.get(row);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd MMMMM yyyy");
            if (result instanceof ReportsDatas) {
                ReportsDatas currentRow = (ReportsDatas)result;
                BigDecimal amountDebit = currentRow.getAmountDebit();
                BigDecimal amountCredit = currentRow.getAmountCredit();
                switch (column) {
                    case 0: {
                        if (currentRow.getAccount() != null) {
                            result = currentRow.getAccount().getAccountNumber();
                            break;
                        }
                        result = null;
                        break;
                    }
                    case 1: {
                        result = null;
                        break;
                    }
                    case 2: {
                        result = null;
                        break;
                    }
                    case 3: {
                        result = null;
                        break;
                    }
                    case 4: {
                        result = null;
                        break;
                    }
                    case 5: {
                        result = amountDebit;
                        break;
                    }
                    case 6: {
                        result = amountCredit;
                        break;
                    }
                    case 7: {
                        result = amountDebit.subtract(amountCredit);
                    }
                }
            } else if (result instanceof Entry) {
                Entry currentRow = (Entry)result;
                BigDecimal amountDebit = new BigDecimal(0);
                BigDecimal amountCredit = new BigDecimal(0);
                if (currentRow.getDebit()) {
                    amountDebit = currentRow.getAmount();
                } else {
                    amountCredit = currentRow.getAmount();
                }
                switch (column) {
                    case 0: {
                        result = null;
                        break;
                    }
                    case 1: {
                        result = simpleDateFormat.format(currentRow.getFinancialTransaction().getTransactionDate());
                        break;
                    }
                    case 2: {
                        if (currentRow.getFinancialTransaction().getEntryBook() != null) {
                            result = currentRow.getFinancialTransaction().getEntryBook().getCode();
                            break;
                        }
                        result = null;
                        break;
                    }
                    case 3: {
                        result = currentRow.getVoucher();
                        break;
                    }
                    case 4: {
                        result = currentRow.getDescription();
                        break;
                    }
                    case 5: {
                        result = amountDebit;
                        break;
                    }
                    case 6: {
                        result = amountCredit;
                        break;
                    }
                    case 7: {
                        result = amountDebit.subtract(amountCredit);
                    }
                }
            }
        }
        return result;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void refresh(List<Object> datasList) {
        this.cacheDataList = datasList;
        this.fireTableDataChanged();
    }
}

